/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.heap.Field;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.oql.engine.api.ReferenceChain;
import org.netbeans.modules.profiler.oql.engine.api.impl.ReachableExcludes;
import org.netbeans.modules.profiler.oql.engine.api.impl.TreeIterator;

public class Snapshot {
    private final Heap delegate;
    private JavaClass weakReferenceClass;
    private int referentFieldIndex;
    private ReachableExcludes reachableExcludes;

    public Snapshot(Heap heap) {
        this.delegate = heap;
        this.init();
    }

    private void init() {
        this.weakReferenceClass = this.findClass("java.lang.ref.Reference");
        if (this.weakReferenceClass == null) {
            this.weakReferenceClass = this.findClass("sun.misc.Ref");
            this.referentFieldIndex = 0;
        } else {
            List flds = this.weakReferenceClass.getFields();
            int fldsCount = flds.size();
            for (int i = 0; i < fldsCount; ++i) {
                if (!"referent".equals(((Field)flds.get(i)).getName())) continue;
                this.referentFieldIndex = i;
                break;
            }
        }
    }

    public int getMinimumObjectSize() {
        return 4;
    }

    public JavaClass findClass(String name) {
        try {
            long classId = name.startsWith("0x") ? Long.parseLong(name.substring(2), 16) : Long.parseLong(name);
            return this.delegate.getJavaClassByID(classId);
        }
        catch (NumberFormatException numberFormatException) {
            return this.delegate.getJavaClassByName(this.preprocessClassName(name));
        }
    }

    private String preprocessClassName(String className) {
        int arrDim = 0;
        if (className.startsWith("[")) {
            arrDim = className.lastIndexOf("[") + 1;
            className = className.substring(arrDim);
        }
        if (className.length() == 1) {
            if (className.equals("I")) {
                className = "int";
            } else if (className.equals("J")) {
                className = "long";
            } else if (className.equals("D")) {
                className = "double";
            } else if (className.equals("F")) {
                className = "float";
            } else if (className.equals("B")) {
                className = "byte";
            } else if (className.equals("S")) {
                className = "short";
            } else if (className.equals("C")) {
                className = "char";
            } else if (className.equals("Z")) {
                className = "boolean";
            }
        }
        if (arrDim > 0 && className.startsWith("L")) {
            className = className.substring(1);
        }
        StringBuilder sb = new StringBuilder(className);
        for (int i = 0; i < arrDim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public Instance findThing(long objectId) {
        return this.delegate.getInstanceByID(objectId);
    }

    public GCRoot findRoot(Instance object) {
        Instance gcInstance = object;
        while (!(gcInstance = gcInstance.getNearestGCRootPointer()).isGCRoot()) {
        }
        if (gcInstance != null) {
            return this.delegate.getGCRoot(gcInstance);
        }
        return null;
    }

    public Iterator getClasses() {
        return this.delegate.getAllClasses().iterator();
    }

    public Iterator getClassNames(String regex) {
        final Iterator delegated = this.delegate.getJavaClassesByRegExp(regex).iterator();
        return new Iterator(){

            @Override
            public boolean hasNext() {
                return delegated.hasNext();
            }

            public Object next() {
                return ((JavaClass)delegated.next()).getName();
            }

            @Override
            public void remove() {
                delegated.remove();
            }
        };
    }

    public Iterator getInstances(JavaClass clazz, final boolean includeSubclasses) {
        return new TreeIterator<Instance, JavaClass>(clazz){

            @Override
            protected Iterator<Instance> getSameLevelIterator(JavaClass popped) {
                return popped.getInstances().iterator();
            }

            @Override
            protected Iterator<JavaClass> getTraversingIterator(JavaClass popped) {
                return includeSubclasses ? popped.getSubClasses().iterator() : Collections.EMPTY_LIST.iterator();
            }
        };
    }

    public Iterator getReferrers(Instance obj) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List references = null;
        references = obj.getReferences();
        if (references != null) {
            for (Value val : references) {
                instances.add(val.getDefiningInstance());
            }
        }
        return instances.iterator();
    }

    public Iterator getReferees(Object obj) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        List values = null;
        if (obj instanceof Instance) {
            values = ((Instance)obj).getFieldValues();
        } else if (obj instanceof JavaClass) {
            values = ((JavaClass)obj).getStaticFieldValues();
        }
        if (values != null) {
            for (Object value : values) {
                if (!(value instanceof ObjectFieldValue)) continue;
                instances.add(((ObjectFieldValue)value).getInstance());
            }
        }
        return instances.iterator();
    }

    public Iterator getReferees(JavaClass clz) {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (Object value : clz.getStaticFieldValues()) {
            if (!(value instanceof ObjectFieldValue)) continue;
            instances.add(((ObjectFieldValue)value).getInstance());
        }
        return instances.iterator();
    }

    public JavaClass[] getClassesArray() {
        return (JavaClass[])this.delegate.getAllClasses().toArray();
    }

    public Iterator getFinalizerObjects() {
        JavaClass clazz = this.findClass("java.lang.ref.Finalizer");
        Instance queue = ((ObjectFieldValue)clazz.getValueOfStaticField("queue")).getInstance();
        ObjectFieldValue headFld = (ObjectFieldValue)queue.getValueOfField("head");
        ArrayList<Instance> finalizables = new ArrayList<Instance>();
        if (headFld != null) {
            Instance head = headFld.getInstance();
            while (true) {
                ObjectFieldValue referentFld = (ObjectFieldValue)head.getValueOfField("referent");
                ObjectFieldValue nextFld = (ObjectFieldValue)head.getValueOfField("next");
                if (nextFld == null || nextFld.getInstance().equals(head)) break;
                head = nextFld.getInstance();
                finalizables.add(referentFld.getInstance());
            }
        }
        return finalizables.iterator();
    }

    public Iterator getRoots() {
        return this.delegate.getGCRoots().iterator();
    }

    public GCRoot[] getRootsArray() {
        return (GCRoot[])this.delegate.getGCRoots().toArray();
    }

    public ReferenceChain[] rootsetReferencesTo(Instance target, boolean includeWeak) {
        LinkedList<ReferenceChain> fifo = new LinkedList<ReferenceChain>();
        HashMap<Instance, Instance> visited = new HashMap<Instance, Instance>();
        ArrayList<ReferenceChain> result = new ArrayList<ReferenceChain>();
        visited.put(target, target);
        fifo.add(new ReferenceChain(target, null));
        ReferenceChain chain = null;
        do {
            if ((chain = (ReferenceChain)fifo.poll()) == null) continue;
            Instance curr = chain.getObj();
            if (curr.isGCRoot()) {
                result.add(chain);
            }
            List<Instance> referers = this.getReferers(curr);
            for (Instance t : referers) {
                if (t == null || visited.containsKey(t) || !includeWeak && this.refersOnlyWeaklyTo(t, curr)) continue;
                visited.put(t, t);
                fifo.add(new ReferenceChain(t, chain));
            }
        } while (chain != null);
        return result.toArray(new ReferenceChain[result.size()]);
    }

    private List<Instance> getReferers(Instance instance) {
        ArrayList<Instance> referers = new ArrayList<Instance>();
        for (Object fldObj : instance.getReferences()) {
            if (!(fldObj instanceof Value)) continue;
            referers.add(((Value)fldObj).getDefiningInstance());
        }
        return referers;
    }

    private boolean refersOnlyWeaklyTo(Instance from, Instance to) {
        if (this.getWeakReferenceClass() != null && this.isAssignable(this.getWeakReferenceClass(), from.getJavaClass())) {
            FieldValue[] flds = (FieldValue[])from.getFieldValues().toArray();
            for (int i = 0; i < flds.length; ++i) {
                if (i == this.referentFieldIndex || !(flds[i] instanceof ObjectFieldValue) || ((ObjectFieldValue)flds[i]).getInstance() != to) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isAssignable(JavaClass from, JavaClass to) {
        if (from == to) {
            return true;
        }
        if (from == null) {
            return false;
        }
        return this.isAssignable(from.getSuperClass(), to);
    }

    public JavaClass getWeakReferenceClass() {
        return this.weakReferenceClass;
    }

    public int getReferentFieldIndex() {
        return this.referentFieldIndex;
    }

    public void setReachableExcludes(ReachableExcludes e) {
        this.reachableExcludes = e;
    }

    public ReachableExcludes getReachableExcludes() {
        return this.reachableExcludes;
    }

    public String valueString(Instance instance) {
        if (instance == null) {
            return null;
        }
        try {
            if (instance.getJavaClass().getName().equals(String.class.getName())) {
                Class<?> proxy = Class.forName("org.netbeans.lib.profiler.heap.HprofProxy");
                Method method = proxy.getDeclaredMethod("getString", Instance.class);
                method.setAccessible(true);
                return (String)method.invoke(proxy, instance);
            }
            if (instance.getJavaClass().getName().equals("char[]")) {
                Method method = instance.getClass().getDeclaredMethod("getChars", Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                char[] chars = (char[])method.invoke((Object)instance, 0, ((PrimitiveArrayInstance)instance).getLength());
                if (chars != null) {
                    return new String(chars);
                }
                return "*null*";
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Snapshot.class.getName()).log(Level.WARNING, "Error getting toString() value of an instance dump", ex);
        }
        return instance.toString();
    }
}

