/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.libs.bugtracking;

import java.io.File;
import java.util.logging.Logger;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.tasks.core.RepositoryExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.internal.tasks.core.externalization.ExternalizationManager;
import org.eclipse.mylyn.internal.tasks.core.externalization.IExternalizationParticipant;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

public final class BugtrackingRuntime {
    private static BugtrackingRuntime instance;
    public static final Logger LOG;
    private final String DATA_DIRECTORY = "bugtracking";
    private File cacheStore;
    private ExternalizationManager externalizationManager;
    private TaskRepositoryManager taskRepositoryManager;
    private TaskDataStore taskDataStore;
    private TaskDataManager taskDataManager;
    private SynchronizationSession synchronizationSession;

    private BugtrackingRuntime() {
        this.initCacheStore();
        this.initWebUtil();
        this.taskRepositoryManager = new TaskRepositoryManager();
        this.taskDataStore = new TaskDataStore((IRepositoryManager)this.taskRepositoryManager);
        TaskList tl = new TaskList();
        TaskActivityManager tam = new TaskActivityManager(this.taskRepositoryManager, tl);
        this.taskDataManager = new TaskDataManager(this.taskDataStore, (IRepositoryManager)this.taskRepositoryManager, tl, tam);
        this.taskDataManager.setDataPath(this.getCacheStore().getAbsolutePath());
        this.synchronizationSession = new SynchronizationSession(this.taskDataManager);
        this.externalizationManager = new ExternalizationManager(this.cacheStore.getAbsolutePath());
        RepositoryExternalizationParticipant repositoryParticipant = new RepositoryExternalizationParticipant(this.externalizationManager, this.taskRepositoryManager);
        this.externalizationManager.addParticipant((IExternalizationParticipant)repositoryParticipant);
        LOG.fine("Bugtracking runtime initialized");
    }

    public static synchronized BugtrackingRuntime getInstance() {
        if (instance == null) {
            instance = new BugtrackingRuntime();
        }
        return instance;
    }

    public static synchronized void init() {
        BugtrackingRuntime.getInstance();
    }

    private void initWebUtil() {
        WebUtil.init();
    }

    public void addRepositoryConnector(AbstractRepositoryConnector rc) {
        this.taskRepositoryManager.addRepositoryConnector(rc);
    }

    public SynchronizationSession getSynchronizationSession() {
        return this.synchronizationSession;
    }

    public TaskRepositoryManager getTaskRepositoryManager() {
        return this.taskRepositoryManager;
    }

    public TaskDataManager getTaskDataManager() {
        return this.taskDataManager;
    }

    public File getCacheStore() {
        return this.cacheStore;
    }

    private void initCacheStore() {
        String userDir = System.getProperty("netbeans.user");
        if (userDir != null) {
            this.cacheStore = new File(new File(new File(userDir, "var"), "cache"), "bugtracking");
        } else {
            File cachedir = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            this.cacheStore = new File(cachedir, "bugtracking");
        }
        this.cacheStore.mkdirs();
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.libs.bugtracking.BugtrackingRuntime");
    }
}

