/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import org.netbeans.modules.css.editor.Property;
import org.openide.util.NbBundle;

public class PropertyModel {
    private static PropertyModel instance;
    private Map<String, Property> properties;
    private int group_index;

    public static synchronized PropertyModel instance() {
        if (instance == null) {
            instance = new PropertyModel("org/netbeans/modules/css/resources/css_property_table");
        }
        return instance;
    }

    private PropertyModel(String sourcePath) {
        this.parseSource(sourcePath);
    }

    public Collection<Property> properties() {
        return this.properties.values();
    }

    public Property getProperty(String name) {
        return this.properties.get(name.toLowerCase());
    }

    private void parseSource(String sourcePath) {
        ResourceBundle bundle = NbBundle.getBundle((String)sourcePath);
        this.properties = new HashMap<String, Property>();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String name = keys.nextElement();
            String value = bundle.getString(name);
            StringTokenizer st = new StringTokenizer(value, ";");
            String values = st.nextToken();
            String initialValue = st.nextToken().trim();
            String appliedTo = st.nextToken().trim();
            boolean inherited = Boolean.parseBoolean(st.nextToken());
            String percentages = st.nextToken().trim();
            String mediaGroups = st.nextToken();
            ArrayList<String> mediaGroupsList = new ArrayList<String>();
            StringTokenizer st3 = new StringTokenizer(mediaGroups, ",");
            while (st3.hasMoreTokens()) {
                mediaGroupsList.add(st3.nextToken());
            }
            if (st.hasMoreTokens()) {
                Logger.global.warning("Error in source for css properties model for property: " + name);
            }
            StringTokenizer nameTokenizer = new StringTokenizer(name, ";");
            while (nameTokenizer.hasMoreTokens()) {
                String parsed_name = nameTokenizer.nextToken().trim();
                Property prop = new Property(parsed_name, initialValue, values, appliedTo, inherited, percentages, mediaGroupsList);
                this.properties.put(parsed_name, prop);
            }
        }
    }

    GroupElement parse(String expresssion) {
        return this.parse(expresssion, null);
    }

    GroupElement parse(String expression, String propertyName) {
        this.group_index = 0;
        GroupElement root = new GroupElement(null, this.group_index, propertyName);
        ParserInput input = new ParserInput(expression);
        this.group_index = 0;
        this.parseElements(input, root, false);
        return root;
    }

    private void parseElements(ParserInput input, GroupElement parent, boolean ignoreInherits) {
        Element last = null;
        char c;
        block13: while ((c = input.read()) != '\uffff') {
            StringBuffer buf;
            switch (c) {
                case '\t': 
                case ' ': {
                    continue block13;
                }
                case '[': {
                    last = new GroupElement(parent, ++this.group_index);
                    this.parseElements(input, (GroupElement)last, false);
                    parent.addElement(last);
                    continue block13;
                }
                case '|': {
                    char next = input.read();
                    if (next != '|') continue block13;
                    parent.setIsList(true);
                    continue block13;
                }
                case '>': {
                    parent.setIsSequence(true);
                    continue block13;
                }
                case ']': {
                    return;
                }
                case '\'': {
                    buf = new StringBuffer();
                    while ((c = input.read()) != '\'') {
                        buf.append(c);
                    }
                    String referredElementName = buf.toString();
                    Property p = this.getProperty(referredElementName);
                    if (p == null) {
                        throw new IllegalStateException("no referred element '" + referredElementName + "' found!");
                    }
                    last = new GroupElement(parent, ++this.group_index, referredElementName);
                    ParserInput pinput = new ParserInput(p.valuesText());
                    this.parseElements(pinput, (GroupElement)last, true);
                    parent.addElement(last);
                    continue block13;
                }
                case '!': {
                    buf = new StringBuffer();
                    while ((c = input.read()) != '\uffff') {
                        if (PropertyModel.isEndOfValueChar(c)) {
                            input.backup(1);
                            break;
                        }
                        buf.append(c);
                    }
                    last = new ValueElement(parent);
                    ((ValueElement)last).setValue(buf.toString());
                    ((ValueElement)last).setIsUnit(true);
                    parent.addElement(last);
                    continue block13;
                }
                case '{': {
                    StringBuffer text = new StringBuffer();
                    while ((c = input.read()) != '}') {
                        text.append(c);
                    }
                    StringTokenizer st = new StringTokenizer(text.toString(), ",");
                    int min = Integer.parseInt(st.nextToken());
                    int max = Integer.parseInt(st.nextToken());
                    last.setMinimumOccurances(min);
                    last.setMaximumOccurances(max);
                    continue block13;
                }
                case '+': {
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '*': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(Integer.MAX_VALUE);
                    continue block13;
                }
                case '?': {
                    last.setMinimumOccurances(0);
                    last.setMaximumOccurances(1);
                    continue block13;
                }
            }
            buf = new StringBuffer();
            while (c != '\uffff') {
                if (PropertyModel.isEndOfValueChar(c)) {
                    input.backup(1);
                    break;
                }
                buf.append(c);
                c = input.read();
            }
            String image = buf.toString();
            if (ignoreInherits && "inherit".equalsIgnoreCase(image)) continue;
            last = new ValueElement(parent);
            ((ValueElement)last).setValue(image);
            ((ValueElement)last).setIsUnit(false);
            parent.addElement(last);
        }
        return;
    }

    private static boolean isEndOfValueChar(char c) {
        return c == ' ' || c == '+' || c == '?' || c == '{' || c == '[' || c == ']' || c == '|';
    }

    public static class GroupElement
    extends Element {
        private int index;
        private String referenceName = null;
        private List<Element> elements = new ArrayList<Element>(5);
        private boolean list = false;
        private boolean sequence = false;

        private GroupElement(GroupElement parent, int index, String referenceName) {
            this(parent, index);
            this.referenceName = referenceName;
        }

        private GroupElement(GroupElement parent, int index) {
            super(parent);
            this.index = index;
        }

        public boolean isList() {
            return this.list;
        }

        public boolean isSequence() {
            return this.sequence;
        }

        void setIsList(boolean isList) {
            this.list = isList;
        }

        void setIsSequence(boolean isSequence) {
            this.sequence = isSequence;
        }

        public List<Element> elements() {
            return this.elements;
        }

        void addElement(Element element) {
            this.elements.add(element);
        }

        public List<Element> getAllPossibleValues() {
            ArrayList<Element> list = new ArrayList<Element>(10);
            if (this.isSequence()) {
                Element e = this.elements.get(0);
                if (e instanceof GroupElement) {
                    list.addAll(((GroupElement)e).getAllPossibleValues());
                } else {
                    list.add(e);
                }
            } else {
                for (Element e : this.elements()) {
                    if (e instanceof GroupElement) {
                        list.addAll(((GroupElement)e).getAllPossibleValues());
                        continue;
                    }
                    list.add(e);
                }
            }
            return list;
        }

        @Override
        public String toString2(int level) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.indentString(level) + "[G" + this.index + " ");
            if (this.referenceName != null) {
                sb.append("(" + this.referenceName + ") ");
            }
            if (this.sequence) {
                sb.append("SEQUENCE");
            } else if (this.list) {
                sb.append("ANY: ");
            } else {
                sb.append("ONE: ");
            }
            sb.append('\n');
            for (Element e : this.elements()) {
                sb.append(e.toString2(level + 1));
                sb.append('\n');
            }
            sb.append(this.indentString(level));
            sb.append(']');
            sb.append(super.toString());
            return sb.toString();
        }

        @Override
        public String toString() {
            return "[G" + this.index + "]";
        }
    }

    public static class ValueElement
    extends Element {
        private boolean isUnit = false;
        private String value = null;

        public ValueElement(GroupElement parent) {
            super(parent);
        }

        public boolean isUnit() {
            return this.isUnit;
        }

        void setIsUnit(boolean isUnit) {
            this.isUnit = isUnit;
        }

        public String value() {
            return this.value;
        }

        void setValue(String value) {
            this.value = value;
        }

        @Override
        public String toString() {
            return (this.isUnit() ? "!" : "") + this.value() + super.toString();
        }
    }

    public static abstract class Element {
        private GroupElement parent;
        private int minimum_occurances = 1;
        private int maximum_occurances = 1;

        public Element(GroupElement parent) {
            this.parent = parent;
        }

        void setMinimumOccurances(int i) {
            this.minimum_occurances = i;
        }

        void setMaximumOccurances(int i) {
            this.maximum_occurances = i;
        }

        public int getMaximumOccurances() {
            return this.maximum_occurances;
        }

        public int getMinimumOccurances() {
            return this.minimum_occurances;
        }

        public GroupElement parent() {
            return this.parent;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Element)) {
                return false;
            }
            Element e = (Element)o;
            return this.path().equalsIgnoreCase(e.path());
        }

        public String origin() {
            for (GroupElement p = this.parent; p != null; p = p.parent()) {
                if (p.referenceName == null) continue;
                return p.referenceName;
            }
            return null;
        }

        public String getResolvedOrigin() {
            String origin = this.origin();
            if (origin == null) {
                return null;
            }
            if (origin.startsWith("-")) {
                Element parentElement = this;
                while ((parentElement = parentElement.parent()) != null) {
                    if (parentElement.origin() == null || parentElement.origin().startsWith("-")) continue;
                    origin = parentElement.origin();
                    break;
                }
            }
            return origin;
        }

        public String path() {
            StringBuffer sb = new StringBuffer();
            if (this.parent() != null) {
                sb.append(this.parent().path());
                sb.append('/');
            }
            sb.append(this.toString());
            return sb.toString();
        }

        public String toString() {
            if (this.getMinimumOccurances() != 1 || this.getMaximumOccurances() != 1) {
                return "{" + this.getMinimumOccurances() + "," + (this.getMaximumOccurances() == Integer.MAX_VALUE ? "inf" : Integer.valueOf(this.getMaximumOccurances())) + "}";
            }
            return "";
        }

        public String toString2(int level) {
            return this.indentString(level) + this.toString();
        }

        protected String indentString(int level) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < level; ++i) {
                sb.append('\t');
            }
            return sb.toString();
        }
    }

    private static class ParserInput {
        CharSequence text;
        private int pos = 0;

        private ParserInput(CharSequence text) {
            this.text = text;
        }

        public char read() {
            if (this.pos == this.text.length()) {
                return '\uffff';
            }
            return this.text.charAt(this.pos++);
        }

        public void backup(int chars) {
            this.pos -= chars;
        }
    }
}

