/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.indexing;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.css.gsf.CssGSFParser;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.indexing.CssIndex;
import org.netbeans.modules.css.parser.NodeVisitor;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.css.parser.Token;
import org.netbeans.modules.css.refactoring.api.Entry;
import org.netbeans.modules.css.refactoring.api.RefactoringElementType;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class CssFileModel {
    private static final Logger LOGGER = Logger.getLogger(CssIndex.class.getSimpleName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);
    private static final Pattern URI_PATTERN = Pattern.compile("url\\(\\s*(.*)\\s*\\)");
    private Collection<Entry> classes;
    private Collection<Entry> ids;
    private Collection<Entry> htmlElements;
    private Collection<Entry> imports;
    private Collection<Entry> colors;
    private final Snapshot snapshot;
    private final Snapshot topLevelSnapshot;
    private SimpleNode parseTreeRoot;

    public static CssFileModel create(Source source) throws ParseException {
        final AtomicReference result = new AtomicReference();
        final AtomicReference snapshot = new AtomicReference();
        ParserManager.parse(Collections.singletonList(source), (UserTask)new UserTask(){

            public void run(ResultIterator resultIterator) throws Exception {
                ResultIterator cssRi = WebUtils.getResultIterator((ResultIterator)resultIterator, (String)"text/x-css");
                snapshot.set(resultIterator.getSnapshot());
                result.set(cssRi == null ? null : (CssParserResult)cssRi.getParserResult());
            }
        });
        return result.get() == null ? null : new CssFileModel((CssParserResult)((Object)result.get()), (Snapshot)snapshot.get());
    }

    public static CssFileModel create(CssParserResult result) {
        return new CssFileModel(result, null);
    }

    private CssFileModel(CssParserResult parserResult, Snapshot topLevelSnapshot) {
        this.snapshot = parserResult.getSnapshot();
        this.parseTreeRoot = parserResult.root();
        this.topLevelSnapshot = topLevelSnapshot;
        if (this.parseTreeRoot != null) {
            SimpleNodeUtil.visitChildren(this.parseTreeRoot, new AstVisitor());
        }
    }

    public Snapshot getSnapshot() {
        return this.snapshot;
    }

    public Snapshot getTopLevelSnapshot() {
        return this.topLevelSnapshot;
    }

    public FileObject getFileObject() {
        return this.getSnapshot().getSource().getFileObject();
    }

    public Collection<Entry> get(RefactoringElementType type) {
        switch (type) {
            case CLASS: {
                return this.getClasses();
            }
            case ID: {
                return this.getIds();
            }
            case COLOR: {
                return this.getColors();
            }
            case ELEMENT: {
                return this.htmlElements;
            }
            case IMPORT: {
                return this.imports;
            }
        }
        return null;
    }

    public Collection<Entry> getClasses() {
        return this.classes == null ? Collections.emptyList() : this.classes;
    }

    public Collection<Entry> getIds() {
        return this.ids == null ? Collections.emptyList() : this.ids;
    }

    public Collection<Entry> getHtmlElements() {
        return this.htmlElements == null ? Collections.emptyList() : this.htmlElements;
    }

    public Collection<Entry> getImports() {
        return this.imports == null ? Collections.emptyList() : this.imports;
    }

    public Collection<Entry> getColors() {
        return this.colors == null ? Collections.emptyList() : this.colors;
    }

    public boolean isEmpty() {
        return null == this.classes && null == this.ids && null == this.htmlElements && null == this.imports && null == this.colors;
    }

    private Collection<Entry> getClassesCollectionInstance() {
        if (this.classes == null) {
            this.classes = new ArrayList<Entry>();
        }
        return this.classes;
    }

    private Collection<Entry> getIdsCollectionInstance() {
        if (this.ids == null) {
            this.ids = new ArrayList<Entry>();
        }
        return this.ids;
    }

    private Collection<Entry> getHtmlElementsCollectionInstance() {
        if (this.htmlElements == null) {
            this.htmlElements = new ArrayList<Entry>();
        }
        return this.htmlElements;
    }

    private Collection<Entry> getImportsCollectionInstance() {
        if (this.imports == null) {
            this.imports = new ArrayList<Entry>();
        }
        return this.imports;
    }

    private Collection<Entry> getColorsCollectionInstance() {
        if (this.colors == null) {
            this.colors = new ArrayList<Entry>();
        }
        return this.colors;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        buf.append(":");
        for (Entry c : this.getImports()) {
            buf.append(" imports=");
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getClasses()) {
            buf.append('.');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getIds()) {
            buf.append('#');
            buf.append(c);
            buf.append(',');
        }
        for (Entry c : this.getHtmlElements()) {
            buf.append(c);
            buf.append(',');
        }
        return buf.toString();
    }

    private Entry createEntry(String name, OffsetRange range, boolean isVirtual) {
        return this.createEntry(name, range, null, isVirtual);
    }

    private Entry createEntry(String name, OffsetRange range, OffsetRange bodyRange, boolean isVirtual) {
        if (CssGSFParser.containsGeneratedCode(name)) {
            return null;
        }
        int documentFrom = this.getSnapshot().getOriginalOffset(range.getStart());
        int documentTo = this.getSnapshot().getOriginalOffset(range.getEnd());
        OffsetRange documentRange = null;
        OffsetRange documentBodyRange = null;
        CharSequence elementLineText = null;
        CharSequence elementText = null;
        int lineOffset = -1;
        if (documentFrom == -1 || documentTo == -1) {
            if (LOG) {
                LOGGER.finer("Ast offset range " + range.toString() + ", text='" + this.getSnapshot().getText().subSequence(range.getStart(), range.getEnd()) + "', " + " cannot be properly mapped to source offset range: [" + documentFrom + "," + documentTo + "] in file " + this.getFileObject().getPath());
            }
        } else {
            documentRange = new OffsetRange(documentFrom, documentTo);
            try {
                elementText = this.getSnapshot().getText().subSequence(range.getStart(), range.getEnd());
                int astLineStart = GsfUtilities.getRowStart((CharSequence)this.getSnapshot().getText(), (int)range.getStart());
                int astLineEnd = GsfUtilities.getRowEnd((CharSequence)this.getSnapshot().getText(), (int)range.getStart());
                elementLineText = this.getSnapshot().getText().subSequence(astLineStart, astLineEnd);
                if (this.topLevelSnapshot != null) {
                    lineOffset = LexerUtils.getLineOffset((CharSequence)this.topLevelSnapshot.getText(), (int)documentFrom);
                }
            }
            catch (BadLocationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (bodyRange != null) {
                int bodyDocFrom = this.getSnapshot().getOriginalOffset(bodyRange.getStart());
                int bodyDocTo = this.getSnapshot().getOriginalOffset(bodyRange.getEnd());
                if (bodyDocFrom != -1 && bodyDocTo != -1) {
                    documentBodyRange = new OffsetRange(bodyDocFrom, bodyDocTo);
                }
            }
        }
        return new Entry(name, range, documentRange, bodyRange, documentBodyRange, lineOffset, elementText, elementLineText, isVirtual);
    }

    private static int[] getTextWSPreAndPostLens(String text) {
        char c;
        int i;
        int preWSlen = 0;
        int postWSlen = 0;
        for (i = 0; i < text.length() && Character.isWhitespace(c = text.charAt(i)); ++i) {
            ++preWSlen;
        }
        for (i = text.length() - 1; i >= 0 && Character.isWhitespace(c = text.charAt(i)); --i) {
            ++postWSlen;
        }
        return new int[]{preWSlen, postWSlen};
    }

    private class AstVisitor
    implements NodeVisitor {
        private AstVisitor() {
        }

        @Override
        public void visit(SimpleNode node) {
            if (node.kind() == 6) {
                Entry entry = this.getImportedEntry(node);
                if (entry != null) {
                    CssFileModel.this.getImportsCollectionInstance().add(entry);
                }
            } else if (node.kind() == 23 || node.kind() == 27 || node.kind() == 24) {
                int start_offset_diff;
                Collection collection;
                SimpleNode styleRuleNode = SimpleNodeUtil.getAncestorByType(node, 19);
                OffsetRange body = null;
                if (styleRuleNode != null) {
                    Token first = styleRuleNode.jjtGetFirstToken();
                    Token last = styleRuleNode.jjtGetLastToken();
                    int from = -1;
                    do {
                        if (first.kind != 8) continue;
                        from = first.offset + 1;
                        break;
                    } while ((first = first.next) != last);
                    int to = styleRuleNode.jjtGetLastToken().offset;
                    if (from != -1 && to != -1) {
                        body = new OffsetRange(from, to);
                    }
                }
                switch (node.kind()) {
                    case 23: {
                        collection = CssFileModel.this.getClassesCollectionInstance();
                        start_offset_diff = 1;
                        break;
                    }
                    case 27: {
                        collection = CssFileModel.this.getIdsCollectionInstance();
                        start_offset_diff = 1;
                        break;
                    }
                    case 24: {
                        collection = CssFileModel.this.getHtmlElementsCollectionInstance();
                        start_offset_diff = 0;
                        break;
                    }
                    default: {
                        collection = null;
                        start_offset_diff = 0;
                    }
                }
                String image = node.image().substring(start_offset_diff);
                OffsetRange range = new OffsetRange(node.startOffset() + start_offset_diff, node.endOffset());
                boolean isVirtual = CssFileModel.this.getSnapshot().getOriginalOffset(node.startOffset()) == -1;
                Entry e = CssFileModel.this.createEntry(image, range, body, isVirtual);
                if (e != null) {
                    collection.add(e);
                }
            } else if (node.kind() == 35) {
                OffsetRange range;
                String image = SimpleNodeUtil.getNodeImage(node);
                int[] wsLens = CssFileModel.getTextWSPreAndPostLens(image);
                Entry e = CssFileModel.this.createEntry(image = image.substring(wsLens[0], image.length() - wsLens[1]), range = new OffsetRange(node.startOffset() + wsLens[0], node.endOffset() - wsLens[1]), false);
                if (e != null) {
                    CssFileModel.this.getColorsCollectionInstance().add(e);
                }
            }
        }

        private Entry getImportedEntry(SimpleNode node) {
            Matcher m;
            Token token = SimpleNodeUtil.getNodeToken(node, 23);
            if (token != null) {
                String image = token.image;
                boolean quoted = WebUtils.isValueQuoted((CharSequence)image);
                return CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)image), new OffsetRange(token.offset + (quoted ? 1 : 0), token.offset + image.length() - (quoted ? 1 : 0)), false);
            }
            token = SimpleNodeUtil.getNodeToken(node, 26);
            if (token != null && (m = URI_PATTERN.matcher(token.image)).matches()) {
                int groupIndex = 1;
                String content = m.group(groupIndex);
                boolean quoted = WebUtils.isValueQuoted((CharSequence)content);
                int from = token.offset + m.start(groupIndex) + (quoted ? 1 : 0);
                int to = token.offset + m.end(groupIndex) - (quoted ? 1 : 0);
                return CssFileModel.this.createEntry(WebUtils.unquotedValue((CharSequence)content), new OffsetRange(from, to), false);
            }
            return null;
        }
    }
}

