/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lexer.api;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.css.lexer.CssLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum CssTokenId implements TokenId
{
    EOF("others"),
    S("whitespace"),
    COMMENT("comment"),
    MSE("ms_expression"),
    LBRACE("brace"),
    RBRACE("brace"),
    COMMA("separator"),
    DOT("operator"),
    SEMICOLON("separator"),
    COLON("separator"),
    ASTERISK("operator"),
    SLASH("operator"),
    PLUS("operator"),
    MINUS("operator"),
    EQUALS("operator"),
    GT("operator"),
    LSQUARE("brace"),
    RSQUARE("brace"),
    HASH("hash"),
    STRING("string"),
    RROUND("brace"),
    URL("url"),
    URI("url"),
    GENERATED("others"),
    CDO("whitespace"),
    CDC("whitespace"),
    INCLUDES("operator"),
    CSS3_BEGINS("operator"),
    CSS3_ENDS("operator"),
    CSS3_CONTAINS("operator"),
    DASHMATCH("operator"),
    IMPORT_SYM("keyword"),
    PAGE_SYM("keyword"),
    MEDIA_SYM("keyword"),
    FONT_FACE_SYM("keyword"),
    CHARSET_SYM("keyword"),
    ATKEYWORD("keyword"),
    IMPORTANT_SYM("keyword"),
    INHERIT("keyword"),
    EMS("number"),
    EXS("number"),
    LENGTH_PX("number"),
    LENGTH_CM("number"),
    LENGTH_MM("number"),
    LENGTH_IN("number"),
    LENGTH_PT("number"),
    LENGTH_PC("number"),
    ANGLE_DEG("number"),
    ANGLE_RAD("number"),
    ANGLE_GRAD("number"),
    TIME_MS("number"),
    TIME_S("number"),
    FREQ_HZ("number"),
    FREQ_KHZ("number"),
    DIMEN("number"),
    PERCENTAGE("number"),
    NUMBER("number"),
    RGB("others"),
    FUNCTION("function"),
    IDENT("identifier"),
    NAME("mod-custom1"),
    NUM("number"),
    UNICODERANGE("others"),
    RANGE("others"),
    Q16("others"),
    Q15("others"),
    Q14("others"),
    Q13("others"),
    Q12("others"),
    Q11("others"),
    NMSTART("others"),
    NMCHAR("others"),
    SELECTOR_NMSTART("mod-method"),
    SELECTOR_NMCHAR("others"),
    STRING1("string"),
    STRING2("string"),
    NONASCII("others"),
    ESCAPE("others"),
    NL("others"),
    UNICODE("others"),
    HNUM("others"),
    H("others"),
    UNKNOWN("unknown");

    private final String primaryCategory;
    private static final String JAVASCRIPT_MIMETYPE = "text/javascript";
    private static final Language<CssTokenId> language;

    private CssTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public static Language<CssTokenId> language() {
        return language;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    static {
        language = new LanguageHierarchy<CssTokenId>(){

            protected Collection<CssTokenId> createTokenIds() {
                return EnumSet.allOf(CssTokenId.class);
            }

            protected Map<String, Collection<CssTokenId>> createTokenCategories() {
                HashMap<String, Collection<CssTokenId>> cats = new HashMap<String, Collection<CssTokenId>>();
                return cats;
            }

            protected Lexer<CssTokenId> createLexer(LexerRestartInfo<CssTokenId> info) {
                return new CssLexer(info);
            }

            protected LanguageEmbedding embedding(Token<CssTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                if (token.text() == null) {
                    return null;
                }
                if (token.id() == MSE) {
                    Language lang = Language.find((String)CssTokenId.JAVASCRIPT_MIMETYPE);
                    if (lang == null) {
                        return null;
                    }
                    String tokenImage = ((Object)token.text()).toString();
                    int lastParenthesisIndex = tokenImage.lastIndexOf(41);
                    return LanguageEmbedding.create((Language)lang, (int)11, (int)(token.length() - lastParenthesisIndex), (boolean)false);
                }
                return null;
            }

            protected String mimeType() {
                return "text/x-css";
            }
        }.language();
    }
}

