/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.refactoring;

import java.util.Collection;
import javax.swing.text.Document;
import org.netbeans.modules.css.gsf.api.CssParserResult;
import org.netbeans.modules.css.parser.SimpleNode;
import org.netbeans.modules.css.parser.SimpleNodeUtil;
import org.netbeans.modules.parsing.api.Snapshot;
import org.openide.filesystems.FileObject;

public abstract class CssElementContext {
    public abstract boolean isRefactoringAllowed();

    public abstract String getElementName();

    public abstract FileObject getFileObject();

    public static class Editor
    extends CssElementContext {
        private int caretOffset;
        private int selectionFrom;
        private int selectionTo;
        private SimpleNode element;
        private CssParserResult result;
        private Snapshot topLevelSnapshot;

        public Editor(CssParserResult result, Snapshot topLevelSnapshot, int caretOffset, int selectionFrom, int selectionTo) {
            this.result = result;
            this.caretOffset = caretOffset;
            this.selectionFrom = selectionFrom;
            this.selectionTo = selectionTo;
            this.element = this.findCurrentElement();
            this.topLevelSnapshot = topLevelSnapshot;
            assert (this.element != null);
        }

        private SimpleNode findCurrentElement() {
            int astOffset;
            SimpleNode root = this.getParserResult().root();
            SimpleNode leaf = SimpleNodeUtil.findDescendant(root, astOffset = this.getParserResult().getSnapshot().getEmbeddedOffset(this.caretOffset));
            return leaf == null ? root : leaf;
        }

        public Document getDocument() {
            return this.result.getSnapshot().getSource().getDocument(false);
        }

        public Snapshot getTopLevelSnapshot() {
            return this.topLevelSnapshot;
        }

        public CssParserResult getParserResult() {
            return this.result;
        }

        @Override
        public FileObject getFileObject() {
            return this.getParserResult().getSnapshot().getSource().getFileObject();
        }

        public int getCaret() {
            return this.caretOffset;
        }

        public int getSelectionFrom() {
            return this.selectionFrom;
        }

        public int getSelectionTo() {
            return this.selectionTo;
        }

        public SimpleNode getElement() {
            return this.element;
        }

        public SimpleNode getSimpleSelectorElement() {
            return SimpleNodeUtil.getAncestorByType(this.getElement(), 22);
        }

        @Override
        public String getElementName() {
            return SimpleNodeUtil.getNodeImage(this.getElement()).trim();
        }

        @Override
        public boolean isRefactoringAllowed() {
            return null != this.getSimpleSelectorElement() || this.getElement().kind() == 35;
        }
    }

    public static class File
    extends AbstractFileContext {
        private Collection<CssParserResult> results;

        public File(FileObject fileObject, Collection<CssParserResult> result) {
            super(fileObject);
            this.results = result;
        }

        public Collection<CssParserResult> getParserResults() {
            return this.results;
        }

        @Override
        public boolean isRefactoringAllowed() {
            return true;
        }
    }

    public static class Folder
    extends AbstractFileContext {
        public Folder(FileObject folder) {
            super(folder);
        }

        @Override
        public boolean isRefactoringAllowed() {
            return true;
        }
    }

    public static abstract class AbstractFileContext
    extends CssElementContext {
        private FileObject fo;

        public AbstractFileContext(FileObject fo) {
            this.fo = fo;
        }

        @Override
        public FileObject getFileObject() {
            return this.fo;
        }

        @Override
        public String getElementName() {
            return this.getFileObject().getName();
        }
    }
}

