/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.jsploader;

import java.io.IOException;
import org.netbeans.modules.web.core.jsploader.JspDataObject;
import org.netbeans.modules.web.core.jsploader.TagLibParseSupport;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.UniFileLoader;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class JspLoader
extends UniFileLoader {
    private static final long serialVersionUID = 1549250022027438942L;
    public static final String JSP_EXTENSION = "jsp";
    public static final String JSPF_EXTENSION = "jspf";
    public static final String JSF_EXTENSION = "jsf";
    public static final String JSPX_EXTENSION = "jspx";
    public static final String TAG_FILE_EXTENSION = "tag";
    public static final String TAGF_FILE_EXTENSION = "tagf";
    public static final String TAGX_FILE_EXTENSION = "tagx";
    public static final String JSP_MIME_TYPE = "text/x-jsp";
    public static final String TAG_MIME_TYPE = "text/x-tag";

    public static String getMimeType(JspDataObject jspDataObject) {
        if (jspDataObject == null || !(jspDataObject instanceof JspDataObject)) {
            return "";
        }
        String string = jspDataObject.getPrimaryFile().getExt();
        if (string.equals(TAG_FILE_EXTENSION) || string.equals(TAGF_FILE_EXTENSION) || string.equals(TAGX_FILE_EXTENSION)) {
            return TAG_MIME_TYPE;
        }
        return JSP_MIME_TYPE;
    }

    protected void initialize() {
        super.initialize();
        this.getExtensions().addMimeType(JSP_MIME_TYPE);
        this.getExtensions().addMimeType(TAG_MIME_TYPE);
    }

    protected String defaultDisplayName() {
        return NbBundle.getBundle(JspLoader.class).getString("PROP_JspLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-jsp/Actions/";
    }

    public JspLoader() {
        super("org.netbeans.modules.web.core.jsploader.JspDataObject");
    }

    protected JspLoader(String string) {
        super(string);
    }

    protected JspDataObject createJspObject(FileObject fileObject, UniFileLoader uniFileLoader) throws DataObjectExistsException {
        return new JspDataObject(fileObject, uniFileLoader);
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        JspDataObject jspDataObject = this.createJspObject(fileObject, this);
        jspDataObject.getCookieSet0().add((Node.Cookie)new TagLibParseSupport(fileObject));
        return jspDataObject;
    }
}

