/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.taglib;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.IllegalCharsetNameException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.web.taglib.TLDDataObject;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.windows.CloneableOpenSupport;

public class TLDEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditCookie,
EditorCookie.Observable,
PrintCookie,
CloseCookie {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            TLDEditorSupport.this.saveDocument();
        }
    };

    public void saveDocument() throws IOException {
        CharsetEncoder charsetEncoder;
        final StyledDocument styledDocument = this.getDocument();
        String string = "UTF-8";
        String string2 = EncodingUtil.detectEncoding((Document)styledDocument);
        boolean bl = false;
        if (string2 == null) {
            string2 = string;
        }
        if (!this.isSupportedEncoding(string2)) {
            charsetEncoder = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TLDEditorSupport.class, (String)"MSG_BadEncodingDuringSave", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2, string}), 0, 2);
            charsetEncoder.setValue(NotifyDescriptor.NO_OPTION);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)charsetEncoder);
            if (charsetEncoder.getValue() != NotifyDescriptor.YES_OPTION) {
                return;
            }
            bl = true;
        }
        if (!bl) {
            try {
                charsetEncoder = Charset.forName(string2).newEncoder();
                if (!charsetEncoder.canEncode(styledDocument.getText(0, styledDocument.getLength()))) {
                    NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(TLDEditorSupport.class, (String)"MSG_BadCharConversion", (Object[])new Object[]{this.getDataObject().getPrimaryFile().getNameExt(), string2}), 0, 2);
                    confirmation.setValue(NotifyDescriptor.NO_OPTION);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation);
                    if (confirmation.getValue() != NotifyDescriptor.YES_OPTION) {
                        return;
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
            super.saveDocument();
            this.getDataObject().setModified(false);
        } else {
            try {
                int n;
                int n2 = Math.min(1000, styledDocument.getLength());
                final char[] cArray = styledDocument.getText(0, n2).toCharArray();
                int n3 = 0;
                if (cArray[0] == '<' && cArray[1] == '?' && cArray[2] == 'x') {
                    for (n = 3; n < n2; ++n) {
                        if (cArray[n] != '?' || cArray[n + 1] != '>') continue;
                        n3 = n + 1;
                        break;
                    }
                }
                n = n3;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        block2: {
                            try {
                                styledDocument.remove(0, n + 1);
                                styledDocument.insertString(0, "<?xml version='1.0' encoding='UTF-8' ?> \n<!-- was: " + new String(cArray, 0, n + 1) + " -->", null);
                            }
                            catch (BadLocationException badLocationException) {
                                if (System.getProperty("netbeans.debug.exceptions") == null) break block2;
                                badLocationException.printStackTrace();
                            }
                        }
                    }
                };
                NbDocument.runAtomic((StyledDocument)styledDocument, (Runnable)runnable);
                super.saveDocument();
                this.getDataObject().setModified(false);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger("global").log(Level.INFO, null, badLocationException);
            }
        }
    }

    private boolean isSupportedEncoding(String string) {
        boolean bl;
        try {
            bl = Charset.isSupported(string);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            bl = false;
        }
        return bl;
    }

    public TLDEditorSupport(TLDDataObject tLDDataObject) {
        super((DataObject)tLDDataObject, (CloneableEditorSupport.Env)new XmlEnv(tLDDataObject));
        this.setMIMEType("text/xml");
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    private void addSaveCookie() {
        TLDDataObject tLDDataObject = (TLDDataObject)this.getDataObject();
        if (tLDDataObject.getCookie(SaveCookie.class) == null) {
            tLDDataObject.getCookieSet0().add((Node.Cookie)this.saveCookie);
            tLDDataObject.setModified(true);
        }
    }

    private void removeSaveCookie() {
        TLDDataObject tLDDataObject = (TLDDataObject)this.getDataObject();
        Node.Cookie cookie = tLDDataObject.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            tLDDataObject.getCookieSet0().remove((Node.Cookie)this.saveCookie);
            tLDDataObject.setModified(false);
        }
    }

    private static class XmlEnv
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = -800036748848958489L;

        public XmlEnv(TLDDataObject tLDDataObject) {
            super((DataObject)tLDDataObject);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((TLDDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (TLDEditorSupport)this.getDataObject().getCookie(TLDEditorSupport.class);
        }
    }
}

