/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.indent.project;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.project.ProxyPreferences;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ProjectAwareCodeStylePreferences
implements CodeStylePreferences.Provider {
    private static final Logger LOG = Logger.getLogger(ProjectAwareCodeStylePreferences.class.getName());
    private static final CodeStylePreferences.Provider singleton = new CodeStylePreferences.Provider(){
        private final Map<Object, Map<String, Csp>> cache = new WeakHashMap<Object, Map<String, Csp>>();

        public Preferences forFile(FileObject file, String mimeType) {
            return this.getCsp(file, mimeType).getPreferences();
        }

        public Preferences forDocument(Document doc, String mimeType) {
            return this.getCsp(doc, mimeType).getPreferences();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Csp getCsp(Object obj, String mimeType) {
            Map<Object, Map<String, Csp>> map = this.cache;
            synchronized (map) {
                Csp csp;
                Map<String, Csp> csps = this.cache.get(obj);
                Csp csp2 = csp = csps != null ? csps.get(mimeType) : null;
                if (csp == null) {
                    FileObject file;
                    Document doc;
                    if (obj instanceof FileObject) {
                        doc = null;
                        file = (FileObject)obj;
                    } else {
                        doc = (Document)obj;
                        file = ProjectAwareCodeStylePreferences.findFileObject(doc);
                    }
                    csp = new Csp(mimeType, doc == null ? null : new CleaningWeakReference(doc), file);
                    if (csps == null) {
                        csps = new HashMap<String, Csp>();
                        this.cache.put(obj, csps);
                    }
                    csps.put(mimeType, csp);
                }
                return csp;
            }
        }

        final class CleaningWeakReference
        extends WeakReference<Document>
        implements Runnable {
            public CleaningWeakReference(Document referent) {
                super(referent, Utilities.activeReferenceQueue());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = cache;
                synchronized (map) {
                    cache.size();
                }
            }
        }
    };

    public Preferences forFile(FileObject file, String mimeType) {
        return singleton.forFile(file, mimeType);
    }

    public Preferences forDocument(Document doc, String mimeType) {
        return singleton.forDocument(doc, mimeType);
    }

    private static Preferences findProjectPreferences(FileObject file) {
        Project p;
        if (file != null && (p = FileOwnerQuery.getOwner((FileObject)file)) != null) {
            return ProjectUtils.getPreferences((Project)p, IndentUtils.class, (boolean)true);
        }
        return null;
    }

    private static FileObject findFileObject(Document doc) {
        if (doc != null) {
            Object sdp = doc.getProperty("stream");
            if (sdp instanceof DataObject) {
                return ((DataObject)sdp).getPrimaryFile();
            }
            if (sdp instanceof FileObject) {
                return (FileObject)sdp;
            }
        }
        return null;
    }

    private static String s2s(Object o) {
        return o == null ? "null" : o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    private static final class Csp {
        private static final String NODE_CODE_STYLE = "CodeStyle";
        private static final String PROP_USED_PROFILE = "usedProfile";
        private static final String DEFAULT_PROFILE = "default";
        private static final String PROJECT_PROFILE = "project";
        private final String mimeType;
        private final Reference<Document> refDoc;
        private final String filePath;
        private final Preferences globalPrefs;
        private Preferences projectPrefs;
        private boolean useProject;
        private final PreferenceChangeListener switchTrakcer = new PreferenceChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey() == null || Csp.PROP_USED_PROFILE.equals(evt.getKey())) {
                    Csp csp = Csp.this;
                    synchronized (csp) {
                        Csp.this.useProject = Csp.PROJECT_PROFILE.equals(evt.getNewValue());
                        LOG.fine("file '" + Csp.this.filePath + "' (" + Csp.this.mimeType + ") is using " + (Csp.this.useProject ? Csp.PROJECT_PROFILE : "global") + " Preferences");
                    }
                }
            }
        };

        public Csp(String mimeType, Reference<Document> refDoc, final FileObject file) {
            this.mimeType = mimeType;
            this.refDoc = refDoc;
            this.filePath = file == null ? "no file" : file.getPath();
            this.globalPrefs = (Preferences)MimeLookup.getLookup((MimePath)(mimeType == null ? MimePath.EMPTY : MimePath.parse((String)mimeType))).lookup(Preferences.class);
            this.projectPrefs = null;
            this.useProject = false;
            ProjectManager.mutex().postReadRequest(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Csp csp = Csp.this;
                    synchronized (csp) {
                        Preferences projectRoot = ProjectAwareCodeStylePreferences.findProjectPreferences(file);
                        if (projectRoot != null) {
                            Preferences allLangCodeStyle = projectRoot.node(Csp.NODE_CODE_STYLE);
                            Preferences p = allLangCodeStyle.node(Csp.PROJECT_PROFILE);
                            String usedProfile = allLangCodeStyle.get(Csp.PROP_USED_PROFILE, Csp.DEFAULT_PROFILE);
                            Csp.this.useProject = Csp.PROJECT_PROFILE.equals(usedProfile);
                            Csp.this.projectPrefs = Csp.this.mimeType == null ? p : new ProxyPreferences(projectRoot.node(Csp.this.mimeType).node(Csp.NODE_CODE_STYLE).node(Csp.PROJECT_PROFILE), p);
                            allLangCodeStyle.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)Csp.this.switchTrakcer, (Object)allLangCodeStyle));
                        } else {
                            Csp.this.useProject = false;
                            Csp.this.projectPrefs = null;
                        }
                    }
                }
            });
            LOG.fine("file '" + this.filePath + "' (" + mimeType + ") is using " + (this.useProject ? PROJECT_PROFILE : "global") + " Preferences; doc=" + ProjectAwareCodeStylePreferences.s2s(refDoc == null ? null : refDoc.get()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Preferences getPreferences() {
            Csp csp = this;
            synchronized (csp) {
                Preferences prefs = this.useProject ? this.projectPrefs : this.globalPrefs;
                return prefs == null ? AbstractPreferences.systemRoot() : prefs;
            }
        }
    }
}

