/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.codegen;

import org.openide.ErrorManager;

public final class CodeSupport {
    private CodeSupport() {
    }

    public static String encryptStringToJavaCode(String value) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        block6: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block6;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\");
                        sb.append(CodeSupport.alignWithZeros(Integer.toOctalString(c), 3));
                        continue block6;
                    }
                    if (c >= '\u0080') {
                        sb.append("\\u");
                        sb.append(CodeSupport.alignWithZeros(Integer.toHexString(c).toUpperCase(), 4));
                        continue block6;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public static String alignWithZeros(String value, int positions) {
        if (value == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        positions -= value.length();
        while (positions > 0) {
            sb.append('0');
            --positions;
        }
        if (positions < 0) {
            return value.substring(-positions);
        }
        return sb.append(value).toString();
    }

    public static String decryptStringFromJavaCode(String value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        block11: while (i < len) {
            char c = value.charAt(i);
            ++i;
            if (c != '\\') {
                sb.append(c);
                continue;
            }
            c = value.charAt(i);
            ++i;
            switch (c) {
                case 'r': {
                    sb.append('\r');
                    continue block11;
                }
                case 'n': {
                    sb.append('\n');
                    continue block11;
                }
                case 't': {
                    sb.append('\t');
                    continue block11;
                }
                case 'u': {
                    if (i + 4 > len) {
                        ErrorManager.getDefault().log(1, "WARNING: Invalid hex number at the end: " + value.substring(i));
                        continue block11;
                    }
                    try {
                        sb.append((char)Integer.parseInt(value.substring(i, i + 4), 16));
                    }
                    catch (NumberFormatException e) {
                        ErrorManager.getDefault().log(1, "WARNING: Invalid hex number format: " + value.substring(i, i + 4));
                    }
                    i += 4;
                    continue block11;
                }
                case '\"': 
                case '\'': 
                case '\\': {
                    sb.append(c);
                    continue block11;
                }
            }
            if (c < '0' || c > '9') {
                ErrorManager.getDefault().log(1, "WARNING: Invalid character after slash: " + c);
                continue;
            }
            if (--i + 3 > len) {
                ErrorManager.getDefault().log(1, "WARNING: Invalid octal number at the end: " + value.substring(i));
                continue;
            }
            try {
                sb.append((char)Integer.parseInt(value.substring(i, i + 3), 8));
            }
            catch (NumberFormatException e) {
                ErrorManager.getDefault().log(1, "WARNING: Invalid octal number format: " + value.substring(i, i + 3));
            }
            i += 3;
        }
        return sb.toString();
    }

    public static int compareStrings(String s1, String s2) {
        if (s1 != null) {
            return s2 != null ? s1.compareTo(s2) : 1;
        }
        return s2 != null ? -1 : 0;
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }
}

