/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.codegen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.guards.GuardedSection;
import org.netbeans.api.editor.guards.GuardedSectionManager;
import org.netbeans.api.editor.guards.SimpleSection;
import org.netbeans.modules.vmd.api.model.Debug;

public class CodeUtils {
    public static SimpleSection findSectionByPrefix(Iterable<? extends GuardedSection> sections, String prefix) {
        for (GuardedSection guardedSection : sections) {
            if (!(guardedSection instanceof SimpleSection) || !guardedSection.getName().startsWith(prefix)) continue;
            return (SimpleSection)guardedSection;
        }
        return null;
    }

    public static ArrayList<SimpleSection> findSectionsByPrefix(Iterable<? extends GuardedSection> sections, String prefix) {
        ArrayList<SimpleSection> list = new ArrayList<SimpleSection>();
        for (GuardedSection guardedSection : sections) {
            if (!(guardedSection instanceof SimpleSection) || !guardedSection.getName().startsWith(prefix)) continue;
            list.add((SimpleSection)guardedSection);
        }
        return list;
    }

    public static void sortSections(ArrayList<SimpleSection> sections) {
        Collections.sort(sections, new Comparator<SimpleSection>(){

            @Override
            public int compare(SimpleSection o1, SimpleSection o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public static GuardedSection findLast(Iterable<? extends GuardedSection> sections) {
        GuardedSection last = null;
        for (GuardedSection guardedSection : sections) {
            if (last == null) {
                last = guardedSection;
                continue;
            }
            if (last.getEndPosition().getOffset() >= guardedSection.getEndPosition().getOffset()) continue;
            last = guardedSection;
        }
        return last;
    }

    public static SimpleSection createSimpleSectionAfter(StyledDocument document, GuardedSection sectionForAddingAfter, String sectionID) {
        GuardedSectionManager instance = GuardedSectionManager.getInstance((StyledDocument)document);
        try {
            return instance.createSimpleSection(document.createPosition(sectionForAddingAfter.getEndPosition().getOffset() + 1), sectionID);
        }
        catch (BadLocationException e) {
            throw Debug.error((Object[])new Object[]{e});
        }
    }
}

