/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.openide.util.Cancellable;
import org.openide.util.Exceptions;

class BackendLauncher {
    private final Callable<Cancellable> launcher;
    Future<Cancellable> futureCancellable;

    BackendLauncher(Callable<Cancellable> launcher) {
        this.launcher = launcher;
    }

    synchronized void launch() {
        if (this.futureCancellable == null && this.launcher != null) {
            this.futureCancellable = Executors.newSingleThreadExecutor().submit(this.launcher);
        }
    }

    synchronized void stop() {
        if (this.futureCancellable != null) {
            try {
                Cancellable cancellable = this.futureCancellable.get();
                if (cancellable != null) {
                    cancellable.cancel();
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

