/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.LookupMerger;
import org.openide.util.Lookup;

public final class LookupMergerSupport {
    public static LookupMerger<ActionProvider> createActionProviderLookupMerger() {
        return new ActionProviderMerger();
    }

    private static class MergedActionProvider
    implements ActionProvider {
        private final Lookup lookup;

        public MergedActionProvider(Lookup lookup) {
            this.lookup = lookup;
        }

        public String[] getSupportedActions() {
            HashSet<String> resultSet = new HashSet<String>();
            Collection providers = this.lookup.lookupAll(ActionProvider.class);
            for (ActionProvider impl : providers) {
                resultSet.addAll(Arrays.asList(impl.getSupportedActions()));
            }
            return resultSet.toArray(new String[resultSet.size()]);
        }

        public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
            Collection providers = this.lookup.lookupAll(ActionProvider.class);
            for (ActionProvider impl : providers) {
                if (!impl.isActionEnabled(command, context)) continue;
                impl.invokeAction(command, context);
                return;
            }
        }

        public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
            Collection providers = this.lookup.lookupAll(ActionProvider.class);
            for (ActionProvider impl : providers) {
                if (!impl.isActionEnabled(command, context)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ActionProviderMerger
    implements LookupMerger<ActionProvider> {
        private ActionProviderMerger() {
        }

        public Class<ActionProvider> getMergeableClass() {
            return ActionProvider.class;
        }

        public ActionProvider merge(Lookup lookup) {
            return new MergedActionProvider(lookup);
        }
    }
}

