/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.api.debugger.jpda.ThreadsCollector;
import org.netbeans.modules.debugger.jpda.ui.debugging.ClickableIcon;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebugTreeView;
import org.netbeans.modules.debugger.jpda.ui.debugging.InfoPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.TapPanel;
import org.netbeans.modules.debugger.jpda.ui.debugging.ThreadsListener;
import org.netbeans.modules.debugger.jpda.ui.models.DebuggingTreeModel;
import org.netbeans.modules.debugger.jpda.ui.views.ViewModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DebuggingView
extends TopComponent
implements HelpCtx.Provider,
ExplorerManager.Provider,
PropertyChangeListener,
TreeExpansionListener,
TreeModelListener,
AdjustmentListener,
ChangeListener,
MouseWheelListener,
TreeSelectionListener {
    private static final String ID = "debugging";
    public static final int BAR_WIDTH = 8;
    static final Color hitsColor = new Color(255, 255, 178);
    static final Color hitsBarColor = new Color(230, 230, 130);
    static final Color deadlockColor = UIManager.getDefaults().getColor("nb.errorForeground");
    static final Color greenBarColor = new Color(189, 230, 170);
    private transient Color treeBackgroundColor = UIManager.getDefaults().getColor("Tree.textBackground");
    private transient RequestProcessor requestProcessor = new RequestProcessor("DebuggingView Refresh Scheduler", 1);
    private transient boolean refreshScheduled = false;
    private transient ExplorerManager manager = new ExplorerManager();
    private transient ViewModelListener viewModelListener;
    private Preferences preferences = NbPreferences.forModule(this.getClass()).node("debugging");
    private PreferenceChangeListener prefListener;
    private SessionsComboBoxListener sessionsComboListener;
    private transient ImageIcon resumeIcon;
    private transient ImageIcon focusedResumeIcon;
    private transient ImageIcon pressedResumeIcon;
    private transient ImageIcon suspendIcon;
    private transient ImageIcon focusedSuspendIcon;
    private transient ImageIcon pressedSuspendIcon;
    private DebugTreeView treeView;
    private TapPanel tapPanel;
    private InfoPanel infoPanel;
    private JPDADebugger debugger;
    private Session session;
    private JPDADebugger previousDebugger;
    private Reference<JPDAThread> threadMadeCurrentRef;
    private Reference<JPDAThread> threadToScrollRef;
    private ViewRefresher viewRefresher = new ViewRefresher();
    private BarsPanel leftPanel;
    private IconsPanel rightPanel;
    private ThreadsListener threadsListener = null;
    private static Reference<DebuggingView> instance = null;
    private JPanel leftPanel1;
    private JPanel mainPanel;
    private JScrollPane mainScrollPane;
    private JPanel rightPanel1;
    private JPanel scrollBarPanel;
    private JComboBox sessionComboBox;
    private JScrollBar treeScrollBar;

    public DebuggingView() {
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/debugger/jpda/resources/debugging.png"));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.treeBackgroundColor = UIManager.getColor("NbExplorerView.background");
        }
        this.initComponents();
        this.resumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_16.png", (boolean)false);
        this.focusedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_focused_16.png", (boolean)false);
        this.pressedResumeIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/resume_button_pressed_16.png", (boolean)false);
        this.suspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_16.png", (boolean)false);
        this.focusedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_focused_16.png", (boolean)false);
        this.pressedSuspendIcon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/debugger/jpda/resources/suspend_button_pressed_16.png", (boolean)false);
        this.setBackground(this.treeBackgroundColor);
        this.leftPanel = new BarsPanel();
        this.rightPanel = new IconsPanel();
        this.mainPanel.setBackground(this.treeBackgroundColor);
        this.mainPanel.add((Component)this.leftPanel, "West");
        this.mainPanel.add((Component)this.rightPanel, "East");
        this.tapPanel = new TapPanel();
        this.tapPanel.setOrientation(2);
        this.tapPanel.setExpanded(true);
        this.infoPanel = new InfoPanel(this.tapPanel, this);
        this.tapPanel.add(this.infoPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.add(this.tapPanel, gridBagConstraints);
        this.manager.addPropertyChangeListener((PropertyChangeListener)this);
        this.prefListener = new DebuggingPreferenceChangeListener();
        this.preferences.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefListener, (Object)this.preferences));
        this.sessionsComboListener = new SessionsComboBoxListener();
        this.scrollBarPanel.setVisible(false);
        if ("Aqua".equals(UIManager.getLookAndFeel().getID())) {
            this.scrollBarPanel.setBackground(this.tapPanel.getBackground());
            this.scrollBarPanel.setOpaque(true);
        }
        this.treeScrollBar.addAdjustmentListener(this);
        this.setSuspendTableVisible(this.preferences.getBoolean("show_suspend_table", true));
    }

    private void initComponents() {
        this.sessionComboBox = new JComboBox();
        this.mainScrollPane = new JScrollPane();
        this.mainPanel = new JPanel();
        this.scrollBarPanel = new JPanel();
        this.treeScrollBar = new JScrollBar();
        this.leftPanel1 = new JPanel();
        this.rightPanel1 = new JPanel();
        this.setLayout(new GridBagLayout());
        this.sessionComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Java Project"}));
        this.sessionComboBox.setMaximumSize(new Dimension(Short.MAX_VALUE, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add(this.sessionComboBox, gridBagConstraints);
        this.sessionComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleName"));
        this.sessionComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.sessionComboBox.AccessibleContext.accessibleDescription"));
        this.mainScrollPane.setBorder(null);
        this.mainScrollPane.setHorizontalScrollBarPolicy(31);
        this.mainScrollPane.setPreferredSize(new Dimension(32, 10));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainScrollPane.setViewportView(this.mainPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.mainScrollPane, gridBagConstraints);
        this.scrollBarPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 17));
        this.scrollBarPanel.setLayout(new BorderLayout());
        this.treeScrollBar.setOrientation(0);
        this.scrollBarPanel.add((Component)this.treeScrollBar, "Center");
        this.leftPanel1.setOpaque(false);
        this.leftPanel1.setPreferredSize(new Dimension(8, 0));
        this.leftPanel1.setLayout(new FlowLayout(0, 0, 0));
        this.scrollBarPanel.add((Component)this.leftPanel1, "West");
        this.rightPanel1.setOpaque(false);
        this.rightPanel1.setPreferredSize(new Dimension(24, 0));
        this.rightPanel1.setLayout(new FlowLayout(1, 0, 0));
        this.scrollBarPanel.add((Component)this.rightPanel1, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.scrollBarPanel, gridBagConstraints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootContext(Models.CompoundModel compoundModel, final DebuggerEngine debuggerEngine) {
        DebuggingView debuggingView;
        Object object = this.manager.getRootContext();
        if (object != null) {
            try {
                object.destroy();
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        if (this.threadsListener == null) {
            this.threadsListener = ThreadsListener.getDefault();
        }
        if (debuggerEngine != null) {
            object = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
            if (object != null && this.threadsListener != null) {
                this.threadsListener.setDebuggingView(this);
            }
            debuggingView = this;
            synchronized (debuggingView) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = this.debugger;
                this.debugger = object;
                if (object != null) {
                    this.session = (Session)debuggerEngine.lookupFirst(null, Session.class);
                    object.addPropertyChangeListener((PropertyChangeListener)this);
                } else {
                    this.session = null;
                }
            }
            RequestProcessor.getDefault().post(new Runnable((JPDADebugger)object){
                final /* synthetic */ JPDADebugger val$deb;
                {
                    this.val$deb = jPDADebugger;
                }

                @Override
                public void run() {
                    DebuggingView.this.threadsListener.changeDebugger(this.val$deb);
                }
            });
        } else {
            object = this;
            synchronized (object) {
                if (this.previousDebugger != null) {
                    this.previousDebugger.removePropertyChangeListener((PropertyChangeListener)this);
                }
                this.previousDebugger = null;
                this.debugger = null;
                this.session = null;
            }
            if (this.threadsListener != null) {
                this.threadsListener.changeDebugger(null);
            }
        }
        if (compoundModel == null) {
            object = Node.EMPTY;
            this.releaseTreeView();
        } else {
            debuggingView = this;
            synchronized (debuggingView) {
                if (this.treeView == null) {
                    this.createTreeView();
                }
                object = Models.createNodes((Models.CompoundModel)compoundModel, (TreeView)this.treeView);
                this.treeView.setExpansionModel((TreeExpansionModel)compoundModel);
            }
        }
        this.manager.setRootContext(object);
        this.refreshView();
        this.updateSessionsComboBox();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.adjustTreeScrollBar(-1);
                if (debuggerEngine == null) {
                    DebuggingView.this.setActivatedNodes(new Node[0]);
                    DebugTreeView debugTreeView = DebuggingView.this.getTreeView();
                    if (debugTreeView != null) {
                        debugTreeView.resetSelection();
                    }
                }
            }
        });
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public static DebuggingView getInstance() {
        DebuggingView debuggingView = (DebuggingView)WindowManager.getDefault().findTopComponent(ID);
        if (debuggingView == null) {
            debuggingView = DebuggingView.getDefault();
        }
        return debuggingView;
    }

    public void setSuspendTableVisible(boolean bl) {
        this.rightPanel.setVisible(bl);
    }

    public static synchronized DebuggingView getDefault() {
        DebuggingView debuggingView;
        if (instance == null) {
            debuggingView = new DebuggingView();
            instance = new WeakReference<DebuggingView>(debuggingView);
        } else {
            debuggingView = instance.get();
            if (debuggingView == null) {
                debuggingView = new DebuggingView();
                instance = new WeakReference<DebuggingView>(debuggingView);
            }
        }
        return debuggingView;
    }

    protected String preferredID() {
        return this.getClass().getName();
    }

    protected void componentShowing() {
        super.componentShowing();
        if (this.viewModelListener != null) {
            this.viewModelListener.setUp();
            return;
        }
        if (this.viewModelListener != null) {
            throw new InternalError();
        }
        this.viewModelListener = new ViewModelListener("DebuggingView", (JComponent)((Object)this));
    }

    protected void componentHidden() {
        super.componentHidden();
        if (this.viewModelListener != null) {
            this.viewModelListener.destroy();
        }
    }

    protected void componentActivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)true);
    }

    protected void componentDeactivated() {
        ExplorerUtils.activateActions((ExplorerManager)this.manager, (boolean)false);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("DebuggingView");
    }

    public int getPersistenceType() {
        return 0;
    }

    public boolean requestFocusInWindow() {
        DebugTreeView debugTreeView = this.getTreeView();
        if (debugTreeView != null) {
            return debugTreeView.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    public String getName() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_view");
    }

    public String getToolTipText() {
        return NbBundle.getMessage(DebuggingView.class, (String)"CTL_Debugging_tooltip");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("rootContext".equals(string) || "nodeChange".equals(string)) {
            this.refreshView();
        } else if ("currentThread".equals(string)) {
            JPDAThread jPDAThread;
            DebuggingView debuggingView = this;
            synchronized (debuggingView) {
                jPDAThread = this.debugger != null ? this.debugger.getCurrentThread() : null;
            }
            if (jPDAThread != null) {
                Object object = debuggingView = this.threadMadeCurrentRef != null ? this.threadMadeCurrentRef.get() : null;
                if (debuggingView == jPDAThread) {
                    this.threadToScrollRef = new WeakReference<DebuggingView>(debuggingView);
                }
            }
            this.refreshView();
        } else if (string.equals("selectedNodes")) {
            this.setActivatedNodes((Node[])propertyChangeEvent.getNewValue());
        }
    }

    private static boolean isJPDASession(Session session) {
        DebuggerEngine debuggerEngine = session.getCurrentEngine();
        if (debuggerEngine == null) {
            return false;
        }
        return debuggerEngine.lookupFirst(null, JPDADebugger.class) != null;
    }

    void updateSessionsComboBox() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.sessionComboBox.removeActionListener(DebuggingView.this.sessionsComboListener);
                DebuggingView.this.sessionComboBox.removePopupMenuListener(DebuggingView.this.sessionsComboListener);
                ComboBoxModel comboBoxModel = DebuggingView.this.sessionComboBox.getModel();
                DebuggingView.this.sessionComboBox.removeAllItems();
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                Session[] sessionArray = debuggerManager.getSessions();
                for (int i = 0; i < sessionArray.length; ++i) {
                    if (!DebuggingView.isJPDASession(sessionArray[i])) continue;
                    DebuggingView.this.sessionComboBox.addItem(new SessionItem(sessionArray[i]));
                }
                if (comboBoxModel.getSize() == 0) {
                    DebuggingView.this.sessionComboBox.addItem(new SessionItem(null));
                }
                DebuggingView.this.sessionComboBox.setSelectedItem(new SessionItem(debuggerManager.getCurrentSession()));
                DebuggingView.this.sessionComboBox.setVisible(comboBoxModel.getSize() > 1);
                DebuggingView.this.sessionComboBox.addActionListener(DebuggingView.this.sessionsComboListener);
                DebuggingView.this.sessionComboBox.addPopupMenuListener(DebuggingView.this.sessionsComboListener);
            }
        });
    }

    void makeThreadCurrent(JPDAThread jPDAThread) {
        this.threadMadeCurrentRef = new WeakReference<JPDAThread>(jPDAThread);
        jPDAThread.makeCurrent();
    }

    private synchronized void createTreeView() {
        if (this.treeView != null) {
            this.releaseTreeView();
        }
        this.treeView = new DebugTreeView();
        this.treeView.setRootVisible(false);
        this.treeView.setHorizontalScrollBarPolicy(31);
        this.treeView.setVerticalScrollBarPolicy(21);
        this.treeView.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleName"));
        this.treeView.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DebuggingView.class, (String)"DebuggingView.treeView.AccessibleContext.accessibleDescription"));
        this.treeView.getTree().addMouseWheelListener(this);
        this.treeView.addTreeExpansionListener(this);
        TreeModel treeModel = this.treeView.getTree().getModel();
        treeModel.addTreeModelListener(this);
        this.treeView.getViewport().addChangeListener(this);
        this.treeView.getTree().addTreeSelectionListener(this);
        this.mainPanel.add((Component)((Object)this.treeView), "Center");
    }

    private synchronized void releaseTreeView() {
        this.treeView.getTree().removeMouseWheelListener(this);
        this.treeView.removeTreeExpansionListener(this);
        TreeModel treeModel = this.treeView.getTree().getModel();
        treeModel.removeTreeModelListener(this);
        this.treeView.getViewport().removeChangeListener(this);
        this.treeView.getTree().removeTreeSelectionListener(this);
        this.mainPanel.remove((Component)((Object)this.treeView));
        this.treeView = null;
    }

    private DebugTreeView getTreeView() {
        return this.treeView;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.refreshView();
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.refreshView();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
        this.refreshView();
    }

    InfoPanel getInfoPanel() {
        return this.infoPanel;
    }

    void refreshView() {
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        this.requestProcessor.post(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(DebuggingView.this.viewRefresher);
            }
        }, 20);
    }

    private void adjustTreeScrollBar(int n) {
        JScrollBar jScrollBar;
        int n2;
        DebugTreeView debugTreeView = this.getTreeView();
        if (debugTreeView == null) {
            this.scrollBarPanel.setVisible(false);
            return;
        }
        JViewport jViewport = debugTreeView.getViewport();
        Point point = jViewport.getViewPosition();
        if (point.y < 0) {
            jViewport.setViewPosition(new Point(point.x, 0));
        }
        Dimension dimension = jViewport.getExtentSize();
        Dimension dimension2 = jViewport.getViewSize();
        if (n < 0) {
            n = dimension2.width;
        }
        if ((n2 = debugTreeView.getUnitHeight()) > 0 && (jScrollBar = this.mainScrollPane.getVerticalScrollBar()).getUnitIncrement() != n2) {
            jScrollBar.setUnitIncrement(n2);
        }
        if (n <= dimension.width) {
            this.scrollBarPanel.setVisible(false);
        } else {
            this.treeScrollBar.setMaximum(n);
            this.treeScrollBar.setVisibleAmount(dimension.width);
            if (n2 > 0) {
                this.treeScrollBar.setUnitIncrement(n2 / 2);
            }
            this.scrollBarPanel.setVisible(true);
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        DebugTreeView debugTreeView = this.getTreeView();
        if (debugTreeView == null) {
            return;
        }
        JViewport jViewport = debugTreeView.getViewport();
        Point point = jViewport.getViewPosition();
        Dimension dimension = jViewport.getExtentSize();
        Rectangle rectangle = new Rectangle(adjustmentEvent.getValue(), point.y, dimension.width, dimension.height);
        ((JComponent)jViewport.getView()).scrollRectToVisible(rectangle);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DebuggingView.this.adjustTreeScrollBar(-1);
            }
        });
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        JScrollBar jScrollBar = this.mainScrollPane.getVerticalScrollBar();
        if (mouseWheelEvent.getScrollType() == 0) {
            int n = mouseWheelEvent.getUnitsToScroll() * jScrollBar.getUnitIncrement();
            jScrollBar.setValue(jScrollBar.getValue() + n);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = treeSelectionEvent.getNewLeadSelectionPath();
        DebugTreeView debugTreeView = this.getTreeView();
        if (treePath != null && debugTreeView != null) {
            int n;
            JTree jTree = debugTreeView.getTree();
            Rectangle rectangle = jTree.getRowBounds(n = jTree.getRowForPath(treePath));
            if (rectangle == null) {
                return;
            }
            JViewport jViewport = this.mainScrollPane.getViewport();
            ((JComponent)jViewport.getView()).scrollRectToVisible(rectangle);
        }
    }

    private class SessionItem {
        private Session session;

        SessionItem(Session session) {
            this.session = session;
        }

        public Session getSession() {
            return this.session;
        }

        public String toString() {
            if (this.session != null) {
                return this.session.getName();
            }
            return '<' + NbBundle.getMessage(DebuggingView.class, (String)"LBL_No_Session_Running") + '>';
        }

        public boolean equals(Object object) {
            if (!(object instanceof SessionItem)) {
                return false;
            }
            Session session = ((SessionItem)object).getSession();
            if (this.session == null) {
                return session == null;
            }
            return this.session.equals(session);
        }

        public int hashCode() {
            return 87 + (this.session != null ? this.session.hashCode() : 0);
        }
    }

    private class SessionsComboBoxListener
    implements ActionListener,
    PopupMenuListener {
        SessionItem selectedItem = null;
        boolean popupVisible = false;

        private SessionsComboBoxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SessionItem sessionItem = (SessionItem)DebuggingView.this.sessionComboBox.getSelectedItem();
            if (this.popupVisible) {
                this.selectedItem = sessionItem;
            } else {
                this.changeSession(sessionItem);
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = true;
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.changeSession(this.selectedItem);
            this.selectedItem = null;
            this.popupVisible = false;
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.selectedItem = null;
            this.popupVisible = false;
        }

        private void changeSession(SessionItem sessionItem) {
            if (sessionItem != null) {
                Session session = sessionItem.getSession();
                DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
                if (session != null && session != debuggerManager.getCurrentSession()) {
                    debuggerManager.setCurrentSession(session);
                }
            }
        }
    }

    private class IconsPanel
    extends JPanel {
        private int endSY;
        private int counter;
        private ArrayList<IconItem> icons = new ArrayList();

        IconsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(24, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
        }

        public void startReset() {
            this.counter = 0;
            this.endSY = 0;
        }

        public void endReset() {
            int n = this.icons.size();
            for (int i = n - 1; i >= this.counter; --i) {
                this.remove(i);
                this.icons.remove(i);
            }
        }

        public void addIcon(int n, int n2, int n3, JPDAThread jPDAThread) {
            int n4 = n2 - this.endSY + n3;
            if (this.counter < this.icons.size()) {
                IconItem iconItem = this.icons.get(this.counter);
                iconItem.icon.changeThread(jPDAThread, (Container)((Object)DebuggingView.this), n, n2, 24, n4);
                iconItem.panel.setPreferredSize(new Dimension(24, n4));
                iconItem.height = n4;
            } else {
                JPanel jPanel = new JPanel(new GridBagLayout());
                jPanel.setBackground(DebuggingView.this.treeBackgroundColor);
                jPanel.setOpaque(false);
                jPanel.setPreferredSize(new Dimension(24, n4));
                ClickableIcon clickableIcon = new ClickableIcon(DebuggingView.this.resumeIcon, DebuggingView.this.focusedResumeIcon, DebuggingView.this.pressedResumeIcon, DebuggingView.this.suspendIcon, DebuggingView.this.focusedSuspendIcon, DebuggingView.this.pressedSuspendIcon, jPDAThread, DebuggingView.this.treeView);
                clickableIcon.setBackground(DebuggingView.this.treeBackgroundColor);
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.anchor = 15;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 1.0;
                int n5 = n3 - 16;
                int n6 = n5 / 2;
                int n7 = n5 - n6;
                gridBagConstraints.insets = new Insets(n6, 0, n7, 0);
                jPanel.add((Component)clickableIcon, gridBagConstraints);
                clickableIcon.initializeState((Container)((Object)DebuggingView.this), n, n2, 24, n4);
                IconItem iconItem = new IconItem(n4, clickableIcon, jPanel);
                this.icons.add(iconItem);
                this.add(jPanel);
            }
            ++this.counter;
            this.endSY += n4;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            DebugTreeView debugTreeView = DebuggingView.this.getTreeView();
            if (debugTreeView != null) {
                debugTreeView.paintStripes(graphics, this);
            }
        }

        private class IconItem {
            private int height;
            private ClickableIcon icon;
            private JPanel panel;

            IconItem(int n, ClickableIcon clickableIcon, JPanel jPanel) {
                this.height = n;
                this.icon = clickableIcon;
                this.panel = jPanel;
            }
        }
    }

    private class BarsPanel
    extends JPanel
    implements MouseMotionListener {
        private ArrayList<Bar> bars = new ArrayList();

        BarsPanel() {
            this.setBackground(DebuggingView.this.treeBackgroundColor);
            this.setPreferredSize(new Dimension(8, 0));
            this.setLayout(new FlowLayout(0, 0, 0));
            this.addMouseMotionListener(this);
        }

        public void clearBars() {
            this.bars.clear();
        }

        public void addBar(boolean bl, boolean bl2, boolean bl3, int n, int n2) {
            String string = null;
            Color color = null;
            Color color2 = null;
            if (bl3) {
                color = deadlockColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_DEADLOCKED_THREAD_TIP");
            } else if (bl) {
                color = greenBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_BAR_TIP");
            } else if (bl2) {
                color = hitsBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_BREAKPOINT_HIT_TIP");
            }
            if (bl && bl3) {
                color2 = greenBarColor;
                string = NbBundle.getMessage(DebuggingView.class, (String)"LBL_CURRENT_DEADLOCKED_TIP");
            }
            Bar bar = new Bar(n2, n, color, color2, string);
            this.bars.add(bar);
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            Rectangle rectangle = graphics.getClipBounds();
            double d = rectangle.getY();
            double d2 = d + rectangle.getHeight() - 1.0;
            int n = (int)this.getBounds().getWidth();
            for (Bar bar : this.bars) {
                Rectangle rectangle2;
                if ((double)(bar.sy + bar.height - 1) < d) continue;
                if ((double)bar.sy > d2) break;
                if (bar.color != null) {
                    rectangle2 = new Rectangle(0, bar.sy + 1, n, bar.height - 1);
                    rectangle2 = rectangle2.intersection(rectangle);
                    graphics.setColor(bar.color);
                    graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (bar.secondaryColor == null) continue;
                rectangle2 = new Rectangle(n / 2 - 1, bar.sy + 1, (n + 1) / 2 + 1, bar.height - 1);
                if ((rectangle2 = rectangle2.intersection(rectangle)).isEmpty()) continue;
                graphics.setColor(bar.secondaryColor);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            graphics.setColor(color);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.computeToolTipText(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.computeToolTipText(mouseEvent);
        }

        private void computeToolTipText(MouseEvent mouseEvent) {
            int n = mouseEvent.getY();
            try {
                for (Bar bar : this.bars) {
                    if (n < bar.sy || n >= bar.sy + bar.height) continue;
                    this.setToolTipText(bar.toolTipText);
                    return;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                // empty catch block
            }
            this.setToolTipText(null);
        }

        private class Bar {
            private int sy;
            private int height;
            private Color color;
            private Color secondaryColor = null;
            private String toolTipText;

            Bar(int n, int n2, Color color, Color color2, String string) {
                this.sy = n;
                this.height = n2;
                this.color = color;
                this.secondaryColor = color2;
                this.toolTipText = string;
            }
        }
    }

    private final class ViewRefresher
    implements Runnable {
        private ViewRefresher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n;
            Object object;
            Object object2;
            ThreadsCollector threadsCollector;
            JPDAThread jPDAThread;
            DebugTreeView debugTreeView = DebuggingView.this.getTreeView();
            DebuggingView.this.refreshScheduled = false;
            DebuggingView.this.leftPanel.clearBars();
            DebuggingView.this.rightPanel.startReset();
            int n2 = (DebuggingView.this.rightPanel.getWidth() - 24) / 2;
            int n3 = 0;
            Object object3 = DebuggingView.this;
            synchronized (object3) {
                jPDAThread = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getCurrentThread() : null;
                threadsCollector = DebuggingView.this.debugger != null ? DebuggingView.this.debugger.getThreadsCollector() : null;
            }
            Object object4 = object3 = threadsCollector != null ? threadsCollector.getDeadlockDetector().getDeadlocks() : Collections.EMPTY_SET;
            if (object3 == null) {
                object3 = Collections.EMPTY_SET;
            }
            HashSet hashSet = new HashSet();
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                DeadlockDetector.Deadlock deadlock = (DeadlockDetector.Deadlock)iterator.next();
                hashSet.addAll(deadlock.getThreads());
            }
            iterator = DebuggingView.this.threadToScrollRef != null ? (JPDAThread)DebuggingView.this.threadToScrollRef.get() : null;
            DebuggingView.this.threadToScrollRef = null;
            int n4 = -1;
            int n5 = -1;
            boolean bl = false;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            JPDAThread jPDAThread2 = null;
            int n9 = 0;
            int n10 = 0;
            if (debugTreeView != null) {
                object2 = debugTreeView.getVisiblePaths().iterator();
                while (object2.hasNext()) {
                    TreePath treePath = object2.next();
                    object = Visualizer.findNode((Object)treePath.getLastPathComponent());
                    JPDAThread jPDAThread3 = (JPDAThread)object.getLookup().lookup(JPDAThread.class);
                    JPDAThreadGroup jPDAThreadGroup = (JPDAThreadGroup)object.getLookup().lookup(JPDAThreadGroup.class);
                    JTree jTree = debugTreeView.getTree();
                    Rectangle rectangle = jTree.getRowBounds(jTree.getRowForPath(treePath));
                    int n11 = n10 = rectangle != null ? (int)Math.round(rectangle.getHeight()) : 0;
                    if (jPDAThread3 != null || jPDAThreadGroup != null) {
                        boolean bl5 = bl = jPDAThread3 == iterator;
                        if (bl) {
                            n4 = n6;
                        }
                        if (jPDAThread2 != null) {
                            this.addPanels(jPDAThread2, bl2, bl3, bl4, n8, n2, n9, n10);
                        }
                        n8 = 0;
                        if (jPDAThread3 != null) {
                            bl2 = jPDAThread3 == jPDAThread && (jPDAThread3.isSuspended() || DebuggingTreeModel.isMethodInvoking(jPDAThread3));
                            bl3 = DebuggingView.this.threadsListener.isBreakpointHit(jPDAThread3);
                            bl4 = hashSet.contains(jPDAThread3);
                        } else {
                            bl2 = false;
                            bl3 = false;
                            bl4 = false;
                        }
                        jPDAThread2 = jPDAThread3 != null ? jPDAThread3 : jPDAThreadGroup;
                        n9 = n3;
                    }
                    n6 += n10;
                    n7 = rectangle != null ? Math.max(n7, (int)Math.round(rectangle.getX() + rectangle.getWidth())) : n7;
                    n8 += n10;
                    n3 += n10;
                    if (!bl) continue;
                    n5 = n6;
                }
            }
            if (jPDAThread2 != null) {
                this.addPanels(jPDAThread2, bl2, bl3, bl4, n8, n2, n9, n10);
            }
            DebuggingView.this.rightPanel.endReset();
            DebuggingView.this.leftPanel.repaint();
            DebuggingView.this.rightPanel.revalidate();
            DebuggingView.this.rightPanel.repaint();
            if (debugTreeView != null) {
                debugTreeView.getTree().setPreferredSize(new Dimension(n7, 0));
            }
            DebuggingView.this.mainPanel.setPreferredSize(new Dimension(0, n6));
            DebuggingView.this.mainScrollPane.revalidate();
            DebuggingView.this.mainPanel.revalidate();
            if (debugTreeView != null) {
                debugTreeView.repaint();
            }
            DebuggingView.this.adjustTreeScrollBar(n7);
            if (n4 > -1 && !((Rectangle)(object = new Rectangle(0, n4, 1, n = Math.min(n5 - n4 + 1, ((JComponent)(object2 = DebuggingView.this.mainScrollPane.getViewport())).getHeight())))).isEmpty()) {
                ((JComponent)((JViewport)object2).getView()).scrollRectToVisible((Rectangle)object);
            }
        }

        private void addPanels(Object object, boolean bl, boolean bl2, boolean bl3, int n, int n2, int n3, int n4) {
            if (bl || bl2 || bl3) {
                DebuggingView.this.leftPanel.addBar(bl, bl2, bl3, n, n3);
            }
            if (object instanceof JPDAThread) {
                DebuggingView.this.rightPanel.addIcon(n2, n3, n4, (JPDAThread)object);
            }
        }
    }

    private final class DebuggingPreferenceChangeListener
    implements PreferenceChangeListener {
        private DebuggingPreferenceChangeListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
            String string = preferenceChangeEvent.getKey();
            if ("show_suspend_table".equals(string)) {
                DebuggingView.this.setSuspendTableVisible(preferenceChangeEvent.getNewValue().equals("true"));
            }
        }
    }
}

