/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.jpda.DeadlockDetector;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingView;
import org.netbeans.modules.debugger.jpda.ui.debugging.InfoPanel;
import org.openide.util.Exceptions;

public class ThreadsListener
extends DebuggerManagerAdapter {
    private static ThreadsListener instance;
    final LinkedList<JPDAThread> currentThreadsHistory = new LinkedList();
    final BreakpointHits hits = new BreakpointHits();
    private Map<JPDADebugger, DebuggerListener> debuggerToListener = new WeakHashMap<JPDADebugger, DebuggerListener>();
    private JPDADebugger currentDebugger = null;
    private DebuggingView debuggingView;

    public ThreadsListener() {
        instance = this;
    }

    public static ThreadsListener getDefault() {
        return instance;
    }

    public void setDebuggingView(DebuggingView debuggingView) {
        this.debuggingView = debuggingView;
        InfoPanel infoPanel = debuggingView.getInfoPanel();
        infoPanel.setBreakpointHits(this.getHits());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void changeDebugger(JPDADebugger jPDADebugger) {
        Object object;
        Object object2;
        if (this.currentDebugger == jPDADebugger) {
            return;
        }
        if (jPDADebugger != null && (object2 = jPDADebugger.getCurrentThread()) != null) {
            object = this.currentThreadsHistory;
            synchronized (object) {
                this.currentThreadsHistory.remove(object2);
                this.currentThreadsHistory.addFirst((JPDAThread)object2);
            }
        }
        if (this.debuggingView == null) {
            this.currentDebugger = jPDADebugger;
            return;
        }
        if (this.currentDebugger != null) {
            object2 = this.debuggingView.getInfoPanel();
            ((InfoPanel)object2).setShowDeadlock(false);
            ((InfoPanel)object2).setShowThreadLocks(null, null);
            ((InfoPanel)object2).setShowStepBrkp(null, null, null);
        }
        if (jPDADebugger != null) {
            object2 = this.debuggingView.getInfoPanel();
            object = this.debuggerToListener.get(jPDADebugger);
            if (object != null) {
                DeadlockDetector deadlockDetector = jPDADebugger.getThreadsCollector().getDeadlockDetector();
                deadlockDetector.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                if (deadlockDetector.getDeadlocks() != null) {
                    ((InfoPanel)object2).setShowDeadlock(true);
                }
                ((InfoPanel)object2).setShowThreadLocks(((DebuggerListener)object).lockedThread, ((DebuggerListener)object).lockerThreads);
                ((InfoPanel)object2).setShowStepBrkp(((DebuggerListener)object).debugger, ((DebuggerListener)object).stepBrkpThread, ((DebuggerListener)object).stepBrkpBreakpoint);
            }
            ((InfoPanel)object2).recomputeMenuItems(this.getHits());
        } else {
            this.debuggingView = null;
        }
        this.currentDebugger = jPDADebugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<JPDAThread> getCurrentThreadsHistory() {
        LinkedList<JPDAThread> linkedList = this.currentThreadsHistory;
        synchronized (linkedList) {
            ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>(this.currentThreadsHistory.size());
            for (JPDAThread jPDAThread : this.currentThreadsHistory) {
                if (!jPDAThread.isSuspended()) continue;
                arrayList.add(jPDAThread);
            }
            return arrayList;
        }
    }

    public synchronized List<JPDAThread> getThreads() {
        ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>();
        for (JPDADebugger jPDADebugger : this.debuggerToListener.keySet()) {
            if (jPDADebugger == null || jPDADebugger.getState() == 4) continue;
            arrayList.addAll(jPDADebugger.getThreadsCollector().getAllThreads());
        }
        return arrayList;
    }

    private void addBreakpointHit(JPDAThread jPDAThread) {
        if (jPDAThread != null && !this.hits.contains(jPDAThread)) {
            this.hits.add(jPDAThread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().addBreakpointHit(jPDAThread, this.hits.size());
            }
        }
    }

    private void removeBreakpointHit(JPDAThread jPDAThread) {
        if (jPDAThread != null && this.hits.contains(jPDAThread)) {
            this.hits.remove(jPDAThread);
            if (this.debuggingView != null) {
                this.debuggingView.getInfoPanel().removeBreakpointHit(jPDAThread, this.hits.size());
            }
        }
    }

    public synchronized List<JPDAThread> getHits() {
        ArrayList<JPDAThread> arrayList = new ArrayList<JPDAThread>();
        for (JPDAThread jPDAThread : this.hits.stoppedThreads) {
            arrayList.add(jPDAThread);
        }
        return arrayList;
    }

    public synchronized int getHitsCount() {
        return this.hits.size();
    }

    public synchronized boolean isBreakpointHit(JPDAThread jPDAThread) {
        return this.hits.contains(jPDAThread);
    }

    public synchronized void goToHit() {
        this.hits.goToHit();
    }

    public JPDADebugger getDebugger() {
        return this.currentDebugger;
    }

    public String[] getProperties() {
        return new String[]{"debuggerEngines"};
    }

    public synchronized void engineAdded(DebuggerEngine debuggerEngine) {
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger != null) {
            DebuggerListener debuggerListener = new DebuggerListener(jPDADebugger);
            this.debuggerToListener.put(jPDADebugger, debuggerListener);
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    public synchronized void engineRemoved(DebuggerEngine debuggerEngine) {
        JPDADebugger jPDADebugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (jPDADebugger != null) {
            DebuggerListener debuggerListener = this.debuggerToListener.remove(jPDADebugger);
            if (debuggerListener != null) {
                debuggerListener.unregister();
            }
            if (this.debuggingView != null) {
                this.debuggingView.updateSessionsComboBox();
            }
        }
    }

    static class BreakpointHits {
        private Set<JPDAThread> stoppedThreadsSet = new HashSet<JPDAThread>();
        private LinkedList<JPDAThread> stoppedThreads = new LinkedList();

        BreakpointHits() {
        }

        public void goToHit() {
            JPDAThread jPDAThread = this.stoppedThreads.getLast();
            jPDAThread.makeCurrent();
        }

        public boolean contains(JPDAThread jPDAThread) {
            return this.stoppedThreadsSet.contains(jPDAThread);
        }

        public boolean add(JPDAThread jPDAThread) {
            if (this.stoppedThreadsSet.add(jPDAThread)) {
                this.stoppedThreads.addFirst(jPDAThread);
                return true;
            }
            return false;
        }

        public boolean remove(JPDAThread jPDAThread) {
            if (this.stoppedThreadsSet.remove(jPDAThread)) {
                this.stoppedThreads.remove(jPDAThread);
                return true;
            }
            return false;
        }

        public void clear() {
            this.stoppedThreadsSet.clear();
            this.stoppedThreads.clear();
        }

        public int size() {
            return this.stoppedThreads.size();
        }
    }

    class DebuggerListener
    implements PropertyChangeListener {
        private JPDADebugger debugger;
        Set<JPDAThread> threads = new HashSet<JPDAThread>();
        List<JPDAThread> lockerThreads;
        JPDAThread lockedThread;
        JPDAThread stepBrkpThread;
        JPDABreakpoint stepBrkpBreakpoint;

        DebuggerListener(JPDADebugger jPDADebugger) {
            this.debugger = jPDADebugger;
            jPDADebugger.addPropertyChangeListener((PropertyChangeListener)this);
            List list = jPDADebugger.getThreadsCollector().getAllThreads();
            for (JPDAThread jPDAThread : list) {
                this.threads.add(jPDAThread);
                ((Customizer)jPDAThread).addPropertyChangeListener(this);
            }
            DeadlockDetector deadlockDetector = jPDADebugger.getThreadsCollector().getDeadlockDetector();
            deadlockDetector.addPropertyChangeListener((PropertyChangeListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JPDADebugger) {
                if ("threadStarted".equals(string)) {
                    JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getNewValue();
                    if (this.threads.add(jPDAThread)) {
                        ((Customizer)jPDAThread).addPropertyChangeListener(this);
                    }
                } else if ("threadDied".equals(string)) {
                    JPDAThread jPDAThread = (JPDAThread)propertyChangeEvent.getOldValue();
                    if (this.threads.remove(jPDAThread)) {
                        LinkedList<JPDAThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                        synchronized (linkedList) {
                            ThreadsListener.this.currentThreadsHistory.remove(jPDAThread);
                        }
                        ((Customizer)jPDAThread).removePropertyChangeListener(this);
                    }
                } else if ("currentThread".equals(string)) {
                    JPDAThread jPDAThread = this.debugger.getCurrentThread();
                    ThreadsListener.this.removeBreakpointHit(jPDAThread);
                    LinkedList<JPDAThread> linkedList = ThreadsListener.this.currentThreadsHistory;
                    synchronized (linkedList) {
                        ThreadsListener.this.currentThreadsHistory.remove(jPDAThread);
                        ThreadsListener.this.currentThreadsHistory.addFirst(jPDAThread);
                    }
                } else if ("state".equals(string) && this.debugger != null && this.debugger.getState() == 4) {
                    this.unregister();
                }
            } else if (object instanceof JPDAThread) {
                JPDAThread jPDAThread = (JPDAThread)object;
                if ("currentBreakpoint".equals(string)) {
                    if (!this.isCurrent(jPDAThread)) {
                        if (this.isAtBreakpoint(jPDAThread)) {
                            ThreadsListener.this.addBreakpointHit(jPDAThread);
                        } else {
                            ThreadsListener.this.removeBreakpointHit(jPDAThread);
                        }
                    } else {
                        ThreadsListener.this.removeBreakpointHit(jPDAThread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("suspended".equals(string)) {
                    if (!jPDAThread.isSuspended()) {
                        ThreadsListener.this.removeBreakpointHit(jPDAThread);
                    }
                    if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                        ThreadsListener.this.debuggingView.refreshView();
                    }
                } else if ("lockerThreads".equals(string)) {
                    List list;
                    try {
                        Method method = jPDAThread.getClass().getMethod("getLockerThreads", new Class[0]);
                        list = (List)method.invoke((Object)jPDAThread, new Object[0]);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                        list = null;
                    }
                    this.setShowThreadLocks(jPDAThread, list);
                } else if ("stepSuspendedByBreakpoint".equals(string)) {
                    this.setShowStepBrkp(jPDAThread, (JPDABreakpoint)propertyChangeEvent.getNewValue());
                }
            } else if (object instanceof DeadlockDetector && "deadlock".equals(string)) {
                this.setShowDeadlock(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void unregister() {
            if (this.debugger == null) {
                return;
            }
            for (JPDAThread object : this.threads) {
                ((Customizer)object).removePropertyChangeListener(this);
            }
            Object object = ThreadsListener.this.currentThreadsHistory;
            synchronized (object) {
                for (JPDAThread jPDAThread : this.threads) {
                    ThreadsListener.this.currentThreadsHistory.remove(jPDAThread);
                }
            }
            object = ThreadsListener.this.hits;
            synchronized (object) {
                for (JPDAThread jPDAThread : this.threads) {
                    ThreadsListener.this.removeBreakpointHit(jPDAThread);
                }
            }
            this.threads.clear();
            this.lockedThread = null;
            this.lockerThreads = null;
            this.stepBrkpThread = null;
            this.stepBrkpBreakpoint = null;
            this.debugger.removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger.getThreadsCollector().getDeadlockDetector().removePropertyChangeListener((PropertyChangeListener)this);
            this.debugger = null;
        }

        private boolean isCurrent(JPDAThread jPDAThread) {
            return this.debugger.getCurrentThread() == jPDAThread;
        }

        private boolean isAtBreakpoint(JPDAThread jPDAThread) {
            JPDABreakpoint jPDABreakpoint = jPDAThread.getCurrentBreakpoint();
            return jPDABreakpoint != null && !jPDABreakpoint.isHidden();
        }

        private void setShowDeadlock(boolean bl) {
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowDeadlock(bl);
            }
        }

        private void setShowThreadLocks(JPDAThread jPDAThread, List<JPDAThread> list) {
            this.lockerThreads = list;
            this.lockedThread = jPDAThread;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowThreadLocks(jPDAThread, this.lockerThreads);
            }
        }

        private void setShowStepBrkp(JPDAThread jPDAThread, JPDABreakpoint jPDABreakpoint) {
            this.stepBrkpThread = jPDAThread;
            this.stepBrkpBreakpoint = jPDABreakpoint;
            if (this.debugger == ThreadsListener.this.currentDebugger && ThreadsListener.this.debuggingView != null) {
                ThreadsListener.this.debuggingView.getInfoPanel().setShowStepBrkp(this.debugger, jPDAThread, jPDABreakpoint);
            }
        }
    }
}

