/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.netbeans.api.debugger.Properties;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class ClassesActionsProvider
implements NodeActionsProvider {
    private static Properties classesProperties = Properties.getDefault().getProperties("debugger").getProperties("classesView");
    private TreeModel tree;

    public ClassesActionsProvider(ContextProvider lookupProvider) {
        this.tree = (TreeModel)lookupProvider.lookupFirst("ClassesView", TreeModel.class);
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        return new Action[]{new PackageViewTypeAction(this.tree)};
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
    }

    private static class PackageViewTypeAction
    extends AbstractAction
    implements Presenter.Popup {
        private TreeModel tree;

        PackageViewTypeAction(TreeModel tree) {
            super("");
            this.tree = tree;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            JMenu menu = new JMenu();
            Mnemonics.setLocalizedText((AbstractButton)menu, (String)NbBundle.getMessage(ClassesActionsProvider.class, (String)"LBL_change_package_type"));
            menu.add(this.createChoice(true, NbBundle.getMessage(ClassesActionsProvider.class, (String)"ChangePackageViewTypeAction_list")));
            menu.add(this.createChoice(false, NbBundle.getMessage(ClassesActionsProvider.class, (String)"ChangePackageViewTypeAction_tree")));
            return menu;
        }

        private JMenuItem createChoice(final boolean flat, String label) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)item, (String)label);
            boolean isFlat = classesProperties.getBoolean("flat", true);
            item.setSelected(flat == isFlat);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    classesProperties.setBoolean("flat", flat);
                    try {
                        Method fireTreeChangedMethod = PackageViewTypeAction.this.tree.getClass().getMethod("fireTreeChanged", new Class[0]);
                        try {
                            fireTreeChangedMethod.invoke((Object)PackageViewTypeAction.this.tree, new Object[0]);
                        }
                        catch (IllegalArgumentException ex) {
                        }
                        catch (InvocationTargetException ex) {
                        }
                        catch (IllegalAccessException illegalAccessException) {}
                    }
                    catch (SecurityException ex) {
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            });
            return item;
        }
    }
}

