/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.AbsentInformationException;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.CallStackFrame;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.SourcePathProvider;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class HiddenCallStackFramesFilter
implements TreeModelFilter,
NodeModel,
TableModelFilter,
NodeActionsProvider {
    private ContextProvider lookupProvider;
    private JPDADebugger debugger;
    private SourcePathProvider contextProvider;

    public HiddenCallStackFramesFilter(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    private static String convertSlash(String string) {
        return string.replace(File.separatorChar, '/');
    }

    private static String convertClassNameToRelativePath(String string) {
        int n = string.indexOf(36);
        if (n > 0) {
            string = string.substring(0, n);
        }
        String string2 = string.replace('.', '/') + ".java";
        return string2;
    }

    private SourcePathProvider getSourcePathProvider() {
        if (this.contextProvider == null) {
            List list = this.lookupProvider.lookup(null, SourcePathProvider.class);
            this.contextProvider = (SourcePathProvider)list.get(0);
            int n = list.size();
            for (int i = 1; i < n; ++i) {
                this.contextProvider = new CompoundSourcePathProvider((SourcePathProvider)list.get(i), this.contextProvider);
            }
        }
        return this.contextProvider;
    }

    private String getURL(String string) {
        return this.getSourcePathProvider().getURL(string, false);
    }

    private boolean isOnSourcePath(CallStackFrame callStackFrame) {
        String string = null;
        try {
            string = this.getURL(HiddenCallStackFramesFilter.convertSlash(callStackFrame.getSourcePath(null)));
        }
        catch (AbsentInformationException absentInformationException) {
            string = this.getURL(HiddenCallStackFramesFilter.convertClassNameToRelativePath(callStackFrame.getClassName()));
        }
        return string != null;
    }

    public Object getRoot(TreeModel treeModel) {
        return treeModel.getRoot();
    }

    public int getChildrenCount(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return ((HiddenFrames)object).getStack().size();
        }
        return treeModel.getChildrenCount(object);
    }

    public Object[] getChildren(TreeModel treeModel, Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals(treeModel.getRoot()) || object instanceof JPDAThread) {
            Object[] objectArray = treeModel.getChildren(object, 0, treeModel.getChildrenCount(object));
            if (objectArray.length == 0 || !(objectArray[0] instanceof CallStackFrame)) {
                return objectArray;
            }
            int n3 = objectArray.length;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HiddenFrames hiddenFrames = null;
            for (int i = 0; i < n3; ++i) {
                if (!(objectArray[i] instanceof CallStackFrame)) {
                    arrayList.add(objectArray[i]);
                    continue;
                }
                CallStackFrame callStackFrame = (CallStackFrame)objectArray[i];
                if (!this.isOnSourcePath(callStackFrame)) {
                    if (hiddenFrames == null) {
                        hiddenFrames = new HiddenFrames();
                        arrayList.add(hiddenFrames);
                    }
                    hiddenFrames.addFrame(callStackFrame);
                    continue;
                }
                hiddenFrames = null;
                arrayList.add(callStackFrame);
            }
            int n4 = Math.min(arrayList.size(), n2);
            return arrayList.subList(n, n4).toArray();
        }
        if (object instanceof HiddenFrames) {
            return ((HiddenFrames)object).getStack().toArray();
        }
        return treeModel.getChildren(object, n, n2);
    }

    public boolean isLeaf(TreeModel treeModel, Object object) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return false;
        }
        return treeModel.isLeaf(object);
    }

    public void addModelListener(ModelListener modelListener) {
    }

    public void removeModelListener(ModelListener modelListener) {
    }

    public String getDisplayName(Object object) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return NbBundle.getMessage(HiddenCallStackFramesFilter.class, (String)"LBL_HIDDEN_FRAMES");
        }
        throw new UnknownTypeException(object);
    }

    public String getIconBase(Object object) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return NbBundle.getMessage(HiddenCallStackFramesFilter.class, (String)"RES_FRAME_GROUP");
        }
        throw new UnknownTypeException(object);
    }

    public String getShortDescription(Object object) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return NbBundle.getMessage(HiddenCallStackFramesFilter.class, (String)"TLT_HIDDEN_FRAMES");
        }
        throw new UnknownTypeException(object);
    }

    public void setValueAt(TableModel tableModel, Object object, String string, Object object2) throws UnknownTypeException {
        tableModel.setValueAt(object, string, object2);
    }

    public boolean isReadOnly(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return true;
        }
        return tableModel.isReadOnly(object, string);
    }

    public Object getValueAt(TableModel tableModel, Object object, String string) throws UnknownTypeException {
        if (object instanceof HiddenFrames) {
            return "";
        }
        return tableModel.getValueAt(object, string);
    }

    public void performDefaultAction(Object object) throws UnknownTypeException {
    }

    public Action[] getActions(Object object) throws UnknownTypeException {
        if (!(object instanceof HiddenFrames)) {
            throw new UnknownTypeException(object);
        }
        return new Action[0];
    }

    private static class CompoundSourcePathProvider
    extends SourcePathProvider {
        private SourcePathProvider cp1;
        private SourcePathProvider cp2;

        CompoundSourcePathProvider(SourcePathProvider sourcePathProvider, SourcePathProvider sourcePathProvider2) {
            this.cp1 = sourcePathProvider;
            this.cp2 = sourcePathProvider2;
        }

        public String getURL(String string, boolean bl) {
            String string2 = this.cp1.getURL(string, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getURL(string, bl);
        }

        public String getRelativePath(String string, char c, boolean bl) {
            String string2 = this.cp1.getRelativePath(string, c, bl);
            if (string2 != null) {
                return string2;
            }
            return this.cp2.getRelativePath(string, c, bl);
        }

        public String[] getSourceRoots() {
            String[] stringArray = this.cp1.getSourceRoots();
            String[] stringArray2 = this.cp2.getSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public String[] getOriginalSourceRoots() {
            String[] stringArray = this.cp1.getOriginalSourceRoots();
            String[] stringArray2 = this.cp2.getOriginalSourceRoots();
            String[] stringArray3 = new String[stringArray.length + stringArray2.length];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
            return stringArray3;
        }

        public void setSourceRoots(String[] stringArray) {
            this.cp1.setSourceRoots(stringArray);
            this.cp2.setSourceRoots(stringArray);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.addPropertyChangeListener(propertyChangeListener);
            this.cp2.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.cp1.removePropertyChangeListener(propertyChangeListener);
            this.cp2.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public static class HiddenFrames {
        private List frames = new ArrayList();

        void addFrame(CallStackFrame callStackFrame) {
            this.frames.add(callStackFrame);
        }

        List getStack() {
            return this.frames;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HiddenFrames)) {
                return false;
            }
            if (this.frames.size() != ((HiddenFrames)object).frames.size()) {
                return false;
            }
            if (this.frames.size() == 0) {
                return object == this;
            }
            return this.frames.get(0).equals(((HiddenFrames)object).frames.get(0));
        }

        public int hashCode() {
            if (this.frames.size() == 0) {
                return super.hashCode();
            }
            return this.frames.get(0).hashCode();
        }
    }
}

