/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.ruby.platform;

import java.awt.EventQueue;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.RubyPreferences;
import org.netbeans.modules.ruby.platform.Util;
import org.netbeans.modules.ruby.platform.execution.ExecutionUtils;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyProvider;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.io.ReaderInputStream;

public final class RubyPlatformManager {
    public static final boolean PREINDEXING = Boolean.getBoolean("gsf.preindexing");
    private static final String[] RUBY_EXECUTABLE_NAMES = new String[]{"ruby", "jruby", "rubinius"};
    static Properties TEST_RUBY_PROPS;
    private static final String PLATFORM_PREFIX = "rubyplatform.";
    private static final String PLATFORM_INTEPRETER = ".interpreter";
    private static final String PLATFORM_ID_DEFAULT = "default";
    private static final Logger LOGGER;
    private static final Comparator<RubyPlatform> ALPHABETICAL_COMPARATOR;
    private static Set<RubyPlatform> platforms;
    private static final VetoableChangeSupport VETOABLE_CHANGE_SUPPORT;

    private RubyPlatformManager() {
    }

    static void resetPlatforms() {
        platforms = null;
        RubyPlatformManager.firePlatformsChanged();
    }

    public static synchronized Set<RubyPlatform> getPlatforms() {
        return new HashSet<RubyPlatform>(RubyPlatformManager.getPlatformsInternal());
    }

    public static synchronized SortedSet<? extends RubyPlatform> getSortedPlatforms() {
        TreeSet<RubyPlatform> _platforms = new TreeSet<RubyPlatform>(ALPHABETICAL_COMPARATOR);
        _platforms.addAll(RubyPlatformManager.getPlatformsInternal());
        return _platforms;
    }

    public static synchronized void performPlatformDetection() {
        if (PREINDEXING) {
            return;
        }
        LinkedHashSet<File> rubies = new LinkedHashSet<File>();
        LinkedHashSet<String> candidateDirs = new LinkedHashSet<String>();
        candidateDirs.addAll(Util.dirsOnPath());
        candidateDirs.addAll(Util.rvmRubies());
        for (String dir : candidateDirs) {
            for (String ruby : RUBY_EXECUTABLE_NAMES) {
                File f = RubyPlatformManager.findPlatform(dir, ruby);
                if (f == null) continue;
                rubies.add(f);
            }
        }
        RubyPlatform defaultPlatform = RubyPlatformManager.findDefaultPlatform();
        if (defaultPlatform != null) {
            RubyPlatformManager.getPlatformsInternal().add(defaultPlatform);
        }
        for (File ruby : rubies) {
            try {
                if (RubyPlatformManager.getPlatformByFile(ruby) != null) continue;
                RubyPlatformManager.addPlatform(ruby);
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        RubyPreferences.setFirstPlatformTouch(false);
    }

    private static RubyPlatform findDefaultPlatform() {
        String path = RubyInstallation.getInstance().getJRuby();
        return path == null ? null : new RubyPlatform(PLATFORM_ID_DEFAULT, path, RubyPlatform.Info.forDefaultPlatform());
    }

    private static void firePlatformsChanged() {
        try {
            VETOABLE_CHANGE_SUPPORT.fireVetoableChange("platforms", null, null);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    private static File findPlatform(String dir, String ruby) {
        File f = null;
        if (Utilities.isWindows()) {
            f = new File(dir, ruby + ".exe");
        } else {
            String version;
            f = new File(dir, ruby);
            if (ruby.equals("ruby") && Utilities.isMac() && "/usr/bin/ruby".equals(f.getPath()) && ((version = System.getProperty("os.version")) == null || version.startsWith("10.4"))) {
                return null;
            }
        }
        if (f.isFile()) {
            return f;
        }
        return null;
    }

    private static synchronized Set<RubyPlatform> getPlatformsInternal() {
        if (platforms == null) {
            RubyPlatform defaultPlatform;
            platforms = new HashSet<RubyPlatform>();
            String hardcodedRuby = System.getProperty("ruby.interpreter");
            if (hardcodedRuby != null) {
                RubyPlatform.Info info = new RubyPlatform.Info("User-specified Ruby", "0.1");
                FileObject gems = FileUtil.toFileObject((File)new File(hardcodedRuby)).getParent().getParent().getFileObject("lib/ruby/gems/1.8");
                if (gems != null) {
                    Properties props = new Properties();
                    props.setProperty("ruby_kind", "User-specified Ruby");
                    props.setProperty("ruby_version", "0.1");
                    String gemHome = FileUtil.toFile((FileObject)gems).getAbsolutePath();
                    props.setProperty("gem_home", gemHome);
                    props.setProperty("gem_path", gemHome);
                    props.setProperty("gem_version", "1.0.1 (1.0.1)");
                    props.setProperty("ruby_lib_dir", new File(new File(hardcodedRuby).getParentFile().getParentFile(), "lib" + File.separator + "ruby" + File.separator + "1.8").getPath());
                    info = new RubyPlatform.Info(props);
                }
                platforms.add(new RubyPlatform(PLATFORM_ID_DEFAULT, hardcodedRuby, info));
                return platforms;
            }
            Map p = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{PropertyUtils.globalPropertyProvider()}).getProperties();
            if (p == null) {
                p = Collections.emptyMap();
            }
            boolean foundDefault = false;
            final ArrayList<String> skipped = new ArrayList<String>();
            for (Map.Entry entry : p.entrySet()) {
                String patchLevel;
                String key = (String)entry.getKey();
                if (!key.startsWith(PLATFORM_PREFIX) || !key.endsWith(PLATFORM_INTEPRETER)) continue;
                String id = key.substring(PLATFORM_PREFIX.length(), key.length() - PLATFORM_INTEPRETER.length());
                String idDot = id + '.';
                Properties props = new Properties();
                String libDir = (String)p.get(PLATFORM_PREFIX + idDot + "ruby_lib_dir");
                String kind = (String)p.get(PLATFORM_PREFIX + idDot + "ruby_kind");
                String interpreterPath = (String)entry.getValue();
                if (kind == null) {
                    skipped.add(interpreterPath);
                    continue;
                }
                if (libDir != null) {
                    props.put("ruby_lib_dir", libDir);
                } else if (!"Rubinius".equals(kind)) {
                    LOGGER.warning("no libDir for platform: " + interpreterPath);
                    skipped.add(interpreterPath);
                    continue;
                }
                props.put("ruby_kind", kind);
                props.put("ruby_version", p.get(PLATFORM_PREFIX + idDot + "ruby_version"));
                String jrubyVersion = (String)p.get(PLATFORM_PREFIX + idDot + "jruby_version");
                if (jrubyVersion != null) {
                    props.put("jruby_version", jrubyVersion);
                }
                if ((patchLevel = (String)p.get(PLATFORM_PREFIX + idDot + "ruby_patchlevel")) != null) {
                    props.put("ruby_patchlevel", patchLevel);
                }
                props.put("ruby_release_date", p.get(PLATFORM_PREFIX + idDot + "ruby_release_date"));
                props.put("ruby_platform", p.get(PLATFORM_PREFIX + idDot + "ruby_platform"));
                String gemHome = (String)p.get(PLATFORM_PREFIX + idDot + "gem_home");
                if (gemHome != null) {
                    props.put("gem_home", gemHome);
                    props.put("gem_path", p.get(PLATFORM_PREFIX + idDot + "gem_path"));
                    props.put("gem_version", p.get(PLATFORM_PREFIX + idDot + "gem_version"));
                }
                RubyPlatform.Info info = new RubyPlatform.Info(props);
                platforms.add(new RubyPlatform(id, interpreterPath, info));
                foundDefault |= id.equals(PLATFORM_ID_DEFAULT);
            }
            if (!foundDefault && (defaultPlatform = RubyPlatformManager.findDefaultPlatform()) != null) {
                platforms.add(defaultPlatform);
            }
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    for (String interpreter : skipped) {
                        try {
                            RubyPlatformManager.addPlatform(new File(interpreter));
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            });
            LOGGER.fine("RubyPlatform initial list: " + platforms);
        }
        return platforms;
    }

    public static RubyPlatform getDefaultPlatform() {
        RubyPlatform defaultPlatform = RubyPlatformManager.getPlatformByID(PLATFORM_ID_DEFAULT);
        if (defaultPlatform == null) {
            LOGGER.fine("Default platform is not installed");
        }
        return defaultPlatform;
    }

    public static synchronized RubyPlatform getPlatformByID(String id) {
        for (RubyPlatform p : RubyPlatformManager.getPlatformsInternal()) {
            if (!p.getID().equals(id)) continue;
            return p;
        }
        return null;
    }

    public static synchronized RubyPlatform getPlatformByFile(File interpreter) {
        for (RubyPlatform p : RubyPlatformManager.getPlatformsInternal()) {
            try {
                File toFind;
                File current = new File(p.getInterpreter()).getCanonicalFile();
                if (!current.equals(toFind = interpreter.getCanonicalFile())) continue;
                return p;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    static synchronized RubyPlatform getPlatformByPath(String path) {
        return RubyPlatformManager.getPlatformByFile(new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RubyPlatform addPlatform(final File interpreter) throws IOException {
        if (!interpreter.isFile()) {
            return null;
        }
        RubyPlatform plaf = RubyPlatformManager.getPlatformByFile(interpreter);
        if (plaf != null) {
            return plaf;
        }
        final RubyPlatform.Info info = RubyPlatformManager.computeInfo(interpreter);
        if (info == null) {
            return null;
        }
        if (info.getKind() == null) {
            LOGGER.warning("Getting platform information for " + interpreter + " failed.");
            return null;
        }
        final String id = RubyPlatformManager.computeID(info.getKind());
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    if (RubyPlatformManager.getPlatformByID(id) != null) {
                        throw new IOException("ID " + id + " already taken");
                    }
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.putPlatformProperties(id, interpreter, info, props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        plaf = new RubyPlatform(id, interpreter.getAbsolutePath(), info);
        Class<RubyPlatform> clazz = RubyPlatform.class;
        synchronized (RubyPlatform.class) {
            RubyPlatformManager.getPlatformsInternal().add(plaf);
            // ** MonitorExit[var4_5] (shouldn't be in output)
            RubyPlatformManager.firePlatformsChanged();
            LOGGER.fine("RubyPlatform added: " + plaf);
            return plaf;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removePlatform(final RubyPlatform plaf) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.clearProperties(plaf, props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        Class<RubyPlatform> clazz = RubyPlatform.class;
        synchronized (RubyPlatform.class) {
            RubyPlatformManager.getPlatformsInternal().remove(plaf);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            RubyPlatformManager.firePlatformsChanged();
            LOGGER.fine("RubyPlatform removed: " + plaf);
            return;
        }
    }

    public static void storePlatform(final RubyPlatform plaf) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    EditableProperties props = PropertyUtils.getGlobalProperties();
                    RubyPlatformManager.clearProperties(plaf, props);
                    RubyPlatformManager.putPlatformProperties(plaf.getID(), plaf.getInterpreterFile(), plaf.getInfo(), props);
                    PropertyUtils.putGlobalProperties((EditableProperties)props);
                    return null;
                }
            });
        }
        catch (MutexException e) {
            throw (IOException)e.getException();
        }
        LOGGER.fine("RubyPlatform stored: " + plaf);
    }

    private static void clearProperties(RubyPlatform plaf, EditableProperties props) {
        String id = PLATFORM_PREFIX + plaf.getID();
        props.remove((Object)(id + PLATFORM_INTEPRETER));
        String idDot = id + '.';
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_kind"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_version"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "jruby_version"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_patchlevel"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_release_date"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_platform"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "ruby_lib_dir"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "gem_home"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "gem_path"));
        props.remove((Object)(PLATFORM_PREFIX + idDot + "gem_version"));
    }

    private static void putPlatformProperties(String id, File interpreter, RubyPlatform.Info info, EditableProperties props) throws FileNotFoundException {
        String interpreterKey = PLATFORM_PREFIX + id + PLATFORM_INTEPRETER;
        props.setProperty(interpreterKey, interpreter.getAbsolutePath());
        if (!interpreter.isFile()) {
            throw new FileNotFoundException(interpreter.getAbsolutePath());
        }
        String idDot = id + '.';
        props.setProperty(PLATFORM_PREFIX + idDot + "ruby_kind", info.getKind());
        props.setProperty(PLATFORM_PREFIX + idDot + "ruby_version", info.getVersion());
        if (info.getJVersion() != null) {
            props.setProperty(PLATFORM_PREFIX + idDot + "jruby_version", info.getJVersion());
        }
        if (info.getPatchlevel() != null) {
            props.setProperty(PLATFORM_PREFIX + idDot + "ruby_patchlevel", info.getPatchlevel());
        }
        props.setProperty(PLATFORM_PREFIX + idDot + "ruby_release_date", info.getReleaseDate());
        props.setProperty(PLATFORM_PREFIX + idDot + "ruby_platform", info.getPlatform());
        if (!info.isRubinius()) {
            props.setProperty(PLATFORM_PREFIX + idDot + "ruby_lib_dir", info.getLibDir());
        }
        if (info.getGemHome() != null) {
            props.setProperty(PLATFORM_PREFIX + idDot + "gem_home", info.getGemHome());
            props.setProperty(PLATFORM_PREFIX + idDot + "gem_path", info.getGemPath());
            props.setProperty(PLATFORM_PREFIX + idDot + "gem_version", info.getGemVersion());
        }
    }

    private static String computeID(String kind) {
        String id = kind;
        int i = 0;
        while (RubyPlatformManager.getPlatformByID(id) != null) {
            id = kind + '_' + i;
            ++i;
        }
        return id;
    }

    public static Iterator<RubyPlatform> platformIterator() {
        return RubyPlatformManager.getPlatformsInternal().iterator();
    }

    static RubyPlatform.Info computeInfo(File interpreter) {
        assert (!EventQueue.isDispatchThread()) : "computeInfo should not be run from EDT";
        if (TEST_RUBY_PROPS != null && !RubyPlatformManager.getDefaultPlatform().getInterpreterFile().equals(interpreter)) {
            return new RubyPlatform.Info(TEST_RUBY_PROPS);
        }
        RubyPlatform.Info info = null;
        try {
            int exitValue;
            File platformInfoScript = InstalledFileLocator.getDefault().locate("platform_info.rb", "org.netbeans.modules.ruby.platform", false);
            if (platformInfoScript == null) {
                throw new IllegalStateException("Cannot locate platform_info.rb script");
            }
            ProcessBuilder pb = new ProcessBuilder(interpreter.getAbsolutePath(), platformInfoScript.getAbsolutePath());
            pb.environment().remove("JRUBY_HOME");
            pb.environment().put("JAVA_HOME", ExecutionUtils.getJavaHome());
            ExecutionUtils.logProcess(pb);
            final Process proc = pb.start();
            Thread gatherer = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        proc.waitFor();
                    }
                    catch (InterruptedException e) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                }
            }, "Ruby Platform Gatherer");
            gatherer.start();
            try {
                gatherer.join(30000L);
            }
            catch (InterruptedException e) {
                LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                return null;
            }
            try {
                exitValue = proc.exitValue();
            }
            catch (IllegalThreadStateException e) {
                LOGGER.warning("Detection of platform timeouted");
                proc.destroy();
                return null;
            }
            if (exitValue == 0) {
                Properties props = new Properties();
                if (LOGGER.isLoggable(Level.FINER)) {
                    String stdout = Util.readAsString(proc.getInputStream());
                    String stderr = Util.readAsString(proc.getErrorStream());
                    LOGGER.finer("stdout:\n" + stdout);
                    LOGGER.finer("stderr:\n " + stderr);
                    props.load((InputStream)new ReaderInputStream((Reader)new StringReader(stdout)));
                } else {
                    props.load(proc.getInputStream());
                }
                info = new RubyPlatform.Info(props);
            } else {
                String line;
                LOGGER.severe(interpreter.getAbsolutePath() + " does not seems to be a valid interpreter");
                BufferedReader errors = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                while ((line = errors.readLine()) != null) {
                    LOGGER.severe(line);
                }
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.INFO, "Not a ruby platform: " + interpreter.getAbsolutePath());
        }
        return info;
    }

    public static void addVetoableChangeListener(VetoableChangeListener listener) {
        VETOABLE_CHANGE_SUPPORT.addVetoableChangeListener(listener);
    }

    public static void removeVetoableChangeListener(VetoableChangeListener listener) {
        VETOABLE_CHANGE_SUPPORT.removeVetoableChangeListener(listener);
    }

    static {
        LOGGER = Logger.getLogger(RubyPlatformManager.class.getName());
        ALPHABETICAL_COMPARATOR = new Comparator<RubyPlatform>(){

            @Override
            public int compare(RubyPlatform p1, RubyPlatform p2) {
                int result = Collator.getInstance().compare(p1.getInfo().getLongDescription(), p2.getInfo().getLongDescription());
                if (result == 0) {
                    result = p1.getInterpreter().compareTo(p2.getInterpreter());
                }
                return result;
            }
        };
        VETOABLE_CHANGE_SUPPORT = new VetoableChangeSupport(RubyPlatformManager.class);
    }
}

