/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.execution;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.ruby.platform.Util;

public final class Sudo {
    private final Iterable<String> command;
    private final String message;

    public Sudo(Iterable<String> command) {
        this(command, null);
    }

    public Sudo(Iterable<String> command, String message) {
        this.command = command;
        this.message = message;
    }

    public List<String> createCommand() {
        String gksu = Util.findOnPath("gksu");
        if (gksu != null) {
            return this.compoundGksu(gksu);
        }
        String kdesu = Util.findOnPath("kdesu");
        if (kdesu != null) {
            return this.compoundKdesu(kdesu);
        }
        throw new AssertionError((Object)"sudo tool cannot be found; be sure you've checked it before using GemRunner");
    }

    private List<String> compoundGksu(String gksu) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(gksu);
        argList.add("--su-mode");
        argList.add("--description");
        argList.add(this.message);
        StringBuilder asString = new StringBuilder();
        for (String arg : this.command) {
            asString.append(arg).append(' ');
        }
        argList.add(asString.toString().trim());
        return argList;
    }

    private List<String> compoundKdesu(String kdesu) {
        ArrayList<String> argList = new ArrayList<String>();
        argList.add(kdesu);
        StringBuilder asString = new StringBuilder();
        for (String arg : this.command) {
            asString.append(arg).append(' ');
        }
        argList.add("-c");
        argList.add(asString.toString().trim());
        return argList;
    }
}

