/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.platform.gems;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.netbeans.modules.ruby.platform.gems.Gem;

final class GemListModel
extends AbstractListModel
implements ComboBoxModel {
    private final List<Gem> gems;
    private List<Gem> filtered;
    private Object selectedGem;

    GemListModel(List<Gem> gems, String filter) {
        this.gems = gems;
        this.filtered = gems;
        this.applyFilter(filter);
    }

    void applyFilter(String filter) {
        if (filter == null || filter.length() == 0) {
            this.filtered = this.gems;
        } else {
            Pattern pattern = null;
            String lcFilter = null;
            if (filter.indexOf(42) != -1 || filter.indexOf(94) != -1 || filter.indexOf(36) != -1) {
                try {
                    pattern = Pattern.compile(filter, 2);
                }
                catch (PatternSyntaxException pse) {}
            } else {
                lcFilter = filter.toLowerCase(Locale.ENGLISH);
            }
            this.filtered = new ArrayList<Gem>();
            for (Gem gem : this.gems) {
                if (pattern == null) {
                    if (lcFilter != null) {
                        String lcDesc;
                        String lcName = gem.getName().toLowerCase();
                        if (lcName.indexOf(lcFilter) != -1) {
                            this.filtered.add(gem);
                            continue;
                        }
                        if (gem.getDescription() == null || (lcDesc = gem.getDescription().toLowerCase()).indexOf(lcFilter) == -1) continue;
                        this.filtered.add(gem);
                        continue;
                    }
                    this.filtered.add(gem);
                    continue;
                }
                if (!pattern.matcher(gem.getName()).find() && (gem.getDescription() == null || !pattern.matcher(gem.getDescription()).find())) continue;
                this.filtered.add(gem);
            }
        }
        this.fireContentsChanged(this, -1, -1);
    }

    public int getAllSize() {
        return this.gems.size();
    }

    @Override
    public int getSize() {
        return this.filtered.size();
    }

    @Override
    public Object getElementAt(int index) {
        return index >= 0 && index < this.filtered.size() ? this.filtered.get(index) : null;
    }

    @Override
    public void setSelectedItem(Object selectedGem) {
        this.selectedGem = selectedGem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedGem;
    }
}

