/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import org.netbeans.validation.api.Severity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Problem
implements Comparable<Problem> {
    public static final Problem NO_PROBLEM = new Problem();
    private final String message;
    private final Severity severity;

    public Problem(String message, Severity severity) {
        if (message == null) {
            throw new NullPointerException("Null message");
        }
        if (severity == null) {
            throw new NullPointerException("Null severity");
        }
        this.message = message;
        this.severity = severity;
    }

    private Problem() {
        this.message = "";
        this.severity = null;
    }

    public Severity severity() {
        return this.severity;
    }

    public static Problem worst(Problem p1, Problem p2) {
        if (p1 == null) {
            throw new NullPointerException("Passed Problem p1 was null");
        }
        if (p2 == null) {
            throw new NullPointerException("Passed Problem p2 was null");
        }
        return p2.compareTo(p1) < 0 ? p2 : p1;
    }

    public boolean isFatal() {
        return this.severity == Severity.FATAL;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public int compareTo(Problem o) {
        int ix = this == NO_PROBLEM ? -1 : this.severity.ordinal();
        int oid = o == NO_PROBLEM ? -1 : o.severity.ordinal();
        return -(ix - oid);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != Problem.class) {
            return false;
        }
        Problem p = (Problem)o;
        if (p == NO_PROBLEM) {
            return this == NO_PROBLEM;
        }
        return p.severity == this.severity && p.getMessage().equals(this.getMessage());
    }

    public String toString() {
        if (this == NO_PROBLEM) {
            return "(NO_PROBLEM)";
        }
        return this.getMessage() + " (" + (Object)((Object)this.severity()) + ")";
    }

    public int hashCode() {
        if (this == NO_PROBLEM) {
            return 0;
        }
        return this.message.hashCode() * (this.severity.hashCode() + 1);
    }
}

