/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.VCSVisibilityQuery;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.netbeans.spi.queries.VisibilityQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class VcsVisibilityQueryImplementation
implements VisibilityQueryImplementation2 {
    private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private static VcsVisibilityQueryImplementation instance;

    public VcsVisibilityQueryImplementation() {
        instance = this;
    }

    public static VcsVisibilityQueryImplementation getInstance() {
        return instance;
    }

    public boolean isVisible(File file) {
        VersioningSystem system = VersioningManager.getInstance().getOwner(file);
        if (system == null) {
            return true;
        }
        VCSVisibilityQuery vqi = system.getVisibilityQuery();
        return vqi == null ? true : vqi.isVisible(file);
    }

    public boolean isVisible(FileObject fileObject) {
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file == null) {
            return true;
        }
        return this.isVisible(file);
    }

    public synchronized void addChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.add(l);
        this.listeners = newList;
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        ArrayList<ChangeListener> newList = new ArrayList<ChangeListener>(this.listeners);
        newList.remove(l);
        this.listeners = newList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireVisibilityChanged() {
        ChangeListener[] ls;
        VcsVisibilityQueryImplementation vcsVisibilityQueryImplementation = this;
        synchronized (vcsVisibilityQueryImplementation) {
            ls = this.listeners.toArray(new ChangeListener[this.listeners.size()]);
        }
        ChangeEvent event = new ChangeEvent(this);
        for (ChangeListener l : ls) {
            l.stateChanged(event);
        }
    }
}

