/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.spi;

import java.io.File;
import java.io.FileFilter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.versioning.Accessor;
import org.netbeans.modules.versioning.FlatFolder;
import org.netbeans.modules.versioning.Utils;
import org.netbeans.modules.versioning.VersioningManager;
import org.netbeans.modules.versioning.spi.AccessorImpl;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.spi.VersioningSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public final class VCSContext {
    public static final VCSContext EMPTY = new VCSContext((Node[])null, VCSContext.emptySet(), VCSContext.emptySet());
    private static final Logger LOG = Logger.getLogger(VCSContext.class.getName());
    private static Reference<VCSContext> contextCached = new WeakReference<Object>(null);
    private static Reference<Node[]> contextNodesCached = new WeakReference<Object>(null);
    private final Lookup elements;
    private final Set<File> unfilteredRootFiles;
    private final Set<File> rootFiles;
    private final Set<File> exclusions;
    private Set<File> computedFilesCached;
    private FileFilter fileFilterCached;

    static VCSContext forFiles(Set<File> rootFiles, Set<? extends FileObject> originalFiles) {
        return new VCSContext(originalFiles, rootFiles, VCSContext.emptySet());
    }

    public static synchronized VCSContext forNodes(Node[] nodes) {
        VCSContext ctx;
        if (Arrays.equals(contextNodesCached.get(), nodes) && (ctx = contextCached.get()) != null) {
            return ctx;
        }
        HashSet<File> rootFiles = new HashSet<File>(nodes.length);
        HashSet<File> rootFileExclusions = new HashSet<File>(5);
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            File aFile = (File)node.getLookup().lookup(File.class);
            if (aFile != null) {
                rootFiles.add(aFile);
                continue;
            }
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project != null) {
                VCSContext.addProjectFiles(rootFiles, rootFileExclusions, project);
                continue;
            }
            VCSContext.addFileObjects(node, rootFiles);
        }
        if (rootFiles.isEmpty()) {
            LOG.fine("forNodes: context contains no root files");
        }
        ArrayList<File> unversionedFiles = new ArrayList<File>(rootFiles.size());
        HashSet<VersioningSystem> projectOwners = new HashSet<VersioningSystem>(2);
        for (File root : rootFiles) {
            VersioningSystem owner = VersioningManager.getInstance().getOwner(root);
            if (owner == null) {
                unversionedFiles.add(root);
                continue;
            }
            projectOwners.add(owner);
        }
        if (projectOwners.size() != 0) {
            if (projectOwners.size() == 1) {
                for (File unversionedFile : unversionedFiles) {
                    Iterator i = rootFileExclusions.iterator();
                    while (i.hasNext()) {
                        File exclusion = (File)i.next();
                        if (!Utils.isAncestorOrEqual(unversionedFile, exclusion)) continue;
                        i.remove();
                    }
                }
                rootFiles.removeAll(unversionedFiles);
            } else {
                rootFileExclusions.clear();
                rootFiles.clear();
            }
        }
        VCSContext ctx2 = new VCSContext(nodes, rootFiles, rootFileExclusions);
        contextCached = new WeakReference<VCSContext>(ctx2);
        contextNodesCached = new WeakReference<Node[]>(nodes);
        return ctx2;
    }

    public synchronized Set<File> computeFiles(FileFilter filter) {
        if (this.computedFilesCached == null || filter != this.fileFilterCached) {
            this.computedFilesCached = VCSContext.substract(this.rootFiles, this.exclusions, filter);
            this.fileFilterCached = filter;
        }
        return this.computedFilesCached;
    }

    public Lookup getElements() {
        return this.elements;
    }

    public Set<File> getFiles() {
        return this.unfilteredRootFiles;
    }

    public Set<File> getRootFiles() {
        return this.rootFiles;
    }

    public Set<File> getExclusions() {
        return this.exclusions;
    }

    public boolean contains(File file) {
        block0: for (File root : this.rootFiles) {
            if (!Utils.isAncestorOrEqual(root, file)) continue;
            for (File excluded : this.exclusions) {
                if (!Utils.isAncestorOrEqual(excluded, file)) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    private static void addProjectFiles(Collection<File> rootFiles, Collection<File> rootFilesExclusions, Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
        block2: for (int j = 0; j < sourceGroups.length; ++j) {
            SourceGroup sourceGroup = sourceGroups[j];
            FileObject srcRootFo = sourceGroup.getRootFolder();
            File rootFile = FileUtil.toFile((FileObject)srcRootFo);
            if (rootFile == null) continue;
            if (!srcRootFo.isValid()) {
                LOG.log(Level.WARNING, "addProjectFiles: invalid source root {0}", srcRootFo);
                continue;
            }
            rootFiles.add(rootFile);
            FileObject[] rootChildren = srcRootFo.getChildren();
            for (int i = 0; i < rootChildren.length; ++i) {
                FileObject rootChildFo = rootChildren[i];
                File child = FileUtil.toFile((FileObject)rootChildFo);
                try {
                    if (!srcRootFo.isValid()) {
                        LOG.log(Level.WARNING, "addProjectFiles: source root {0} changed from valid to invalid", srcRootFo);
                        continue block2;
                    }
                    if (child == null || !rootChildFo.isValid() || sourceGroup.contains(rootChildFo) || SharabilityQuery.getSharability((File)child) == 2) continue;
                    rootFilesExclusions.add(child);
                    continue;
                }
                catch (IllegalArgumentException ex) {
                    Logger logger = LOG;
                    logger.log(Level.WARNING, "addProjectFiles: IAE");
                    logger.log(Level.WARNING, "rootFO: " + srcRootFo);
                    if (srcRootFo != sourceGroup.getRootFolder()) {
                        logger.log(Level.WARNING, "root FO has changed");
                    }
                    String children = "[";
                    for (FileObject fo : rootChildren) {
                        children = children + "\"" + fo.getPath() + "\", ";
                    }
                    children = children + "]";
                    logger.log(Level.WARNING, "srcRootFo.getChildren(): " + children);
                    if (!rootChildFo.isValid()) {
                        logger.log(Level.WARNING, rootChildFo + " does not exist ");
                    }
                    if (!FileUtil.isParentOf((FileObject)srcRootFo, (FileObject)rootChildFo)) {
                        logger.log(Level.WARNING, rootChildFo + " is not under " + srcRootFo);
                    }
                    logger.log(Level.WARNING, null, ex);
                }
            }
        }
    }

    private static void addFileObjects(Node node, Set<File> rootFiles) {
        Collection folders = node.getLookup().lookup(new Lookup.Template(NonRecursiveFolder.class)).allInstances();
        ArrayList<File> nodeFiles = new ArrayList<File>();
        if (folders.size() > 0) {
            for (NonRecursiveFolder nonRecursiveFolder : folders) {
                File file = FileUtil.toFile((FileObject)nonRecursiveFolder.getFolder());
                if (file == null) continue;
                nodeFiles.add(new FlatFolder(file.getAbsolutePath()));
            }
        } else {
            Collection fileObjects = node.getLookup().lookup(new Lookup.Template(FileObject.class)).allInstances();
            if (fileObjects.size() > 0) {
                nodeFiles.addAll(VCSContext.toFileCollection(fileObjects));
            } else {
                DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
                if (dataObject instanceof DataShadow) {
                    dataObject = ((DataShadow)dataObject).getOriginal();
                }
                if (dataObject != null) {
                    Collection<File> doFiles = VCSContext.toFileCollection(dataObject.files());
                    nodeFiles.addAll(doFiles);
                }
            }
        }
        rootFiles.addAll(nodeFiles);
    }

    private static Collection<File> toFileCollection(Collection<? extends FileObject> fileObjects) {
        HashSet<File> files = new HashSet<File>(fileObjects.size() * 4 / 3 + 1);
        for (FileObject fileObject : fileObjects) {
            files.add(FileUtil.toFile((FileObject)fileObject));
        }
        files.remove(null);
        return files;
    }

    private VCSContext(Set<File> rootFiles, Set<File> exclusions, Object ... elements) {
        HashSet<File> tempRootFiles = new HashSet<File>(rootFiles);
        HashSet<File> tempExclusions = new HashSet<File>(exclusions);
        this.unfilteredRootFiles = Collections.unmodifiableSet(new HashSet<File>(tempRootFiles));
        tempExclusions.removeAll(tempRootFiles);
        while (this.normalize(tempRootFiles, tempExclusions)) {
        }
        this.rootFiles = Collections.unmodifiableSet(tempRootFiles);
        this.exclusions = Collections.unmodifiableSet(tempExclusions);
        this.elements = Lookups.fixed((Object[])elements);
    }

    private VCSContext(Node[] nodes, Set<File> rootFiles, Set<File> exclusions) {
        this(rootFiles, exclusions, nodes != null ? (Object[])nodes : new Node[]{});
    }

    private VCSContext(Set<? extends FileObject> elements, Set<File> rootFiles, Set<File> exclusions) {
        this(rootFiles, exclusions, new Object[]{elements != null ? elements : Collections.EMPTY_SET});
    }

    private boolean normalize(Set<File> rootFiles, Set<File> exclusions) {
        for (File root : rootFiles) {
            Iterator<File> j = exclusions.iterator();
            while (j.hasNext()) {
                File exclusion = j.next();
                if (!Utils.isAncestorOrEqual(exclusion, root)) continue;
                j.remove();
                this.exclusionRemoved(exclusions, exclusion, root);
                return true;
            }
        }
        this.removeDuplicates(rootFiles);
        this.removeDuplicates(exclusions);
        return false;
    }

    private void exclusionRemoved(Set<File> exclusions, File exclusion, File root) {
        File[] exclusionChildren = exclusion.listFiles();
        if (exclusionChildren == null) {
            return;
        }
        for (int i = 0; i < exclusionChildren.length; ++i) {
            File child = exclusionChildren[i];
            if (Utils.isAncestorOrEqual(root, child)) continue;
            exclusions.add(child);
        }
    }

    private static Set<File> substract(Set<File> roots, Set<File> exclusions, FileFilter filter) {
        HashSet<File> files = new HashSet<File>(roots);
        HashSet<File> checkedFiles = new HashSet<File>();
        for (File exclusion : exclusions) {
            assert (exclusion != null);
            do {
                File parent = exclusion.getParentFile();
                if (!checkedFiles.contains(exclusion.getParentFile())) {
                    VCSContext.addSiblings(files, exclusion, filter);
                    checkedFiles.add(parent);
                }
                exclusion = parent;
                files.remove(exclusion);
            } while (!roots.contains(exclusion));
        }
        files.removeAll(exclusions);
        return files;
    }

    private static void addSiblings(Set<File> files, File exclusion, FileFilter filter) {
        File[] siblings;
        if (exclusion.getParentFile() == null) {
            return;
        }
        for (File sibling : siblings = exclusion.getParentFile().listFiles()) {
            if (!filter.accept(sibling)) continue;
            files.add(sibling);
        }
        files.remove(exclusion);
    }

    private static final Set<File> emptySet() {
        return Collections.emptySet();
    }

    private void removeDuplicates(Set<File> files) {
        ArrayList<File> newFiles = new ArrayList<File>();
        block0: for (File file : files) {
            Iterator j = newFiles.iterator();
            while (j.hasNext()) {
                File includedFile = (File)j.next();
                if (Utils.isAncestorOrEqual(includedFile, file) && (file.isFile() || !VersioningSupport.isFlat(includedFile))) continue block0;
                if (!Utils.isAncestorOrEqual(file, includedFile) || !includedFile.isFile() && VersioningSupport.isFlat(file)) continue;
                j.remove();
            }
            newFiles.add(file);
        }
        files.clear();
        files.addAll(newFiles);
    }

    static {
        Accessor.VCSContextAccessor = new AccessorImpl();
    }
}

