/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.support;

import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.refactoring.support.CsmRefactoringUtils;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.openide.filesystems.FileObject;

public class ElementGripFactory {
    private static ElementGripFactory instance;
    private WeakHashMap<FileObject, Interval> map = new WeakHashMap();

    private ElementGripFactory() {
    }

    public static ElementGripFactory getDefault() {
        if (instance == null) {
            instance = new ElementGripFactory();
        }
        return instance;
    }

    public void cleanUp() {
        this.map.clear();
    }

    public ElementGrip get(FileObject fileObject, int position) {
        Interval start = this.map.get(fileObject);
        if (start == null) {
            return null;
        }
        try {
            return start.get((long)((long)position)).item;
        }
        catch (RuntimeException e) {
            return start.item;
        }
    }

    public ElementGrip getParent(ElementGrip el) {
        Interval start = this.map.get(el.getFileObject());
        return start == null ? null : start.getParent(el);
    }

    public ElementGrip putInComposite(FileObject parentFile, CsmOffsetable csmObj) {
        this.put(parentFile, csmObj);
        ElementGrip composite = this.get(parentFile, csmObj.getStartOffset());
        if (composite != null) {
            composite.initParent();
            for (ElementGrip elemParent = composite.getParent(); elemParent != null; elemParent = elemParent.getParent()) {
                elemParent.initParent();
            }
        }
        return composite;
    }

    public void put(FileObject parentFile, CsmOffsetable csmObj) {
        Interval root = this.map.get(parentFile);
        Interval i = Interval.createInterval(csmObj, root, null, parentFile);
        if (i != null) {
            this.map.put(parentFile, i);
        }
    }

    private static class Interval {
        long from = -1L;
        long to = -1L;
        Set<Interval> subintervals = new HashSet<Interval>();
        ElementGrip item = null;

        private Interval() {
        }

        Interval get(long position) {
            if (this.from <= position && this.to >= position) {
                for (Interval o : this.subintervals) {
                    Interval ob = o.get(position);
                    if (ob == null) continue;
                    return ob;
                }
                return this;
            }
            return null;
        }

        ElementGrip getParent(ElementGrip eh) {
            for (Interval i : this.subintervals) {
                if (i.item.equals(eh)) {
                    return this.item;
                }
                ElementGrip e = i.getParent(eh);
                if (e == null) continue;
                return e;
            }
            return null;
        }

        public static Interval createInterval(CsmOffsetable csmObj, Interval root, Interval previous, FileObject parentFile) {
            Interval o;
            long start = csmObj.getStartOffset();
            long end = csmObj.getEndOffset();
            CsmObject encl = CsmRefactoringUtils.getEnclosingElement((CsmObject)csmObj);
            if (!CsmRefactoringUtils.isLangContainerFeature((CsmObject)csmObj)) {
                if (!CsmKindUtilities.isOffsetable((Object)encl)) {
                    return null;
                }
                return Interval.createInterval((CsmOffsetable)encl, root, previous, parentFile);
            }
            Interval i = null;
            if (root != null && (o = root.get(start)) != null && csmObj != null && csmObj.equals(o.item.getResolved())) {
                if (previous != null) {
                    o.subintervals.add(previous);
                }
                return null;
            }
            if (i == null) {
                i = new Interval();
            }
            if (i.from != start) {
                ElementGrip currentHandle2;
                i.from = start;
                i.to = end;
                i.item = currentHandle2 = new ElementGrip(csmObj);
            }
            if (previous != null) {
                i.subintervals.add(previous);
            }
            if (!CsmKindUtilities.isOffsetable((Object)encl)) {
                return i;
            }
            return Interval.createInterval((CsmOffsetable)encl, root, i, parentFile);
        }

        public String toString() {
            return "" + this.from + "-" + this.to + " :" + this.item;
        }
    }
}

