/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.InitializationException;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.swing.NbiButton;
import org.netbeans.installer.utils.helper.swing.NbiDirectoryChooser;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiTextField;
import org.netbeans.installer.wizard.components.panels.ComponentsSelectionPanel;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class DestinationPanel
extends ErrorMessagePanel {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(DestinationPanel.class, "DP.title");
    public static final String DEFAULT_DESCRIPTION = ResourceUtils.getString(DestinationPanel.class, "DP.description");
    public static final String DESTINATION_LABEL_TEXT_PROPERTY = "destination.label.text";
    public static final String DESTINATION_BUTTON_TEXT_PROPERTY = "destination.button.text";
    public static final String DEFAULT_DESTINATION_LABEL_TEXT = ResourceUtils.getString(DestinationPanel.class, "DP.destination.label.text");
    public static final String DEFAULT_DESTINATION_BUTTON_TEXT = ResourceUtils.getString(DestinationPanel.class, "DP.destination.button.text");
    public static final String ERROR_NULL_PROPERTY = "error.null";
    public static final String ERROR_NOT_VALID_PROPERTY = "error.not.valid";
    public static final String ERROR_CONTAINS_EXCLAMATION_PROPERTY = "error.contains.exclamation";
    public static final String ERROR_CONTAINS_SEMICOLON_PROPERTY = "error.contains.semicolon";
    public static final String ERROR_CONTAINS_COLON_PROPERTY = "error.contains.colon";
    public static final String ERROR_CONTAINS_AMPERSAND_PROPERTY = "error.contains.ampersand";
    public static final String ERROR_CONTAINS_WRONG_CHAR_PROPERTY = "error.contains.wrong.char";
    public static final String ERROR_MATCHES_PROHIBITED_REGEXP = "error.matches.prohibited.regexp";
    public static final String ERROR_NOT_ABSOLUTE_PROPERTY = "error.not.absolute";
    public static final String ERROR_CANNOT_CANONIZE_PROPERTY = "error.cannot.canonize";
    public static final String ERROR_NOT_DIRECTORY_PROPERTY = "error.not.directory";
    public static final String ERROR_NOT_READABLE_PROPERTY = "error.not.readable";
    public static final String ERROR_NOT_WRITABLE_PROPERTY = "error.not.writable";
    public static final String ERROR_NOT_EMPTY_PROPERTY = "error.not.empty";
    public static final String ERROR_NOT_ENDS_WITH_APP_PROPERTY = "error.not.ends.with.app";
    public static final String ERROR_NOT_ENOUGH_SPACE_PROPERTY = "error.not.enough.space";
    public static final String ERROR_CANNOT_GET_LOGIC_PROPERTY = "error.cannot.get.logic";
    public static final String ERROR_CANNOT_CHECK_SPACE_PROPERTY = "error.cannot.check.space";
    public static final String DEFAULT_ERROR_NULL = ResourceUtils.getString(DestinationPanel.class, "DP.error.null");
    public static final String DEFAULT_ERROR_NOT_VALID = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.valid");
    public static final String DEFAULT_ERROR_CONTAINS_EXCLAMATION = ResourceUtils.getString(DestinationPanel.class, "DP.error.contains.exclamation");
    public static final String DEFAULT_ERROR_CONTAINS_SEMICOLON = ResourceUtils.getString(DestinationPanel.class, "DP.error.contains.semicolon");
    public static final String DEFAULT_ERROR_CONTAINS_COLON = ResourceUtils.getString(DestinationPanel.class, "DP.error.contains.colon");
    public static final String DEFAULT_ERROR_CONTAINS_AMPERSAND = ResourceUtils.getString(DestinationPanel.class, "DP.error.contains.ampersand");
    public static final String DEFAULT_ERROR_CONTAINS_WRONG_CHAR = ResourceUtils.getString(DestinationPanel.class, "DP.error.contains.wrong.char");
    public static final String DEFAULT_ERROR_MATCHES_PROHIBITIED_REGEXP = ResourceUtils.getString(DestinationPanel.class, "DP.error.matches.prohibited.regexp");
    public static final String DEFAULT_ERROR_NOT_ABSOLUTE = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.absolute");
    public static final String DEFAULT_ERROR_CANNOT_CANONIZE = ResourceUtils.getString(DestinationPanel.class, "DP.error.cannot.canonize");
    public static final String DEFAULT_ERROR_NOT_DIRECTORY = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.directory");
    public static final String DEFAULT_ERROR_NOT_READABLE = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.readable");
    public static final String DEFAULT_ERROR_NOT_WRITABLE = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.writable");
    public static final String DEFAULT_ERROR_NOT_EMPTY = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.empty");
    public static final String DEFAULT_ERROR_NOT_ENDS_WITH_APP = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.ends.with.app");
    public static final String DEFAULT_ERROR_NOT_ENOUGH_SPACE = ResourceUtils.getString(DestinationPanel.class, "DP.error.not.enough.space");
    public static final String DEFAULT_ERROR_CANNOT_GET_LOGIC = ResourceUtils.getString(DestinationPanel.class, "DP.error.cannot.get.logic");
    public static final String DEFAULT_ERROR_CANNOT_CHECK_SPACE = ResourceUtils.getString(ComponentsSelectionPanel.class, "DP.error.cannot.check.space");
    public static final String DEFAULT_DESTINATION = ResourceUtils.getString(DestinationPanel.class, "DP.default.destination");
    public static final String APP_SUFFIX = ".app";
    public static final long REQUIRED_SPACE_ADDITION = 0xA00000L;

    public DestinationPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty("description", DEFAULT_DESCRIPTION);
        this.setProperty(DESTINATION_LABEL_TEXT_PROPERTY, DEFAULT_DESTINATION_LABEL_TEXT);
        this.setProperty(DESTINATION_BUTTON_TEXT_PROPERTY, DEFAULT_DESTINATION_BUTTON_TEXT);
        this.setProperty(ERROR_NULL_PROPERTY, DEFAULT_ERROR_NULL);
        this.setProperty(ERROR_NOT_VALID_PROPERTY, DEFAULT_ERROR_NOT_VALID);
        this.setProperty(ERROR_CONTAINS_EXCLAMATION_PROPERTY, DEFAULT_ERROR_CONTAINS_EXCLAMATION);
        this.setProperty(ERROR_CONTAINS_SEMICOLON_PROPERTY, DEFAULT_ERROR_CONTAINS_SEMICOLON);
        this.setProperty(ERROR_CONTAINS_COLON_PROPERTY, DEFAULT_ERROR_CONTAINS_COLON);
        this.setProperty(ERROR_CONTAINS_AMPERSAND_PROPERTY, DEFAULT_ERROR_CONTAINS_AMPERSAND);
        this.setProperty(ERROR_CONTAINS_WRONG_CHAR_PROPERTY, DEFAULT_ERROR_CONTAINS_WRONG_CHAR);
        this.setProperty(ERROR_MATCHES_PROHIBITED_REGEXP, DEFAULT_ERROR_MATCHES_PROHIBITIED_REGEXP);
        this.setProperty(ERROR_CANNOT_CANONIZE_PROPERTY, DEFAULT_ERROR_CANNOT_CANONIZE);
        this.setProperty(ERROR_NOT_ABSOLUTE_PROPERTY, DEFAULT_ERROR_NOT_ABSOLUTE);
        this.setProperty(ERROR_NOT_DIRECTORY_PROPERTY, DEFAULT_ERROR_NOT_DIRECTORY);
        this.setProperty(ERROR_NOT_READABLE_PROPERTY, DEFAULT_ERROR_NOT_READABLE);
        this.setProperty(ERROR_NOT_WRITABLE_PROPERTY, DEFAULT_ERROR_NOT_WRITABLE);
        this.setProperty(ERROR_NOT_EMPTY_PROPERTY, DEFAULT_ERROR_NOT_EMPTY);
        this.setProperty(ERROR_NOT_ENDS_WITH_APP_PROPERTY, DEFAULT_ERROR_NOT_ENDS_WITH_APP);
        this.setProperty(ERROR_NOT_ENOUGH_SPACE_PROPERTY, DEFAULT_ERROR_NOT_ENOUGH_SPACE);
        this.setProperty(ERROR_CANNOT_GET_LOGIC_PROPERTY, DEFAULT_ERROR_CANNOT_GET_LOGIC);
        this.setProperty(ERROR_CANNOT_CHECK_SPACE_PROPERTY, DEFAULT_ERROR_CANNOT_CHECK_SPACE);
    }

    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new DestinationPanelUi(this);
        }
        return this.wizardUi;
    }

    public void initialize() {
        String destination;
        super.initialize();
        Product product = (Product)this.getWizard().getContext().get(Product.class);
        String ilSysProp = product.getUid() + "." + "installation.location";
        String il = System.getProperty(ilSysProp);
        String ilSysPropDisabled = ilSysProp + ".initialization.disabled";
        if (il != null && !Boolean.getBoolean(ilSysPropDisabled)) {
            LogManager.log("... try to use installation location for " + product.getDisplayName() + " from system property " + ilSysProp + " : " + il);
            product.setInstallationLocation(new File(il));
            System.setProperty(ilSysPropDisabled, Boolean.toString(true));
        }
        if ((destination = product.getProperty("installation.location")) == null) {
            destination = DEFAULT_DESTINATION;
        }
        destination = this.resolvePath(destination).getAbsolutePath();
        try {
            if (SystemUtils.isMacOS() && (product.getLogic().wrapForMacOs() || product.getLogic().requireDotAppForMacOs()) && !destination.endsWith(APP_SUFFIX)) {
                File parent = new File(destination).getParentFile();
                String suffix = product.getDisplayName() + APP_SUFFIX;
                destination = parent != null ? new File(parent, suffix).getAbsolutePath() : new File(destination, suffix).getAbsolutePath();
            }
        }
        catch (InitializationException e) {
            ErrorManager.notifyError(this.getProperty(ERROR_CANNOT_GET_LOGIC_PROPERTY), e);
        }
        this.getWizard().setProperty("installation.location", destination);
    }

    public static class DestinationPanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        protected DestinationPanel component;
        private NbiLabel destinationLabel;
        private NbiTextField destinationField;
        private NbiButton destinationButton;
        private NbiPanel spacerPanel;
        private NbiDirectoryChooser fileChooser;

        public DestinationPanelSwingUi(DestinationPanel component, SwingContainer container) {
            super(component, container);
            this.component = component;
            this.initComponents();
        }

        public JComponent getDefaultFocusOwner() {
            return this.destinationField;
        }

        protected void initialize() {
            this.destinationLabel.setText(this.component.getProperty(DestinationPanel.DESTINATION_LABEL_TEXT_PROPERTY));
            this.destinationButton.setText(this.component.getProperty(DestinationPanel.DESTINATION_BUTTON_TEXT_PROPERTY));
            String destination = this.component.getWizard().getProperty("installation.location");
            this.destinationField.setText(destination);
            super.initialize();
        }

        protected void saveInput() {
            try {
                String value = this.destinationField.getText().trim();
                value = FileUtils.eliminateRelativity(value).getCanonicalPath();
                this.component.getWizard().setProperty("installation.location", value);
            }
            catch (IOException e) {
                ErrorManager.notifyError(this.component.getProperty(DestinationPanel.ERROR_CANNOT_CANONIZE_PROPERTY), e);
            }
        }

        protected NbiTextField getDestinationField() {
            return this.destinationField;
        }

        protected String validateInput() {
            String string = this.destinationField.getText().trim();
            Product product = (Product)this.component.getWizard().getContext().get(Product.class);
            try {
                if (string.equals("")) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NULL_PROPERTY), string);
                }
                File file = FileUtils.eliminateRelativity(string);
                String filePath = file.getAbsolutePath();
                if (filePath.length() > 45) {
                    filePath = filePath.substring(0, 45) + "...";
                }
                if (!SystemUtils.isPathValid(file.getAbsolutePath())) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_VALID_PROPERTY), filePath);
                }
                String[] prohibitedParts = product.getLogic().getProhibitedInstallationPathParts();
                if (prohibitedParts != null) {
                    for (String s : prohibitedParts) {
                        if (s == null || s.length() <= 0) continue;
                        String prop = null;
                        if (s.length() == 1) {
                            if (file.getAbsolutePath().contains(s)) {
                                prop = s.equals("!") ? DestinationPanel.ERROR_CONTAINS_EXCLAMATION_PROPERTY : (s.equals(";") ? DestinationPanel.ERROR_CONTAINS_SEMICOLON_PROPERTY : (s.equals(":") ? DestinationPanel.ERROR_CONTAINS_COLON_PROPERTY : (s.equals("&") ? DestinationPanel.ERROR_CONTAINS_AMPERSAND_PROPERTY : DestinationPanel.ERROR_CONTAINS_WRONG_CHAR_PROPERTY)));
                            }
                        } else if (file.getAbsolutePath().matches(s)) {
                            prop = DestinationPanel.ERROR_MATCHES_PROHIBITED_REGEXP;
                        }
                        if (prop == null) continue;
                        return StringUtils.format(this.component.getProperty(prop), filePath, s);
                    }
                }
                if (!file.equals(file.getAbsoluteFile())) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_ABSOLUTE_PROPERTY), file.getPath());
                }
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException e) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_CANNOT_CANONIZE_PROPERTY), filePath);
                }
                filePath = file.getAbsolutePath();
                if (filePath.length() > 45) {
                    filePath = filePath.substring(0, 45) + "...";
                }
                if (file.exists() && !file.isDirectory()) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_DIRECTORY_PROPERTY), filePath);
                }
                if (!FileUtils.canRead(file)) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_READABLE_PROPERTY), filePath);
                }
                if (!FileUtils.canWrite(file)) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_WRITABLE_PROPERTY), filePath);
                }
                if (!FileUtils.isEmpty(file)) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_EMPTY_PROPERTY), filePath);
                }
                if (SystemUtils.isMacOS() && (product.getLogic().wrapForMacOs() || product.getLogic().requireDotAppForMacOs()) && !file.getAbsolutePath().endsWith(DestinationPanel.APP_SUFFIX)) {
                    return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_ENDS_WITH_APP_PROPERTY), filePath);
                }
                if (!Boolean.getBoolean("no.space.check")) {
                    long requiredSize = product.getRequiredDiskSpace() + 0xA00000L;
                    long availableSize = SystemUtils.getFreeSpace(file);
                    if (availableSize < requiredSize) {
                        return StringUtils.format(this.component.getProperty(DestinationPanel.ERROR_NOT_ENOUGH_SPACE_PROPERTY), filePath, StringUtils.formatSize(requiredSize - availableSize));
                    }
                }
            }
            catch (InitializationException e) {
                ErrorManager.notifyError(this.component.getProperty(DestinationPanel.ERROR_CANNOT_GET_LOGIC_PROPERTY), e);
            }
            catch (NativeException e) {
                ErrorManager.notifyError(this.component.getProperty(DestinationPanel.ERROR_CANNOT_CHECK_SPACE_PROPERTY), e);
            }
            return null;
        }

        private void initComponents() {
            this.destinationField = new NbiTextField();
            this.destinationField.getDocument().addDocumentListener(new DocumentListener(){

                public void changedUpdate(DocumentEvent e) {
                    DestinationPanelSwingUi.this.updateErrorMessage();
                }

                public void insertUpdate(DocumentEvent e) {
                    DestinationPanelSwingUi.this.updateErrorMessage();
                }

                public void removeUpdate(DocumentEvent e) {
                    DestinationPanelSwingUi.this.updateErrorMessage();
                }
            });
            this.destinationLabel = new NbiLabel();
            this.destinationLabel.setLabelFor(this.destinationField);
            this.destinationButton = new NbiButton();
            this.destinationButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    DestinationPanelSwingUi.this.browseButtonPressed();
                }
            });
            this.fileChooser = new NbiDirectoryChooser();
            this.spacerPanel = new NbiPanel();
            this.add((Component)this.destinationLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 21, 2, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.destinationField, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 21, 2, new Insets(4, 11, 0, 0), 0, 0));
            this.add((Component)this.destinationButton, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 4, 0, 11), 0, 0));
            this.add((Component)this.spacerPanel, new GridBagConstraints(1, 50, 2, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }

        private void browseButtonPressed() {
            Product product = (Product)this.component.getWizard().getContext().get(Product.class);
            File currentDestination = new File(this.destinationField.getText());
            this.fileChooser.setSelectedFile(currentDestination);
            if (this.fileChooser.showOpenDialog(this) == 0) {
                String newDestination = this.fileChooser.getSelectedFile().getAbsolutePath();
                try {
                    String suffix = currentDestination.getName();
                    if (SystemUtils.isMacOS() && (product.getLogic().wrapForMacOs() || product.getLogic().requireDotAppForMacOs()) && !newDestination.endsWith(DestinationPanel.APP_SUFFIX) && !suffix.endsWith(DestinationPanel.APP_SUFFIX)) {
                        suffix = suffix + DestinationPanel.APP_SUFFIX;
                    }
                    if (!new File(newDestination).equals(currentDestination)) {
                        newDestination = new File(newDestination, suffix).getAbsolutePath();
                    }
                }
                catch (InitializationException e) {
                    ErrorManager.notifyError(this.component.getProperty(DestinationPanel.ERROR_CANNOT_GET_LOGIC_PROPERTY), e);
                }
                this.destinationField.setText(newDestination);
            }
        }
    }

    public static class DestinationPanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        protected DestinationPanel component;

        public DestinationPanelUi(DestinationPanel component) {
            super(component);
            this.component = component;
        }

        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new DestinationPanelSwingUi(this.component, container);
            }
            return super.getSwingUi(container);
        }
    }
}

