/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.webmvc.editor.AddBeanPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class AddBeanPanelVisual
extends JPanel {
    private Dialog dialog = null;
    private DialogDescriptor descriptor = null;
    private NotificationLineSupport statusLine;
    private boolean dialogOK = false;
    private AddBeanPanel panel;
    private FileObject fileObject;
    private JTextField classNameTextField;
    private JTextField idTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;

    public AddBeanPanelVisual(AddBeanPanel addBeanPanel) {
        this.panel = addBeanPanel;
        this.fileObject = NbEditorUtilities.getFileObject((Document)addBeanPanel.getDocument());
        this.initComponents();
        this.idTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }
        });
        this.classNameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                AddBeanPanelVisual.this.validateInput();
            }
        });
    }

    public boolean showDialog() {
        String string = this.panel.getId();
        String string2 = this.panel.getClassName();
        if (string2 != null) {
            this.classNameTextField.setEditable(false);
        } else {
            string2 = "";
        }
        this.idTextField.setText(string);
        this.classNameTextField.setText(string2);
        String string3 = "";
        try {
            string3 = NbBundle.getMessage(AddBeanPanelVisual.class, (String)"TTL_Add_Bean_Panel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.descriptor = new DialogDescriptor((Object)this, string3, true, 2, DialogDescriptor.OK_OPTION, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AddBeanPanelVisual.this.descriptor.getValue().equals(DialogDescriptor.OK_OPTION)) {
                    AddBeanPanelVisual.this.collectInput();
                    AddBeanPanelVisual.this.dialogOK = true;
                }
                AddBeanPanelVisual.this.dialog.dispose();
            }
        });
        this.statusLine = this.descriptor.createNotificationLineSupport();
        this.validateInput();
        this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor);
        this.dialog.setVisible(true);
        this.repaint();
        return this.dialogOK;
    }

    private void collectInput() {
        this.panel.setClassName(this.classNameTextField.getText());
        this.panel.setId(this.idTextField.getText());
    }

    private void validateInput() {
        if (this.descriptor == null) {
            return;
        }
        if (this.idTextField.getText().length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Empty_ID"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.idExist()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_not_uniq_ID"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.classNameTextField.getText().length() < 1) {
            this.statusLine.setInformationMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Empty_Class"));
            this.descriptor.setValid(false);
            return;
        }
        if (!this.validClass()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_No_Such_class"));
            this.descriptor.setValid(false);
            return;
        }
        if (this.beanExist()) {
            this.statusLine.setErrorMessage(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"Error_Bean_Already_exist"));
            this.descriptor.setValid(false);
            return;
        }
        this.statusLine.clearMessages();
        this.descriptor.setValid(true);
    }

    private boolean idExist() {
        SpringScope springScope = SpringScope.getSpringScope((FileObject)this.fileObject);
        final String string = this.idTextField.getText();
        final boolean[] blArray = new boolean[]{false};
        for (SpringConfigModel springConfigModel : springScope.getAllConfigModels()) {
            try {
                springConfigModel.runReadAction((Action)new Action<SpringBeans>(){

                    public void run(SpringBeans springBeans) {
                        SpringBean springBean = springBeans.findBean(string);
                        if (springBean != null) {
                            blArray[0] = true;
                        }
                    }
                });
                if (!blArray[0]) continue;
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return blArray[0];
    }

    private boolean beanExist() {
        final boolean[] blArray = new boolean[]{false};
        SpringScope springScope = SpringScope.getSpringScope((FileObject)this.fileObject);
        final String string = this.classNameTextField.getText();
        if (string == null || "".equals(string)) {
            return false;
        }
        for (SpringConfigModel springConfigModel : springScope.getAllConfigModels()) {
            try {
                springConfigModel.runReadAction((Action)new Action<SpringBeans>(){

                    public void run(SpringBeans springBeans) {
                        for (SpringBean springBean : springBeans.getBeans()) {
                            if (!string.equals(springBean.getClassName())) continue;
                            blArray[0] = true;
                            break;
                        }
                    }
                });
                if (!blArray[0]) continue;
                return true;
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return blArray[0];
    }

    private boolean validClass() {
        final boolean[] blArray = new boolean[]{false};
        final String string = this.classNameTextField.getText();
        JavaSource javaSource = JavaSource.create((ClasspathInfo)ClasspathInfo.create((FileObject)this.fileObject), (FileObject[])new FileObject[0]);
        if (javaSource == null) {
            return blArray[0];
        }
        try {
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    blArray[0] = compilationController.getElements().getTypeElement(string) != null;
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return blArray[0];
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.idTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.classNameTextField = new JTextField();
        this.setPreferredSize(new Dimension(420, 120));
        this.setRequestFocusEnabled(false);
        this.setLayout(new GridBagLayout());
        this.jLabel1.setLabelFor(this.idTextField);
        this.jLabel1.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.jLabel1.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.idTextField.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.idTextField.text"));
        this.idTextField.setMinimumSize(new Dimension(200, 27));
        this.idTextField.setPreferredSize(new Dimension(450, 27));
        this.idTextField.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.idTextField, gridBagConstraints);
        this.jLabel2.setLabelFor(this.classNameTextField);
        this.jLabel2.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.jLabel2.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.classNameTextField.setText(NbBundle.getMessage(AddBeanPanelVisual.class, (String)"AddBeanPanelVisual.classNameTextField.text"));
        this.classNameTextField.setPreferredSize(new Dimension(450, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 12, 0, 12);
        this.add((Component)this.classNameTextField, gridBagConstraints);
    }
}

