/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.editing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.Formatter;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.indent.api.IndentUtils;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsPretty;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.javascript.editing.lexer.LexUtilities;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.Exceptions;

public class JsFormatter
implements Formatter {
    private boolean embeddedJavaScript;
    private int embeddededIndent = 0;
    private int indentSize;
    private int continuationIndentSize;
    private Stack<StackItem> stack = new Stack();

    public boolean needsParserResult() {
        return true;
    }

    public void reformat(Context context, ParserResult parserResult) {
        this.continuationIndentSize = this.indentSize = IndentUtils.indentLevelSize((Document)context.document());
        JsParseResult jsParseResult = null;
        if (parserResult != null) {
            jsParseResult = AstUtilities.getParseResult((Parser.Result)parserResult);
        }
        Document document = context.document();
        if (jsParseResult == null || jsParseResult.getRootNode() == null || !JsUtils.isJsOrJsonDocument(document)) {
            this.reindent(context, false);
            return;
        }
        final BaseDocument baseDocument = (BaseDocument)document;
        int n = context.startOffset();
        int n2 = context.endOffset();
        final JsPretty jsPretty = new JsPretty(jsParseResult, baseDocument, n, n2, this.indentSize, this.continuationIndentSize);
        jsPretty.format();
        baseDocument.runAtomic(new Runnable(){

            @Override
            public void run() {
                try {
                    ArrayList<JsPretty.Diff> arrayList = jsPretty.getReverseDiffs();
                    Collections.sort(arrayList);
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        String string;
                        JsPretty.Diff diff = arrayList.get(i);
                        if (diff.text != null && diff.text.length() == diff.end - diff.start && diff.end > diff.start && (string = baseDocument.getText(diff.start, diff.end - diff.start)).equals(diff.text)) continue;
                        if (diff.end > diff.start) {
                            baseDocument.remove(diff.start, diff.end - diff.start);
                        }
                        if (diff.text == null || diff.text.length() <= 0) continue;
                        baseDocument.insertString(diff.start, diff.text, null);
                    }
                }
                catch (BadLocationException badLocationException) {
                    Exceptions.printStackTrace((Throwable)badLocationException);
                }
            }
        });
    }

    public void reindent(Context context) {
        this.continuationIndentSize = this.indentSize = IndentUtils.indentLevelSize((Document)context.document());
        this.reindent(context, true);
    }

    public int indentSize() {
        return -1;
    }

    public int hangingIndentSize() {
        return -1;
    }

    private int getFormatStableStart(BaseDocument baseDocument, int n) {
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n);
        if (tokenSequence == null) {
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.movePrevious()) {
            return 0;
        }
        do {
            Token token;
            TokenId tokenId;
            if ((tokenId = (token = tokenSequence.token()).id()) != JsTokenId.FUNCTION) continue;
            return tokenSequence.offset();
        } while (tokenSequence.movePrevious());
        if (this.embeddedJavaScript && !tokenSequence.movePrevious()) {
            int n2 = tokenSequence.offset();
            try {
                int n3 = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n2);
                if (n3 == -1 || n2 > n3) {
                    return Math.min(baseDocument.getLength(), Utilities.getRowEnd((BaseDocument)baseDocument, (int)n2) + 1);
                }
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return tokenSequence.offset();
    }

    private int getBracketBalanceDelta(TokenId tokenId) {
        if (tokenId == JsTokenId.LPAREN || tokenId == JsTokenId.LBRACKET) {
            return 1;
        }
        if (tokenId == JsTokenId.RPAREN || tokenId == JsTokenId.RBRACKET) {
            return -1;
        }
        return 0;
    }

    private int getTokenBalanceDelta(TokenId tokenId, BaseDocument baseDocument, TokenSequence<? extends JsTokenId> tokenSequence, boolean bl) {
        block23: {
            try {
                TokenSequence<? extends JsTokenId> tokenSequence2;
                OffsetRange offsetRange = OffsetRange.NONE;
                if (tokenId == JsTokenId.LBRACKET || tokenId == JsTokenId.LBRACE) {
                    this.stack.push(new StackItem(false, new OffsetRange(tokenSequence.offset(), tokenSequence.offset())));
                    return 1;
                }
                if (tokenId == JsTokenId.CASE || tokenId == JsTokenId.DEFAULT) {
                    int n = tokenSequence.index();
                    LexUtilities.findNextIncluding(tokenSequence, Collections.singletonList(JsTokenId.COLON));
                    Token<? extends JsTokenId> token = LexUtilities.findNextNonWsNonComment(tokenSequence);
                    JsTokenId jsTokenId = (JsTokenId)token.id();
                    if (jsTokenId == JsTokenId.CASE || jsTokenId == JsTokenId.DEFAULT) {
                        return 0;
                    }
                    if (jsTokenId == JsTokenId.RBRACE) {
                        return -1;
                    }
                    LexUtilities.findNextIncluding(tokenSequence, Collections.singletonList(JsTokenId.EOL));
                    LexUtilities.findNextNonWsNonComment(tokenSequence);
                    if (tokenSequence.token().id() == JsTokenId.CASE || tokenSequence.token().id() == JsTokenId.DEFAULT) {
                        return 0;
                    }
                    tokenSequence.moveIndex(n);
                    tokenSequence.moveNext();
                    return 1;
                }
                if (tokenId == JsTokenId.RBRACKET || tokenId == JsTokenId.RBRACE) {
                    StackItem stackItem;
                    int n = -1;
                    StackItem stackItem2 = stackItem = this.stack.empty() ? null : this.stack.pop();
                    if (stackItem != null && stackItem.range.getStart() <= baseDocument.getLength() + 1 && Utilities.getLineOffset((BaseDocument)baseDocument, (int)stackItem.range.getStart()) != Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset())) {
                        int n2 = 0;
                        while (!this.stack.empty() && this.stack.pop().braceless) {
                            ++n2;
                        }
                        n -= n2;
                    }
                    return n;
                }
                offsetRange = LexUtilities.getMultilineRange((Document)baseDocument, tokenSequence);
                if (offsetRange != OffsetRange.NONE) {
                    this.stack.push(new StackItem(true, offsetRange));
                    break block23;
                }
                if (tokenId != JsTokenId.EOL) break block23;
                if (!bl) {
                    Token<? extends JsTokenId> token;
                    JsTokenId jsTokenId;
                    tokenSequence2 = LexUtilities.getPositionedSequence((Document)baseDocument, tokenSequence.offset());
                    Token<? extends JsTokenId> token2 = LexUtilities.findNextNonWsNonComment(tokenSequence2);
                    JsTokenId jsTokenId2 = jsTokenId = token2 == null ? null : (JsTokenId)token2.id();
                    if (jsTokenId == JsTokenId.RBRACE) {
                        token = LexUtilities.findBwd((Document)baseDocument, tokenSequence2, JsTokenId.LBRACE, JsTokenId.RBRACE);
                        if (token != OffsetRange.NONE) {
                            tokenSequence2.movePrevious();
                            if (LexUtilities.skipParenthesis(tokenSequence2, true)) {
                                Token<? extends JsTokenId> token3 = tokenSequence2.token();
                                token3 = LexUtilities.findPreviousNonWsNonComment(tokenSequence2);
                                if (token3.id() == JsTokenId.SWITCH) {
                                    return -1;
                                }
                            }
                        }
                    } else if ((jsTokenId == JsTokenId.CASE || jsTokenId == JsTokenId.DEFAULT) && (token = LexUtilities.findPreviousNonWsNonComment(tokenSequence2 = LexUtilities.getPositionedSequence((Document)baseDocument, tokenSequence.offset()))).id() != JsTokenId.LBRACE) {
                        int n;
                        tokenSequence2 = LexUtilities.getPositionedSequence((Document)baseDocument, tokenSequence.offset());
                        token = LexUtilities.findPreviousIncluding(tokenSequence2, Arrays.asList(JsTokenId.CASE, JsTokenId.DEFAULT));
                        int n3 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence2.offset());
                        if (n3 != (n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset()))) {
                            return -1;
                        }
                    }
                }
                if (this.stack.empty() || !this.stack.peek().braceless) break block23;
                tokenSequence2 = this.stack.peek().range;
                if (tokenSequence2.containsInclusive(tokenSequence.offset())) {
                    int n;
                    if (bl) {
                        return 1;
                    }
                    int n4 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence2.getEnd());
                    if (n4 == (n = Utilities.getLineOffset((BaseDocument)baseDocument, (int)tokenSequence.offset()))) {
                        return 1;
                    }
                    break block23;
                }
                int n = 0;
                while (!this.stack.empty() && this.stack.peek().braceless) {
                    ++n;
                    this.stack.pop();
                }
                return -n;
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
        }
        return 0;
    }

    private int getTokenBalance(TokenSequence<? extends JsTokenId> tokenSequence, BaseDocument baseDocument, int n, int n2, boolean bl, boolean bl2) {
        TokenSequence<? extends JsTokenId> tokenSequence2;
        int n3 = 0;
        if (tokenSequence == null) {
            try {
                this.embeddededIndent = Utilities.getRowIndent((BaseDocument)baseDocument, (int)n);
            }
            catch (BadLocationException badLocationException) {
                Exceptions.printStackTrace((Throwable)badLocationException);
            }
            return 0;
        }
        tokenSequence.move(n);
        if (!tokenSequence.moveNext()) {
            return 0;
        }
        int n4 = n;
        while ((tokenSequence2 = tokenSequence.token()) != null) {
            TokenId tokenId = tokenSequence2.id();
            if (bl) {
                int n5 = this.getTokenBalanceDelta(tokenId, baseDocument, tokenSequence, bl2);
                n3 += n5;
            } else {
                n3 += this.getBracketBalanceDelta(tokenId);
            }
            n4 = tokenSequence.offset() + tokenSequence2.length();
            if (tokenSequence.moveNext() && tokenSequence.offset() < n2) continue;
        }
        if (this.embeddedJavaScript && n4 < n2 && (tokenSequence2 = LexUtilities.getNextJsTokenSequence((Document)baseDocument, n4 + 1, n2)) != null && tokenSequence2.offset() > n) {
            return n3 + this.getTokenBalance(tokenSequence2, baseDocument, tokenSequence2.offset(), n2, bl, bl2);
        }
        return n3;
    }

    private Token<? extends JsTokenId> getFirstToken(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            if (this.embeddedJavaScript) {
                TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getJsTokenSequence((Document)baseDocument, n2);
                if (tokenSequence != null) {
                    tokenSequence.moveNext();
                    Token token = tokenSequence.token();
                    while (token != null && token.id() == JsTokenId.WHITESPACE) {
                        if (!tokenSequence.moveNext()) {
                            return null;
                        }
                        token = tokenSequence.token();
                    }
                    return token;
                }
            } else {
                return LexUtilities.getToken((Document)baseDocument, n2);
            }
        }
        return null;
    }

    private int isEndIndent(BaseDocument baseDocument, int n) throws BadLocationException {
        int n2 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n);
        if (n2 != -1) {
            Token<? extends JsTokenId> token = this.getFirstToken(baseDocument, n);
            if (token == null) {
                return 0;
            }
            TokenId tokenId = token.id();
            if (tokenId == JsTokenId.RBRACE || tokenId == JsTokenId.RBRACKET || tokenId == JsTokenId.RPAREN) {
                int n3 = 1;
                int n4 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n);
                int n5 = n;
                while (n5 < n4 && token != null && ((n5 += token.length()) >= baseDocument.getLength() || (token = LexUtilities.getToken((Document)baseDocument, n5)) == null || (tokenId = token.id()) == JsTokenId.WHITESPACE)) {
                }
                return n3;
            }
        }
        return 0;
    }

    private static boolean isLineContinued(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        Token token;
        if ((n = Utilities.getRowLastNonWhite((BaseDocument)baseDocument, (int)n)) == -1) {
            return false;
        }
        TokenSequence<? extends JsTokenId> tokenSequence = LexUtilities.getPositionedSequence((Document)baseDocument, n);
        Token token2 = token = tokenSequence != null ? tokenSequence.token() : null;
        if (token != null) {
            boolean bl;
            TokenId tokenId = token.id();
            boolean bl2 = bl = tokenId == JsTokenId.NONUNARY_OP || tokenId == JsTokenId.DOT;
            if (tokenSequence.offset() == n && token.length() > 1 && ((Object)token.text()).toString().startsWith("\\")) {
                bl = true;
            }
            if (tokenId == JsTokenId.NONUNARY_OP && ",".equals(((Object)token.text()).toString())) {
                boolean bl3 = bl = n2 == 0;
            }
            if (tokenId == JsTokenId.COLON) {
                TokenSequence<? extends JsTokenId> tokenSequence2 = LexUtilities.getPositionedSequence((Document)baseDocument, tokenSequence.offset());
                Token<? extends JsTokenId> token3 = LexUtilities.findPreviousIncluding(tokenSequence2, Arrays.asList(JsTokenId.CASE, JsTokenId.DEFAULT, JsTokenId.COLON));
                bl = token3 == null || token3.id() != JsTokenId.CASE && token3.id() != JsTokenId.DEFAULT;
            }
            return bl;
        }
        return false;
    }

    private void reindent(final Context context, final boolean bl) {
        Document document = context.document();
        int n = context.startOffset();
        int n2 = context.endOffset();
        this.embeddedJavaScript = !JsUtils.isJsOrJsonDocument(document);
        try {
            Token<? extends JsTokenId> token;
            final BaseDocument baseDocument = (BaseDocument)document;
            if (bl && this.embeddedJavaScript && (token = LexUtilities.getToken((Document)baseDocument, n)) == null) {
                return;
            }
            if (n2 > baseDocument.getLength()) {
                n2 = baseDocument.getLength();
            }
            final int n3 = n = Utilities.getRowStart((BaseDocument)baseDocument, (int)n);
            int n4 = 0;
            int n5 = 0;
            if (n > 0) {
                int n6 = Utilities.getRowStart((BaseDocument)baseDocument, (int)(n - 1));
                n4 = this.getFormatStableStart(baseDocument, n6);
                n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n4);
            }
            final ArrayList<Integer> arrayList = new ArrayList<Integer>();
            final ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            boolean bl2 = n != 0 || n2 != baseDocument.getLength();
            boolean bl3 = n2 == baseDocument.getLength() || bl;
            this.computeIndents(baseDocument, n5, n4, n2, arrayList, arrayList2, bl2, bl3, bl);
            baseDocument.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        assert (arrayList2.size() == arrayList.size());
                        for (int i = arrayList2.size() - 1; i >= 0; --i) {
                            int n = (Integer)arrayList2.get(i);
                            int n2 = (Integer)arrayList.get(i);
                            if (n2 >= n3) {
                                int n32;
                                if (n2 == n3 && i > 0) {
                                    n32 = (Integer)arrayList.get(i - 1);
                                    int n4 = (Integer)arrayList2.get(i - 1);
                                    int n5 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n32);
                                    if (n5 != n4 && (bl || !Utilities.isRowEmpty((BaseDocument)baseDocument, (int)n32) && !Utilities.isRowWhite((BaseDocument)baseDocument, (int)n32))) {
                                        n = n5 + (n - n4);
                                    }
                                }
                                if ((n32 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n2)) == n || n < 0) continue;
                                context.modifyIndent(n2, n);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        Exceptions.printStackTrace((Throwable)badLocationException);
                    }
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    public void computeIndents(BaseDocument baseDocument, int n, int n2, int n3, List<Integer> list, List<Integer> list2, boolean bl, boolean bl2, boolean bl3) {
        try {
            int n4 = Utilities.getRowStart((BaseDocument)baseDocument, (int)n2);
            int n5 = n3;
            int n6 = 0;
            int n7 = 0;
            boolean bl4 = false;
            int n8 = 0;
            while (!bl2 && n4 < n5 || bl2 && n4 <= n5) {
                int n9;
                int n10;
                int n11;
                if (this.embeddedJavaScript) {
                    n = this.embeddededIndent + this.indentSize;
                }
                int n12 = 0;
                int n13 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4);
                TokenSequence<? extends JsTokenId> tokenSequence = null;
                if (n13 != -1) {
                    tokenSequence = LexUtilities.getPositionedSequence((Document)baseDocument, n13, false);
                    if (tokenSequence != null) {
                        TokenId tokenId = tokenSequence.token().id();
                        if (tokenId == JsTokenId.BLOCK_COMMENT) {
                            n12 = tokenSequence.offset() == n13 ? 2 : 3;
                        } else if (tokenId == JsTokenId.NONUNARY_OP) {
                            bl4 = true;
                        } else if (tokenId == JsTokenId.STRING_LITERAL || tokenId == JsTokenId.STRING_END || tokenId == JsTokenId.REGEXP_LITERAL || tokenId == JsTokenId.REGEXP_END) {
                            n12 = 1;
                        }
                    } else {
                        n12 = 1;
                    }
                }
                int n14 = n11 = bl4 ? this.continuationIndentSize : 0;
                if (n12 == 1) {
                    n10 = GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n4);
                } else if (n12 == 3) {
                    n10 = baseDocument.getText(n13, 1).charAt(0) == '*' ? n8 + 1 : GsfUtilities.getLineIndent((BaseDocument)baseDocument, (int)n4);
                } else {
                    int n15 = this.isEndIndent(baseDocument, n4);
                    if (n15 > 0) {
                        n10 = (n6 - n15) * this.indentSize + n11 + n;
                    } else {
                        assert (n12 == 0 || n12 == 2);
                        n10 = n6 * this.indentSize + n11 + n;
                        if (n12 == 2) {
                            n8 = n10;
                        }
                    }
                }
                if (n10 < 0) {
                    n10 = 0;
                }
                if ((n9 = Utilities.getRowFirstNonWhite((BaseDocument)baseDocument, (int)n4)) != -1 || bl) {
                    list2.add(n10);
                    list.add(n4);
                }
                int n16 = Utilities.getRowEnd((BaseDocument)baseDocument, (int)n4) + 1;
                if (n9 != -1) {
                    n6 += this.getTokenBalance(tokenSequence, baseDocument, n9, n16, true, bl3);
                    int n17 = this.getTokenBalance(tokenSequence, baseDocument, n9, n16, false, bl3);
                    bl4 = JsFormatter.isLineContinued(baseDocument, n4, n7 += n17);
                }
                n4 = n16;
            }
        }
        catch (BadLocationException badLocationException) {
            Exceptions.printStackTrace((Throwable)badLocationException);
        }
    }

    private static final class StackItem {
        private final boolean braceless;
        private final OffsetRange range;

        private StackItem(boolean bl, OffsetRange offsetRange) {
            this.braceless = bl;
            this.range = offsetRange;
        }

        public String toString() {
            return "StackItem[" + this.braceless + "," + this.range + "]";
        }
    }
}

