/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.util.UIUtilities;
import org.netbeans.modules.dlight.util.ui.DLightUIPrefs;
import org.openide.util.NbBundle;

public class RepairPanel
extends JPanel {
    private static final int MARGIN = 2;
    private final JEditorPane label;
    private JButton button;
    private List<Action> actions;

    public RepairPanel(ValidationStatus status) {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalGlue());
        String text = status.isKnown() ? status.getReason() : RepairPanel.getMessage("RepairPanel.Label.Text", new Object[0]);
        String buttonText = RepairPanel.getMessage("RepairPanel.Repair.Text", new Object[0]);
        this.label = UIUtilities.createJEditorPane((String)text, (boolean)false, (Color)DLightUIPrefs.getColor((String)"indicator.legend.font.color"));
        if (!status.isKnown()) {
            this.label.setToolTipText(RepairPanel.getMessage("RepairPanel.Label.Tooltip", buttonText));
        } else {
            this.label.setToolTipText(text);
        }
        Dimension d = this.label.getPreferredSize();
        this.label.setMaximumSize(new Dimension(d.width + 2, d.height));
        this.add(this.label);
        this.add(Box.createVerticalStrut(2));
        if (!status.isKnown()) {
            this.button = new JButton(buttonText);
            this.button.setAlignmentX(0.5f);
            this.add(this.button);
        }
        this.add(Box.createVerticalGlue());
        this.addMouseListener(new PopupMenuListener());
    }

    private JPopupMenu createPopupMenu() {
        if (this.actions == null || this.actions.isEmpty()) {
            return null;
        }
        JPopupMenu pm = new JPopupMenu();
        for (Action action : this.actions) {
            pm.add(new JMenuItem(action));
        }
        return pm;
    }

    public void setPopupActions(List<Action> actions) {
        this.actions = actions;
    }

    public void addActionListener(ActionListener listener) {
        if (this.button != null) {
            this.button.addActionListener(listener);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.button != null) {
            this.button.setEnabled(enabled);
        }
        this.repaint();
    }

    private static String getMessage(String name, Object ... args) {
        return NbBundle.getMessage(RepairPanel.class, (String)name, (Object[])args);
    }

    private class PopupMenuListener
    extends MouseAdapter
    implements MouseListener {
        PopupMenuListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybePopup(e);
        }

        private void maybePopup(MouseEvent e) {
            JPopupMenu pm;
            if (e.isPopupTrigger() && (pm = RepairPanel.this.createPopupMenu()) != null) {
                pm.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

