/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators.graph;

import java.util.ArrayList;
import java.util.Collections;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesPlot;
import org.netbeans.modules.dlight.util.Range;

public final class TimeSeriesDataContainer {
    private final long bucketSize;
    private final Aggregation aggr;
    private final int arraySize;
    private final ArrayList<Bucket> list;
    private final boolean lastNonNull;
    private TimeSeriesPlot plot;

    public TimeSeriesDataContainer(long bucketSize, Aggregation aggr, int arraySize, boolean lastNonNull) {
        if (bucketSize <= 0L) {
            throw new IllegalArgumentException("bucketSize must be positive");
        }
        if (aggr == null) {
            throw new NullPointerException("aggregation can't be null");
        }
        if (arraySize <= 0) {
            throw new IllegalArgumentException("arraySize must be positive");
        }
        this.bucketSize = bucketSize;
        this.aggr = aggr;
        this.arraySize = arraySize;
        this.list = new ArrayList();
        this.lastNonNull = lastNonNull;
    }

    public synchronized void put(long timestamp, float[] newData) {
        if (timestamp < 0L) {
            throw new IllegalArgumentException("timestamp can't be negative");
        }
        if (newData.length != this.arraySize) {
            throw new IllegalArgumentException("Wrong data size");
        }
        int bucketId = (int)Math.ceil((double)timestamp / (double)this.bucketSize);
        this.grow(bucketId + 1);
        Bucket bucket = this.list.get(bucketId);
        if (bucket == null) {
            bucket = new Bucket(this.aggr, newData);
            this.list.set(bucketId, bucket);
        } else {
            bucket.put(newData);
        }
        if (this.plot != null) {
            int oldLimit;
            int newLimit = this.plot.calculateUpperLimit(bucket.get());
            for (oldLimit = this.plot.getUpperLimit(); oldLimit < newLimit; oldLimit *= 2) {
            }
            this.plot.setUpperLimit(oldLimit);
        }
    }

    public synchronized float[] get(int bucketId) {
        if (0 <= bucketId && bucketId < this.list.size()) {
            Bucket bucket = this.list.get(bucketId);
            if (bucket == null) {
                if (this.lastNonNull) {
                    for (int i = bucketId - 1; 0 <= i; --i) {
                        Bucket prevBucket = this.list.get(i);
                        if (prevBucket == null) continue;
                        return prevBucket.get();
                    }
                }
                return new float[this.arraySize];
            }
            return bucket.get();
        }
        throw new IllegalArgumentException("No such bucket");
    }

    public synchronized void grow(int size) {
        if (this.list.size() < size) {
            this.list.ensureCapacity(size);
            this.list.addAll(Collections.nCopies(size - this.list.size(), null));
            if (this.plot != null) {
                this.plot.getViewportModel().setLimits(new Range((Number)0L, (Number)(1000000000L * (long)size)));
            }
        }
    }

    public int size() {
        return this.list.size();
    }

    public void setTimeSeriesPlot(TimeSeriesPlot plot) {
        this.plot = plot;
    }

    private static class Bucket {
        private final Aggregation aggr;
        private float[] data;
        private int count;

        public Bucket(Aggregation aggr, float[] data) {
            this.aggr = aggr;
            this.data = data;
            this.count = 1;
        }

        public void put(float[] data) {
            switch (this.aggr) {
                case FIRST: {
                    break;
                }
                case LAST: {
                    this.data = data;
                    break;
                }
                case SUM: {
                    for (int i = 0; i < data.length; ++i) {
                        int n = i;
                        this.data[n] = this.data[n] + data[i];
                    }
                    break;
                }
                case AVERAGE: {
                    for (int i = 0; i < data.length; ++i) {
                        this.data[i] = ((float)this.count * this.data[i] + data[i]) / (float)(++this.count);
                    }
                    break;
                }
            }
        }

        public float[] get() {
            return this.data;
        }
    }
}

