/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.ValidationException;
import org.netbeans.modules.j2ee.deployment.config.J2eeModuleAccessor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.impl.ServerInstance;
import org.netbeans.modules.j2ee.deployment.impl.ServerRegistry;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.ConfigBean;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.NetbeansDeployment;
import org.netbeans.modules.j2ee.deployment.impl.gen.nbd.WebContextRoot;
import org.netbeans.modules.j2ee.deployment.impl.ui.RegistryNodeProvider;
import org.netbeans.modules.j2ee.deployment.plugins.spi.J2eePlatformFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.OptionalDeploymentManagerFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.RegistryNodeFactory;
import org.netbeans.modules.j2ee.deployment.plugins.spi.VerifierSupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfigurationFactory;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.xml.sax.SAXException;

public class Server
implements Node.Cookie {
    private static final Logger LOGGER = Logger.getLogger(Server.class.getName());
    private static final String ATTR_NEEDS_FIND_SERVER_UI = "needsFindServerUI";
    private final NetbeansDeployment dep;
    private final Class factoryCls;
    private final String name;
    private final Lookup lkp;
    private final boolean needsFindServerUI;
    private DeploymentFactory factory = null;
    private DeploymentManager manager = null;
    private RegistryNodeProvider nodeProvider = null;
    private static final String LAYER_DEPLOYMENT_FILE_NAMES = "DeploymentFileNames";
    private Map deployConfigDescriptorMap;

    public Server(FileObject fileObject) throws IOException, ParserConfigurationException, SAXException, ClassNotFoundException {
        this.initDeploymentConfigurationFileList(fileObject);
        this.name = fileObject.getName();
        FileObject fileObject2 = fileObject.getFileObject("Descriptor");
        if (fileObject2 == null) {
            String string = NbBundle.getMessage(Server.class, (String)"MSG_InvalidServerPlugin", (Object)fileObject.toString());
            throw new IllegalStateException(string);
        }
        this.needsFindServerUI = Server.getBooleanValue(fileObject2.getAttribute(ATTR_NEEDS_FIND_SERVER_UI), false);
        this.dep = NetbeansDeployment.createGraph(fileObject2.getInputStream());
        this.lkp = Lookups.forPath((String)fileObject.getPath());
        this.factory = (DeploymentFactory)this.lkp.lookup(DeploymentFactory.class);
        if (this.factory != null) {
            this.factoryCls = this.factory.getClass();
        } else {
            FileObject fileObject3 = fileObject.getFileObject("Factory.instance");
            if (fileObject3 == null) {
                String string = NbBundle.getMessage(Server.class, (String)"MSG_NoFactoryInstanceClass", (Object)this.name);
                LOGGER.log(Level.SEVERE, string);
                this.factoryCls = null;
                return;
            }
            DataObject dataObject = DataObject.find((FileObject)fileObject3);
            InstanceCookie instanceCookie = (InstanceCookie)dataObject.getCookie(InstanceCookie.class);
            if (instanceCookie == null) {
                String string = NbBundle.getMessage(Server.class, (String)"MSG_FactoryFailed", (Object)this.name);
                LOGGER.log(Level.SEVERE, string);
                this.factoryCls = null;
                return;
            }
            this.factoryCls = instanceCookie.instanceClass();
            try {
                this.factory = (DeploymentFactory)instanceCookie.instanceCreate();
            }
            catch (Exception exception) {
                LOGGER.log(Level.INFO, null, exception);
            }
        }
    }

    private synchronized DeploymentFactory getFactory() {
        if (this.factory == null) {
            DeploymentFactory[] deploymentFactoryArray = DeploymentFactoryManager.getInstance().getDeploymentFactories();
            for (int i = 0; i < deploymentFactoryArray.length; ++i) {
                if (!this.factoryCls.isInstance(deploymentFactoryArray[i])) continue;
                this.factory = deploymentFactoryArray[i];
                break;
            }
        }
        if (this.factory == null) {
            throw new IllegalStateException("Can't acquire DeploymentFactory for " + this.name);
        }
        return this.factory;
    }

    public synchronized DeploymentManager getDisconnectedDeploymentManager() throws DeploymentManagerCreationException {
        if (this.manager == null) {
            this.manager = this.getDisconnectedDeploymentManager(this.dep.getDisconnectedString());
        }
        return this.manager;
    }

    public DeploymentManager getDisconnectedDeploymentManager(String string) throws DeploymentManagerCreationException {
        return this.getFactory().getDisconnectedDeploymentManager(string);
    }

    public boolean handlesUri(String string) {
        try {
            return this.getFactory().handlesURI(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.INFO, null, exception);
            return false;
        }
    }

    public DeploymentManager getDeploymentManager(String string, String string2, String string3) throws DeploymentManagerCreationException {
        return this.getFactory().getDeploymentManager(string, string2, string3);
    }

    public String getDisplayName() {
        return this.getFactory().getDisplayName();
    }

    public String getShortName() {
        return this.name;
    }

    public String getIconBase() {
        return this.dep.getIcon();
    }

    public boolean canDeployEars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isEarDeploy();
    }

    public boolean canDeployWars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isWarDeploy();
    }

    public boolean canDeployEjbJars() {
        return this.dep.getContainerLimitation() == null || this.dep.getContainerLimitation().isEjbjarDeploy();
    }

    public String getHelpId(String string) {
        ConfigBean[] configBeanArray = this.dep.getConfigBean();
        for (int i = 0; i < configBeanArray.length; ++i) {
            if (!configBeanArray[i].getClassName().equals(string)) continue;
            return configBeanArray[i].getHelpid();
        }
        return null;
    }

    public synchronized RegistryNodeProvider getNodeProvider() {
        if (this.nodeProvider != null) {
            return this.nodeProvider;
        }
        RegistryNodeFactory registryNodeFactory = (RegistryNodeFactory)this.lkp.lookup(RegistryNodeFactory.class);
        if (registryNodeFactory == null) {
            String string = NbBundle.getMessage(Server.class, (String)"MSG_NoInstance", (Object)this.name, RegistryNodeFactory.class);
            LOGGER.log(Level.INFO, string);
        }
        this.nodeProvider = new RegistryNodeProvider(registryNodeFactory);
        return this.nodeProvider;
    }

    public RegistryNodeFactory getRegistryNodeFactory() {
        return (RegistryNodeFactory)this.lkp.lookup(RegistryNodeFactory.class);
    }

    public OptionalDeploymentManagerFactory getOptionalFactory() {
        OptionalDeploymentManagerFactory optionalDeploymentManagerFactory = (OptionalDeploymentManagerFactory)this.lkp.lookup(OptionalDeploymentManagerFactory.class);
        return optionalDeploymentManagerFactory;
    }

    public J2eePlatformFactory getJ2eePlatformFactory() {
        J2eePlatformFactory j2eePlatformFactory = (J2eePlatformFactory)this.lkp.lookup(J2eePlatformFactory.class);
        return j2eePlatformFactory;
    }

    public ModuleConfigurationFactory getModuleConfigurationFactory() {
        return (ModuleConfigurationFactory)this.lkp.lookup(ModuleConfigurationFactory.class);
    }

    public VerifierSupport getVerifierSupport() {
        VerifierSupport verifierSupport = (VerifierSupport)this.lkp.lookup(VerifierSupport.class);
        return verifierSupport;
    }

    public boolean canVerify(J2eeModule.Type type) {
        VerifierSupport verifierSupport = this.getVerifierSupport();
        return verifierSupport != null && verifierSupport.supportsModuleType(J2eeModuleAccessor.getDefault().getJsrModuleType(type));
    }

    public void verify(FileObject fileObject, OutputStream outputStream) throws ValidationException {
        this.getVerifierSupport().verify(fileObject, outputStream);
    }

    public ServerInstance[] getInstances() {
        ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
        for (ServerInstance serverInstance : ServerRegistry.getInstance().getInstances()) {
            if (!this.name.equals(serverInstance.getServer().getShortName())) continue;
            arrayList.add(serverInstance);
        }
        return arrayList.toArray(new ServerInstance[arrayList.size()]);
    }

    public WebContextRoot getWebContextRoot() {
        return this.dep.getWebContextRoot();
    }

    public DeploymentFactory getDeploymentFactory() {
        return this.getFactory();
    }

    private static boolean getBooleanValue(Object object, boolean bl) {
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof String) {
            return Boolean.valueOf((String)object);
        }
        return bl;
    }

    public boolean needsFindServerUI() {
        return this.needsFindServerUI;
    }

    public String toString() {
        return this.getShortName();
    }

    public boolean supportsModuleType(J2eeModule.Type type) {
        if (J2eeModule.Type.WAR.equals(type)) {
            return this.canDeployWars();
        }
        if (J2eeModule.Type.EJB.equals(type)) {
            return this.canDeployEjbJars();
        }
        if (J2eeModule.Type.EAR.equals(type)) {
            return this.canDeployEars();
        }
        return true;
    }

    private final void initDeploymentConfigurationFileList(FileObject fileObject) {
        this.deployConfigDescriptorMap = new HashMap();
        FileObject fileObject2 = fileObject.getFileObject(LAYER_DEPLOYMENT_FILE_NAMES);
        if (fileObject2 != null) {
            FileObject[] fileObjectArray = fileObject2.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string = fileObjectArray[i].getName().toUpperCase();
                FileObject[] fileObjectArray2 = fileObjectArray[i].getChildren();
                if (fileObjectArray2 == null || fileObjectArray2.length == 0) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                for (int j = 0; j < fileObjectArray2.length; ++j) {
                    if (fileObjectArray2[j] == null) continue;
                    String string2 = fileObjectArray2[j].getNameExt();
                    arrayList.add(string2.replace('\\', '/'));
                }
                this.deployConfigDescriptorMap.put(string, arrayList.toArray(new String[arrayList.size()]));
            }
        }
    }

    public String[] getDeploymentPlanFiles(J2eeModule.Type type) {
        ModuleType moduleType = J2eeModuleAccessor.getDefault().getJsrModuleType(type);
        return (String[])this.deployConfigDescriptorMap.get(moduleType.toString().toUpperCase());
    }
}

