/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.swing.text.Position;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.plugins.JavaWhereUsedQueryPlugin;
import org.netbeans.modules.refactoring.java.ui.UIUtilities;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGrip;
import org.netbeans.modules.refactoring.java.ui.tree.ElementGripFactory;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;

    public WhereUsedElement(PositionBounds positionBounds, String string, FileObject fileObject, TreePath treePath, CompilationInfo compilationInfo) {
        this.bounds = positionBounds;
        this.displayText = string;
        this.parentFile = fileObject;
        if (treePath != null) {
            ElementGripFactory.getDefault().put(fileObject, treePath, compilationInfo);
        }
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        ElementGrip elementGrip = ElementGripFactory.getDefault().get(this.parentFile, this.bounds.getBegin().getOffset());
        if (elementGrip == null) {
            elementGrip = this.parentFile;
        }
        return Lookups.singleton((Object)elementGrip);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getParentFile() {
        return this.parentFile;
    }

    public static WhereUsedElement create(CompilationInfo compilationInfo, TreePath treePath) {
        Object object;
        Object object2;
        Object object3;
        CompilationUnitTree compilationUnitTree = treePath.getCompilationUnit();
        CharSequence charSequence = compilationInfo.getSnapshot().getText();
        SourcePositions sourcePositions = compilationInfo.getTrees().getSourcePositions();
        Tree tree = treePath.getLeaf();
        boolean bl = false;
        TreeUtilities treeUtilities = compilationInfo.getTreeUtilities();
        if (tree.getKind() == Tree.Kind.IDENTIFIER && "super".contentEquals(((IdentifierTree)tree).getName()) && treeUtilities.isSynthetic(treePath)) {
            if (treeUtilities.isSynthetic(treePath = WhereUsedElement.getEnclosingTree(treePath))) {
                treePath = WhereUsedElement.getEnclosingTree(treePath.getParentPath());
            }
            tree = treePath.getLeaf();
        }
        if (tree.getKind() == Tree.Kind.CLASS) {
            object3 = treeUtilities.findNameSpan((ClassTree)tree);
            if (object3 == null) {
                bl = true;
                object = object2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            } else {
                object = object3[0];
                object2 = object3[1];
            }
        } else if (tree.getKind() == Tree.Kind.METHOD) {
            object3 = treeUtilities.findNameSpan((MethodTree)tree);
            if (object3 == null) {
                object = object2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            } else {
                object = object3[0];
                object2 = object3[1];
            }
        } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
            Object object4;
            object3 = ((NewClassTree)tree).getIdentifier();
            if (object3.getKind() == Tree.Kind.MEMBER_SELECT) {
                object4 = treeUtilities.findNameSpan((MemberSelectTree)object3);
                if (object4 == null) {
                    object = object2 = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)object3);
                } else {
                    object = object4[0];
                    object2 = object4[1];
                }
            } else {
                object4 = treePath.getParentPath();
                Tree tree2 = ((TreePath)object4).getLeaf();
                Trees trees = compilationInfo.getTrees();
                Element element = trees.getElement((TreePath)object4);
                if (tree2.getKind() == Tree.Kind.VARIABLE && element.getKind() == ElementKind.ENUM_CONSTANT) {
                    int[] nArray = treeUtilities.findNameSpan((VariableTree)tree2);
                    if (nArray == null) {
                        object = object2 = (Object)sourcePositions.getStartPosition(compilationUnitTree, tree2);
                    } else {
                        object = nArray[0];
                        object2 = nArray[1];
                    }
                } else {
                    object = (int)sourcePositions.getStartPosition(compilationUnitTree, (Tree)object3);
                    object2 = (int)sourcePositions.getEndPosition(compilationUnitTree, (Tree)object3);
                }
            }
        } else if (tree.getKind() == Tree.Kind.MEMBER_SELECT) {
            object3 = treeUtilities.findNameSpan((MemberSelectTree)tree);
            if (object3 == null) {
                object = object2 = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            } else {
                object = object3[0];
                object2 = object3[1];
            }
        } else {
            object = (int)sourcePositions.getStartPosition(compilationUnitTree, tree);
            object2 = sourcePositions.getEndPosition(compilationUnitTree, tree);
            if (object2 == -1) {
                ErrorManager.getDefault().notify(1, (Throwable)new RuntimeException("Cannot get end position for " + tree.getClass().getName() + " " + tree + " file:" + compilationInfo.getFileObject().getPath()));
                object2 = object;
            }
        }
        assert (object > 0) : "Cannot find start position in file " + compilationUnitTree.getSourceFile().getName() + "\n tree=" + treePath.toString();
        assert (object2 > 0) : "Cannot find end position in file " + compilationUnitTree.getSourceFile().getName() + "\n tree=" + treePath.toString();
        object3 = treePath.getCompilationUnit().getLineMap();
        long l = object3.getLineNumber((long)object);
        long l2 = object3.getLineNumber((long)object2);
        long l3 = object3.getStartPosition(l);
        int n = charSequence.length();
        long l4 = object3.getLineNumber(n);
        long l5 = l4 > l2 ? object3.getStartPosition(l2 + 1L) - 1L : (long)n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RetoucheUtils.getHtml(WhereUsedElement.trimStart(((Object)charSequence.subSequence((int)l3, (int)object)).toString())));
        stringBuffer.append("<b>");
        stringBuffer.append(charSequence.subSequence((int)object, (int)object2));
        stringBuffer.append("</b>");
        stringBuffer.append(RetoucheUtils.getHtml(WhereUsedElement.trimEnd(((Object)charSequence.subSequence((int)object2, (int)l5)).toString())));
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)compilationInfo.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        CloneableEditorSupport cloneableEditorSupport = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dataObject);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(object, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(object2, Position.Bias.Forward);
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        TreePath treePath2 = WhereUsedElement.getEnclosingTree(treePath);
        return new WhereUsedElement(positionBounds, object == object2 && bl ? NbBundle.getMessage(UIUtilities.class, (String)"LBL_AnonymousClass") : stringBuffer.toString().trim(), compilationInfo.getFileObject(), treePath2, compilationInfo);
    }

    private static String trimStart(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(i, string.length());
        }
        return "";
    }

    private static String trimEnd(String string) {
        for (int i = string.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return string.substring(0, i + 1);
        }
        return "";
    }

    public static WhereUsedElement create(int n, int n2, CompilationInfo compilationInfo) {
        CharSequence charSequence = compilationInfo.getSnapshot().getText();
        LineMap lineMap = compilationInfo.getCompilationUnit().getLineMap();
        long l = lineMap.getLineNumber(n);
        long l2 = lineMap.getLineNumber(n2);
        long l3 = lineMap.getStartPosition(l);
        int n3 = charSequence.length();
        long l4 = lineMap.getLineNumber(n3);
        long l5 = l4 > l2 ? lineMap.getStartPosition(l2 + 1L) - 1L : (long)n3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(RetoucheUtils.getHtml(WhereUsedElement.trimStart(((Object)charSequence.subSequence((int)l3, n)).toString())));
        stringBuffer.append("<b>");
        stringBuffer.append(charSequence.subSequence(n, n2));
        stringBuffer.append("</b>");
        stringBuffer.append(RetoucheUtils.getHtml(WhereUsedElement.trimEnd(((Object)charSequence.subSequence(n2, (int)l5)).toString())));
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)compilationInfo.getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
        }
        CloneableEditorSupport cloneableEditorSupport = JavaWhereUsedQueryPlugin.findCloneableEditorSupport(dataObject);
        PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
        PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Forward);
        PositionBounds positionBounds = new PositionBounds(positionRef, positionRef2);
        return new WhereUsedElement(positionBounds, stringBuffer.toString().trim(), compilationInfo.getFileObject(), null, compilationInfo);
    }

    private static TreePath getEnclosingTree(TreePath treePath) {
        while (treePath != null) {
            Tree tree = treePath.getLeaf();
            if (tree.getKind() == Tree.Kind.CLASS || tree.getKind() == Tree.Kind.METHOD || tree.getKind() == Tree.Kind.IMPORT) {
                return treePath;
            }
            treePath = treePath.getParentPath();
        }
        return null;
    }
}

