/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Scanner;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.refactoring.java.plugins.FindVisitor;

public class FindUsagesVisitor
extends FindVisitor {
    private boolean findInComments = false;
    private Collection<UsageInComment> usagesInComments = Collections.emptyList();

    public FindUsagesVisitor(WorkingCopy workingCopy) {
        super(workingCopy);
    }

    public Collection<UsageInComment> getUsagesInComments() {
        return this.usagesInComments;
    }

    public FindUsagesVisitor(WorkingCopy workingCopy, boolean bl) {
        super(workingCopy);
        this.findInComments = bl;
        if (bl) {
            this.usagesInComments = new ArrayList<UsageInComment>();
        }
    }

    @Override
    public Tree visitCompilationUnit(CompilationUnitTree compilationUnitTree, Element element) {
        if (this.findInComments) {
            String string = element.getSimpleName().toString();
            TokenSequence tokenSequence = this.workingCopy.getTokenHierarchy().tokenSequence(JavaTokenId.language());
            while (tokenSequence.moveNext()) {
                Token token = tokenSequence.token();
                if (token.id() != JavaTokenId.BLOCK_COMMENT && token.id() != JavaTokenId.LINE_COMMENT && token.id() != JavaTokenId.JAVADOC_COMMENT) continue;
                Scanner scanner = new Scanner(((Object)token.text()).toString());
                scanner.useDelimiter("[^a-zA-Z0-9_]");
                while (scanner.hasNext()) {
                    String string2 = scanner.next();
                    if (!string2.equals(string)) continue;
                    this.usagesInComments.add(new UsageInComment(tokenSequence.offset() + scanner.match().start(), tokenSequence.offset() + scanner.match().end()));
                }
            }
        }
        return (Tree)super.visitCompilationUnit(compilationUnitTree, element);
    }

    @Override
    public Tree visitIdentifier(IdentifierTree identifierTree, Element element) {
        this.addIfMatch(this.getCurrentPath(), identifierTree, element);
        return (Tree)super.visitIdentifier(identifierTree, element);
    }

    @Override
    public Tree visitMemberSelect(MemberSelectTree memberSelectTree, Element element) {
        this.addIfMatch(this.getCurrentPath(), memberSelectTree, element);
        return (Tree)super.visitMemberSelect(memberSelectTree, element);
    }

    @Override
    public Tree visitNewClass(NewClassTree newClassTree, Element element) {
        Trees trees = this.workingCopy.getTrees();
        ClassTree classTree = newClassTree.getClassBody();
        if (classTree != null && element.getKind() == ElementKind.CONSTRUCTOR) {
            Element element2 = this.workingCopy.getTrees().getElement(TreePath.getPath(this.workingCopy.getCompilationUnit(), (Tree)classTree));
            if (element2 == null) {
                Logger.getLogger("org.netbeans.modules.refactoring.java").severe("FindUsages cannot resolve " + classTree);
            } else {
                for (ExecutableElement executableElement : ElementFilter.constructorsIn(element2.getEnclosedElements())) {
                    MethodTree methodTree = this.workingCopy.getTrees().getTree(executableElement);
                    TreePath treePath = trees.getPath(this.workingCopy.getCompilationUnit(), ((ExpressionStatementTree)methodTree.getBody().getStatements().get(0)).getExpression());
                    Element element3 = trees.getElement(treePath);
                    if (element3 == null || !((Object)element3).equals(element)) continue;
                    this.addUsage(treePath);
                }
            }
        } else {
            this.addIfMatch(this.getCurrentPath(), newClassTree, element);
        }
        return (Tree)super.visitNewClass(newClassTree, element);
    }

    private void addIfMatch(TreePath treePath, Tree tree, Element element) {
        if (this.workingCopy.getTreeUtilities().isSynthetic(treePath) && (ElementKind.CONSTRUCTOR != element.getKind() || tree.getKind() != Tree.Kind.IDENTIFIER || !"super".contentEquals(((IdentifierTree)tree).getName()))) {
            return;
        }
        Trees trees = this.workingCopy.getTrees();
        Element element2 = trees.getElement(treePath);
        if (element2 == null) {
            if ((treePath = treePath.getParentPath()) != null && treePath.getLeaf().getKind() == Tree.Kind.IMPORT) {
                ImportTree importTree = (ImportTree)treePath.getLeaf();
                if (!importTree.isStatic()) {
                    return;
                }
                Tree tree2 = importTree.getQualifiedIdentifier();
                if (tree2.getKind() != Tree.Kind.MEMBER_SELECT) {
                    return;
                }
                final Name name = ((MemberSelectTree)tree2).getIdentifier();
                ExpressionTree expressionTree = ((MemberSelectTree)tree2).getExpression();
                treePath = trees.getPath(this.workingCopy.getCompilationUnit(), expressionTree);
                element2 = trees.getElement(treePath);
                if (element2 == null) {
                    return;
                }
                Iterator iterator = this.workingCopy.getElementUtilities().getMembers(element2.asType(), new ElementUtilities.ElementAcceptor(){

                    public boolean accept(Element element, TypeMirror typeMirror) {
                        return ((Object)name).equals(element.getSimpleName());
                    }
                }).iterator();
                if (iterator.hasNext()) {
                    element2 = (Element)iterator.next();
                }
                if (iterator.hasNext()) {
                    return;
                }
            } else {
                return;
            }
        }
        if (element != null && element.getKind() == ElementKind.METHOD && element2.getKind() == ElementKind.METHOD) {
            if (((Object)element2).equals(element) || this.workingCopy.getElements().overrides((ExecutableElement)element2, (ExecutableElement)element, (TypeElement)element.getEnclosingElement())) {
                this.addUsage(this.getCurrentPath());
            }
        } else if (((Object)element2).equals(element)) {
            this.addUsage(this.getCurrentPath());
        }
    }

    public static class UsageInComment {
        int from;
        int to;

        public UsageInComment(int n, int n2) {
            this.from = n;
            this.to = n2;
        }
    }
}

