/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.api.tool;

import java.awt.EventQueue;
import java.beans.FeatureDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.collector.DataCollectorConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorDataProviderConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightToolConfiguration;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.impl.IDPProvider;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorProvider;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;

public final class DLightTool
implements Validateable<DLightTarget> {
    private static final Logger log = DLightLogger.getLogger(DLightTool.class);
    private final String id;
    private final String toolName;
    private final String detailedToolName;
    private final String description;
    private boolean enabled;
    private final List<DataCollector<?>> dataCollectors;
    private final List<IndicatorDataProvider<?>> indicatorDataProviders;
    private final List<Indicator<?>> indicators;
    private ValidationStatus validationStatus = ValidationStatus.initialStatus();
    private ValidationStatus dataCollectorsValidationStatus = ValidationStatus.initialStatus();
    private ValidationStatus indicatorDataProvidersValidationStatus = ValidationStatus.initialStatus();
    private final List<ValidationListener> validationListeners = Collections.synchronizedList(new ArrayList());
    private boolean collectorsTurnedOn = true;
    private final String iconPath;
    private final DLightToolConfiguration configuration;
    private volatile Boolean idpsInitialized = false;
    private volatile Boolean dcsInitialized = false;
    private boolean visible;
    private boolean isDetailsEnabled = true;
    private final FeatureDescriptor descriptor;

    private DLightTool(DLightToolConfiguration configuration) {
        DLightToolConfigurationAccessor toolConfAccessor = DLightToolConfigurationAccessor.getDefault();
        this.id = configuration.getID();
        this.toolName = toolConfAccessor.getToolName(configuration);
        this.detailedToolName = toolConfAccessor.getDetailedToolName(configuration);
        this.iconPath = toolConfAccessor.getIconPath(configuration);
        this.description = toolConfAccessor.getToolDescription(configuration);
        this.dataCollectors = Collections.synchronizedList(new ArrayList());
        this.indicators = new ArrayList();
        this.configuration = configuration;
        this.indicatorDataProviders = Collections.synchronizedList(new ArrayList());
        this.visible = configuration.isVisible();
        this.enabled = true;
        this.descriptor = configuration.detailsDescription;
    }

    static DLightTool newDLightTool(DLightToolConfiguration configuration) {
        return new DLightTool(configuration);
    }

    public final void enable() {
        this.enabled = true;
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void disable() {
        this.enabled = false;
    }

    void turnCollectorsState(String collectorName, boolean turnedOn) {
        this.collectorsTurnedOn = turnedOn;
    }

    boolean collectorsTurnedOn() {
        return this.collectorsTurnedOn;
    }

    @Override
    public ValidationStatus getValidationStatus() {
        return this.validationStatus;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public final String getName() {
        return this.toolName;
    }

    public final FeatureDescriptor getFeatureDescriptor() {
        return this.descriptor;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getID() {
        return this.id;
    }

    public final String getDetailedName() {
        return this.detailedToolName;
    }

    public final boolean hasIcon() {
        return this.iconPath != null;
    }

    public final String getIconPath() {
        return this.iconPath;
    }

    public final List<DataCollector<?>> getCollectors() {
        this.initCollectors();
        return this.dataCollectors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initCollectors() {
        DLightTool dLightTool = this;
        synchronized (dLightTool) {
            if (this.dcsInitialized.booleanValue()) {
                return;
            }
            DLightToolConfigurationAccessor toolConfAccessor = DLightToolConfigurationAccessor.getDefault();
            List<DataCollectorConfiguration> configurations = toolConfAccessor.getDataCollectors(this.configuration);
            List<IndicatorDataProviderConfiguration> idpConfigurations = toolConfAccessor.getIndicatorDataProviders(this.configuration);
            for (DataCollectorConfiguration conf : configurations) {
                DataCollector<?> collector = DataCollectorProvider.getInstance().createDataCollector(conf);
                if (collector == null) {
                    log.log(Level.INFO, "Could not find DataCollector for configuration with id:{0} check if DataColelctorFactory is registered in Global Lookup with the same ID", conf.getID());
                    continue;
                }
                this.registerCollector(collector);
                if (!(collector instanceof IndicatorDataProvider) || !idpConfigurations.contains((IndicatorDataProviderConfiguration)((Object)conf))) continue;
                this.registerIndicatorDataProvider((IndicatorDataProvider)((Object)collector));
            }
            this.dcsInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndicatorDataProviders() {
        DLightTool dLightTool = this;
        synchronized (dLightTool) {
            if (this.idpsInitialized.booleanValue()) {
                return;
            }
            DLightToolConfigurationAccessor toolConfAccessor = DLightToolConfigurationAccessor.getDefault();
            List<DataCollectorConfiguration> configurations = toolConfAccessor.getDataCollectors(this.configuration);
            List<IndicatorDataProviderConfiguration> idpConfigurations = toolConfAccessor.getIndicatorDataProviders(this.configuration);
            for (IndicatorDataProviderConfiguration idp : idpConfigurations) {
                if ((!(idp instanceof DataCollectorConfiguration) || this.dcsInitialized.booleanValue() && configurations.contains((DataCollectorConfiguration)((Object)idp))) && idp instanceof DataCollectorConfiguration) continue;
                IndicatorDataProvider indDataProvider = IDPProvider.getInstance().create(idp);
                if (indDataProvider == null) {
                    log.log(Level.INFO, "Could not find IndicatorDataProvider for configuration with id:{0} check if IndicatorDataProviderFactory is registered in Global Lookup with the same ID", idp.getID());
                    continue;
                }
                this.registerIndicatorDataProvider(indDataProvider);
            }
            this.idpsInitialized = true;
        }
    }

    final List<DataCollector<?>> getCollectorsByName(String name) {
        this.initCollectors();
        return this.dataCollectors;
    }

    private void registerIndicatorDataProvider(IndicatorDataProvider idp) {
        if (!this.indicatorDataProviders.contains(idp)) {
            this.indicatorDataProviders.add(idp);
        }
    }

    public List<IndicatorDataProvider<?>> getIndicatorDataProviders() {
        this.initIndicatorDataProviders();
        return this.indicatorDataProviders;
    }

    List<IndicatorDataProvider<?>> getIndicatorDataProviders(String name) {
        this.initIndicatorDataProviders();
        return this.indicatorDataProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<Indicator<?>> getIndicators() {
        List<Indicator<?>> list = this.indicators;
        synchronized (list) {
            if (this.indicators.isEmpty()) {
                List<IndicatorConfiguration> indConfigurationsList = DLightToolConfigurationAccessor.getDefault().getIndicators(this.configuration);
                for (IndicatorConfiguration indConfiguration : indConfigurationsList) {
                    Indicator<?> indicator = IndicatorProvider.getInstance().createIndicator(this.id, indConfiguration, this.isDetailsEnabled);
                    if (indicator == null) {
                        log.log(Level.INFO, "Could not find Indicator for configuration with id:{0} check if IndicatorFactory is registered in Global Lookup with the same ID", indConfiguration.getID());
                        continue;
                    }
                    IndicatorAccessor.getDefault().setToolDescription(indicator, this.description);
                    if (this.indicators.contains(indicator)) continue;
                    this.indicators.add(indicator);
                }
            }
            return this.indicators;
        }
    }

    void registerCollector(DataCollector collector) {
        if (collector == null) {
            log.info("Cannot register collector");
            return;
        }
        if (!this.dataCollectors.contains(collector)) {
            this.dataCollectors.add(collector);
        }
        collector.addValidationListener(new ValidationListener(){

            @Override
            public void validationStateChanged(Validateable source, ValidationStatus oldStatus, ValidationStatus newStatus) {
                DLightTool.this.notifyStatusChanged(oldStatus, newStatus);
            }
        });
    }

    @Override
    public final ValidationStatus validate(DLightTarget target) {
        if (this.validationStatus.isValid()) {
            return this.validationStatus;
        }
        ValidationStatus oldStatus = this.validationStatus;
        ValidationStatus newStatus = this.doValidation(target);
        this.notifyStatusChanged(oldStatus, newStatus);
        this.validationStatus = newStatus;
        return newStatus;
    }

    public final ValidationStatus validateIndicatorDataProviders(final DLightConfiguration dlightConfiguration, final DLightTarget target) {
        if (this.indicatorDataProvidersValidationStatus.isValid()) {
            return this.indicatorDataProvidersValidationStatus;
        }
        this.initIndicatorDataProviders();
        this.initCollectors();
        if (EventQueue.isDispatchThread()) {
            Future task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus result = ValidationStatus.initialStatus();
                    for (IndicatorDataProvider<?> indicatorDataProvider : dlightConfiguration.getConfigurationOptions(false).getIndicatorDataProviders(DLightTool.this)) {
                        result = result.merge(indicatorDataProvider.validate(target));
                    }
                    for (DataCollector dataCollector : dlightConfiguration.getConfigurationOptions(false).getCollectors(DLightTool.this)) {
                        if (!(dataCollector instanceof IndicatorDataProvider)) continue;
                        result = result.merge(dataCollector.validate(target));
                    }
                    return result;
                }
            }, (String)("Validate IndicatorDataProviders for tool " + this.getID()));
            try {
                this.indicatorDataProvidersValidationStatus = (ValidationStatus)task.get();
                return this.indicatorDataProvidersValidationStatus;
            }
            catch (InterruptedException ex) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException ex) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus result = ValidationStatus.initialStatus();
        for (IndicatorDataProvider<?> indicatorDataProvider : dlightConfiguration.getConfigurationOptions(false).getIndicatorDataProviders(this)) {
            result = result.merge(indicatorDataProvider.validate(target));
        }
        for (DataCollector dataCollector : dlightConfiguration.getConfigurationOptions(false).getCollectors(this)) {
            if (!(dataCollector instanceof IndicatorDataProvider)) continue;
            result = result.merge(dataCollector.validate(target));
        }
        this.indicatorDataProvidersValidationStatus = result;
        return this.indicatorDataProvidersValidationStatus;
    }

    public final ValidationStatus validateDataCollectors(final DLightConfiguration dlightConfiguration, final DLightTarget target) {
        if (this.dataCollectorsValidationStatus.isValid()) {
            return this.dataCollectorsValidationStatus;
        }
        this.initCollectors();
        this.initIndicatorDataProviders();
        if (EventQueue.isDispatchThread()) {
            Future task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus result = ValidationStatus.initialStatus();
                    for (DataCollector<?> dc : dlightConfiguration.getConfigurationOptions(false).getCollectors(DLightTool.this)) {
                        result = result.merge(dc.validate(target));
                    }
                    return result;
                }
            }, (String)("Validate DataCollectors for tool " + this.getID()));
            try {
                this.dataCollectorsValidationStatus = (ValidationStatus)task.get();
                return this.dataCollectorsValidationStatus;
            }
            catch (InterruptedException ex) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException ex) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus result = ValidationStatus.initialStatus();
        for (DataCollector<?> dc : dlightConfiguration.getConfigurationOptions(false).getCollectors(this)) {
            result = result.merge(dc.validate(target));
        }
        result = this.dataCollectorsValidationStatus;
        return this.dataCollectorsValidationStatus;
    }

    @Override
    public final void invalidate() {
        this.validationStatus = ValidationStatus.initialStatus();
        this.notifyStatusChanged(null, this.validationStatus);
    }

    final synchronized ValidationStatus doValidation(final DLightTarget target) {
        this.initCollectors();
        this.initIndicatorDataProviders();
        if (EventQueue.isDispatchThread()) {
            Future task = DLightExecutorService.submit((Callable)new Callable<ValidationStatus>(){

                @Override
                public ValidationStatus call() throws Exception {
                    ValidationStatus result = ValidationStatus.initialStatus();
                    for (DataCollector dc : DLightTool.this.dataCollectors) {
                        result = result.merge(dc.validate(target));
                    }
                    for (IndicatorDataProvider idp : DLightTool.this.indicatorDataProviders) {
                        result = result.merge(idp.validate(target));
                    }
                    return result;
                }
            }, (String)("Validate DataCollectors and IndicatorDataProviders for tool " + this.getID()));
            try {
                return (ValidationStatus)task.get();
            }
            catch (InterruptedException ex) {
                return ValidationStatus.initialStatus();
            }
            catch (ExecutionException ex) {
                return ValidationStatus.initialStatus();
            }
        }
        ValidationStatus result = ValidationStatus.initialStatus();
        for (DataCollector<?> dataCollector : this.dataCollectors) {
            result = result.merge(dataCollector.validate(target));
        }
        for (IndicatorDataProvider indicatorDataProvider : this.indicatorDataProviders) {
            result = result.merge(indicatorDataProvider.validate(target));
        }
        return result;
    }

    @Override
    public final void addValidationListener(ValidationListener listener) {
        if (!this.validationListeners.contains(listener)) {
            this.validationListeners.add(listener);
        }
    }

    @Override
    public final void removeValidationListener(ValidationListener listener) {
        this.validationListeners.remove(listener);
    }

    private void notifyStatusChanged(ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (oldStatus != null && oldStatus.equals(newStatus)) {
            return;
        }
        for (ValidationListener validationListener : this.validationListeners) {
            validationListener.validationStateChanged(this, oldStatus, newStatus);
        }
    }

    public String toString() {
        return this.getName();
    }

    static {
        DLightToolAccessor.setDefault(new DLightToolAccessorImpl());
    }

    private static final class DLightToolAccessorImpl
    extends DLightToolAccessor {
        private DLightToolAccessorImpl() {
        }

        @Override
        public List<IndicatorDataProvider<?>> getIndicatorDataProviders(DLightTool tool) {
            return tool.getIndicatorDataProviders();
        }

        @Override
        public DLightTool newDLightTool(DLightToolConfiguration configuration) {
            return new DLightTool(configuration);
        }

        @Override
        public List<Indicator<?>> getIndicators(DLightTool tool) {
            return tool.getIndicators();
        }

        @Override
        public List<DataCollector<?>> getCollectors(DLightTool tool) {
            return tool.getCollectors();
        }

        @Override
        public boolean collectorsTurnedOn(DLightTool tool) {
            return tool.collectorsTurnedOn();
        }

        @Override
        public void turnCollectorsState(DLightTool tool, boolean turnedOn) {
            tool.turnCollectorsState(null, turnedOn);
        }

        @Override
        public void setDetailsEnabled(DLightTool tool, boolean isEnabled) {
            tool.isDetailsEnabled = isEnabled;
        }

        @Override
        public boolean isDetailsEnabled(DLightTool tool) {
            return tool.isDetailsEnabled;
        }
    }
}

