/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.impl;

import java.io.InterruptedIOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilter;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.dlight.util.Range;
import org.openide.util.Exceptions;

public abstract class SQLDataStorage
implements PersistentDataStorage {
    public static final String SQL_DATA_STORAGE_TYPE = "db:sql";
    private static final DataStorageType storageType = DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    private LinkedBlockingQueue<Request> requestQueue;
    private final Map<String, PreparedStatement> insertPreparedStatments;
    private static final int WAIT_INTERVALS = 100;
    private static final int MAX_BULK_SIZE = 10000;
    private static final int IDLE_ITERATIONS = 2;
    private static final Logger logger = DLightLogger.getLogger(SQLDataStorage.class);
    protected Connection connection;
    protected HashMap<String, DataTableMetadata> tables = new HashMap();
    protected static final HashMap<Class<?>, String> classToType = new HashMap();
    private boolean enabled = false;
    private AsyncThread asyncThread = null;
    private ServiceInfoDataStorage serviceInfoDataStorage;

    public static final DataStorageType getStorageType() {
        return storageType;
    }

    protected SQLDataStorage() {
        this.insertPreparedStatments = new HashMap<String, PreparedStatement>();
    }

    protected SQLDataStorage(String dburl) throws SQLException {
        this();
        this.connect(dburl);
        if (!this.enabled) {
            this.enable();
        }
    }

    @Override
    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
    }

    protected final ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    @Override
    public boolean shutdown() {
        this.disable();
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }
        return true;
    }

    protected abstract String getSQLQueriesDelimeter();

    protected void finalize() throws Throwable {
        this.disable();
    }

    private synchronized void disable() {
        this.asyncThread.shutdown();
        this.enabled = false;
        this.asyncThread = null;
    }

    protected abstract void connect(String var1) throws SQLException;

    protected String classToType(Class<?> clazz) {
        return classToType.get(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final String createView(Collection<DataTableMetadataFilter> filters, String tableName, List<DataTableMetadata.Column> columns) {
        if (filters == null || filters.isEmpty()) {
            return tableName;
        }
        String viewName = tableName + "_DLIGHT_VIEW";
        try {
            Statement stmt = this.connection.createStatement();
            try {
                stmt.execute("DROP VIEW IF EXISTS " + viewName);
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        StringBuilder createViewQuery = new StringBuilder("CREATE  VIEW " + viewName + " AS ");
        createViewQuery.append("SELECT ");
        createViewQuery.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(columns, new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column item) {
                return item.getExpression() == null ? item.getColumnName() : item.getExpression();
            }
        }));
        createViewQuery.append(" FROM " + tableName);
        String whereClause = null;
        for (DataTableMetadataFilter filter : filters) {
            Range<?> range;
            DataTableMetadata.Column filterColumn = filter.getFilteredColumn();
            if (!columns.contains(filterColumn) || (range = filter.getNumericDataFilter().getInterval()).getStart() == null && range.getEnd() == null) continue;
            whereClause = range.toString(" WHERE ", "%d <= " + filterColumn.getColumnName(), " AND ", filterColumn.getColumnName() + " <= %d", null);
            break;
        }
        if (whereClause == null) {
            return tableName;
        }
        createViewQuery.append(whereClause);
        try {
            Statement stmt = this.connection.createStatement();
            try {
                stmt.execute(createViewQuery.toString());
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, null, ex);
            return tableName;
        }
        return viewName;
    }

    protected final void loadTable(DataTableMetadata metadata) {
        this.tables.put(metadata.getName(), metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean createTable(final DataTableMetadata metadata) {
        if (this.tables.containsKey(metadata.getName())) {
            return true;
        }
        String tableName = metadata.getName();
        StringBuilder sb = new StringBuilder("create table " + tableName + "(");
        sb.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(metadata.getColumns(), new Convertor<DataTableMetadata.Column>(){

            @Override
            public String toString(DataTableMetadata.Column item) {
                return item.getColumnName() + " " + SQLDataStorage.this.classToType(item.getColumnClass());
            }
        }));
        sb.append(")" + this.getSQLQueriesDelimeter());
        logger.fine("About to execute query: " + sb.toString());
        try {
            Statement stmt = this.connection.createStatement();
            try {
                stmt.execute(sb.toString());
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, null, ex);
            return false;
        }
        logger.fine("Table " + tableName + " created");
        this.tables.put(tableName, metadata);
        for (DataTableMetadata.Column col : metadata.getIndexedColumns()) {
            try {
                Statement stmt = this.connection.createStatement();
                try {
                    stmt.execute("create index " + tableName + "_" + col.getColumnName() + "_index on " + tableName + "(" + col.getColumnName() + ")");
                }
                finally {
                    stmt.close();
                }
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
        }
        DLightExecutorService.submit((Runnable)new Runnable(){

            @Override
            public void run() {
                SQLDataStorage.this.getPreparedInsertStatement(metadata);
            }
        }, (String)("SQL: Prepare Insert Statement for " + metadata.getName()));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PreparedStatement getPreparedInsertStatement(DataTableMetadata tableDescription) {
        Map<String, PreparedStatement> map = this.insertPreparedStatments;
        synchronized (map) {
            PreparedStatement statement = this.insertPreparedStatments.get(tableDescription.getName());
            if (statement != null) {
                return statement;
            }
            String tableName = tableDescription.getName();
            StringBuilder query = new StringBuilder("insert into " + tableName + " (");
            query.append(new EnumStringConstructor<String>().constructEnumString(tableDescription.getColumnNames(), new Convertor<String>(){

                @Override
                public String toString(String item) {
                    return item;
                }
            }));
            query.append(") values (");
            int columnsCount = tableDescription.getColumnsCount();
            for (int i = 0; i < columnsCount - 1; ++i) {
                query.append("?, ");
            }
            query.append("? ) " + this.getSQLQueriesDelimeter());
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching " + query.toString());
            }
            try {
                statement = this.connection.prepareStatement(query.toString());
            }
            catch (SQLException ex) {
                logger.log(Level.SEVERE, null, ex);
            }
            if (statement != null) {
                this.insertPreparedStatments.put(tableName, statement);
            }
            return statement;
        }
    }

    public ResultSet select(String tableName, List<DataTableMetadata.Column> columns) {
        return this.select(tableName, columns, null);
    }

    @Override
    public Collection<DataStorageType> getStorageTypes() {
        return Arrays.asList(DataStorageTypeFactory.getInstance().getDataStorageType(SQL_DATA_STORAGE_TYPE));
    }

    public final synchronized ResultSet select(DataTableMetadata metadata, Collection<DataTableMetadataFilter> filters) {
        String tableName = metadata.getName();
        String sqlQuery = metadata.getViewStatement();
        List<DataTableMetadata.Column> columns = metadata.getColumns();
        List<DataTableMetadata> sourceTables = metadata.getSourceTables();
        Hashtable<String, String> renamedTableNames = new Hashtable<String, String>();
        if (sourceTables != null) {
            for (DataTableMetadata sourceTable : sourceTables) {
                String viewName = this.createView(filters, sourceTable.getName(), sourceTable.getColumns());
                if (viewName == null || viewName.equals(sourceTable.getName())) continue;
                renamedTableNames.put(sourceTable.getName(), viewName);
            }
        } else {
            String viewName = this.createView(filters, tableName, columns);
            if (viewName != null && viewName.equals(tableName)) {
                return this.select(tableName, columns, sqlQuery);
            }
            if (sqlQuery == null) {
                return this.select(viewName, columns, null);
            }
        }
        String sqlQueryNew = sqlQuery;
        for (Map.Entry entry : renamedTableNames.entrySet()) {
            sqlQueryNew = sqlQueryNew.replaceAll((String)entry.getKey(), (String)entry.getValue());
        }
        return this.select(tableName, columns, sqlQueryNew);
    }

    public final ResultSet select(String tableName, List<DataTableMetadata.Column> columns, String sqlQuery) {
        ResultSet rs;
        block3: {
            if (sqlQuery == null) {
                StringBuilder query = new StringBuilder("select ");
                query.append(new EnumStringConstructor<DataTableMetadata.Column>().constructEnumString(columns, new Convertor<DataTableMetadata.Column>(){

                    @Override
                    public String toString(DataTableMetadata.Column item) {
                        return item.getExpression() == null ? item.getColumnName() : item.getExpression();
                    }
                }));
                query.append(" from ").append(tableName);
                sqlQuery = query.toString();
            }
            rs = null;
            try {
                rs = this.connection.createStatement().executeQuery(sqlQuery);
            }
            catch (SQLException ex) {
                Throwable cause = ex.getCause();
                if (cause != null && (cause instanceof InterruptedIOException || cause instanceof InterruptedException)) break block3;
                logger.log(Level.SEVERE, null, ex);
            }
        }
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeUpdate(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        try {
            stmt.executeUpdate(sql);
        }
        finally {
            stmt.close();
        }
    }

    protected final Connection getConnection() {
        return this.connection;
    }

    protected final void execute(String sql) throws SQLException {
        this.requestQueue.add(new CustomRequest(this.connection.prepareStatement(sql)));
    }

    protected void addInsertInQueue(PreparedStatement st) {
        this.requestQueue.add(new CustomRequest(st));
    }

    @Override
    public final void addData(String tableName, List<DataRow> data) {
        for (DataRow row : data) {
            this.requestQueue.add(new DataRowInsertRequest(tableName, row));
        }
    }

    @Override
    public final synchronized void syncAddData(String tableName, List<DataRow> data) {
        for (DataRow row : data) {
            DataRowInsertRequest request = new DataRowInsertRequest(tableName, row);
            try {
                request.execute();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private PreparedStatement createRowInsertStatement(String tableName, DataRow row) {
        if (logger.isLoggable(Level.INFO)) {
            logger.fine("Will add to the queue with using prepared statement");
        }
        StringBuilder query = new StringBuilder("insert into " + tableName + " (");
        query.append(new EnumStringConstructor<String>().constructEnumString(row.getColumnNames(), new Convertor<String>(){

            @Override
            public String toString(String item) {
                return item;
            }
        }));
        query.append(") values (");
        query.append(new EnumStringConstructor<Object>().constructEnumString(row.getData(), new Convertor<Object>(){

            @Override
            public String toString(Object item) {
                return '\'' + String.valueOf(item) + '\'';
            }
        }));
        query.append(")" + this.getSQLQueriesDelimeter());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("----------SQL: dispatching " + query.toString());
        }
        try {
            return this.connection.prepareStatement(query.toString());
        }
        catch (SQLException ex) {
            logger.log(Level.SEVERE, null, ex);
            return null;
        }
    }

    private synchronized void enable() {
        if (!this.enabled) {
            this.requestQueue = new LinkedBlockingQueue();
            this.enabled = true;
            if (this.asyncThread == null) {
                this.asyncThread = new AsyncThread();
            }
            this.asyncThread.start();
        }
    }

    public final PreparedStatement prepareStatement(String sql) throws SQLException {
        String sqlUpper;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("SQL: prepare statement " + sql);
        }
        PreparedStatement stmt = (sqlUpper = sql.toUpperCase()).startsWith("INSERT INTO ") ? this.connection.prepareStatement(sql, 1) : (sqlUpper.endsWith(" FOR UPDATE") ? this.connection.prepareStatement(sql, 1003, 1008) : this.connection.prepareStatement(sql));
        return stmt;
    }

    public void flush() {
        try {
            this.asyncThread.flush();
        }
        catch (InterruptedException ex) {
            logger.log(Level.INFO, null, ex);
        }
    }

    static {
        classToType.put(Byte.class, "tinyint");
        classToType.put(Short.class, "smallint");
        classToType.put(Integer.class, "int");
        classToType.put(Long.class, "bigint");
        classToType.put(Double.class, "double");
        classToType.put(Float.class, "real");
        classToType.put(String.class, "varchar");
        classToType.put(Time.class, "bigint");
    }

    private class AsyncThread
    extends Thread {
        private volatile boolean idle;
        private volatile boolean stop;

        public AsyncThread() {
            this.setDaemon(true);
            this.setName("DLIGHT: SQL Storage AsyncThread");
        }

        public void flush() throws InterruptedException {
            while (!this.idle) {
                Thread.sleep(100L);
            }
        }

        @Override
        public void run() {
            int idleIterations = 0;
            ArrayList requestList = new ArrayList();
            while (true) {
                SQLDataStorage.this.requestQueue.drainTo(requestList, 10000);
                if (requestList.isEmpty()) {
                    if (2 <= ++idleIterations) {
                        this.idle = true;
                        if (this.stop) break;
                        idleIterations = 2;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                idleIterations = 0;
                this.idle = false;
                try {
                    for (Request request : requestList) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.fine("SQLDataStorage.AsyncThread executes " + request.toString());
                        }
                        request.execute();
                    }
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "SQLDataStorage.async_db_write_failed", e);
                }
                requestList.clear();
            }
        }

        private void shutdown() {
            this.stop = true;
            try {
                this.flush();
            }
            catch (InterruptedException ex) {
                logger.log(Level.INFO, null, ex);
            }
        }
    }

    public static interface Convertor<T> {
        public String toString(T var1);
    }

    public static final class EnumStringConstructor<T> {
        public String constructEnumString(Collection<? extends T> collection, Convertor<T> conv) {
            StringBuilder sb = new StringBuilder();
            Iterator<T> i = collection.iterator();
            while (i.hasNext()) {
                T item = i.next();
                sb.append(conv.toString(item));
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            return sb.toString();
        }
    }

    private class DataRowInsertRequest
    extends BaseRequest {
        final String tableName;
        final DataRow dataRow;

        public DataRowInsertRequest(String tableName, DataRow dataRow) {
            this.tableName = tableName;
            this.dataRow = dataRow;
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            DataTableMetadata tableMetadata = SQLDataStorage.this.tables.get(this.tableName);
            PreparedStatement statement = SQLDataStorage.this.getPreparedInsertStatement(tableMetadata);
            if (statement == null) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            List<DataTableMetadata.Column> columns = tableMetadata.getColumns();
            List<String> columnNames = this.dataRow.getColumnNames();
            if (columnNames.size() != columns.size()) {
                return SQLDataStorage.this.createRowInsertStatement(this.tableName, this.dataRow);
            }
            int size = columns.size();
            for (int i = 0; i < size; ++i) {
                DataTableMetadata.Column c = columns.get(i);
                statement.setObject(i + 1, this.dataRow.getData(c.getColumnName()));
            }
            return statement;
        }

        public String toString() {
            return "insert into " + this.tableName + ": " + this.dataRow.toString();
        }
    }

    private static class CustomRequest
    extends BaseRequest {
        PreparedStatement preparedStatement;

        public CustomRequest(PreparedStatement preparedStatement) {
            this.preparedStatement = preparedStatement;
        }

        @Override
        PreparedStatement getPreparedStatement() throws SQLException {
            return this.preparedStatement;
        }
    }

    private static abstract class BaseRequest
    implements Request {
        private BaseRequest() {
        }

        abstract PreparedStatement getPreparedStatement() throws SQLException;

        @Override
        public void execute() throws SQLException {
            PreparedStatement statement = this.getPreparedStatement();
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("SQL: dispatching insert  " + statement.toString());
            }
            statement.execute();
        }
    }

    private static interface Request {
        public void execute() throws SQLException;
    }
}

