/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.impl.IndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorActionListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.indicator.IndicatorRepairActionProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorTickerService;
import org.netbeans.modules.dlight.spi.indicator.TickerListener;
import org.openide.util.Lookup;

public abstract class Indicator<T extends IndicatorConfiguration>
implements DLightTargetListener,
ChangeListener,
IndicatorNotificationsListener {
    private static final int PADDING = 2;
    private final Object lock = new Object();
    private final IndicatorMetadata metadata;
    private final int position;
    private String toolID;
    private String toolDecsription;
    private String actionTooltip;
    private String actionDisplayName;
    private final List<IndicatorActionListener> listeners;
    private final TickerListener tickerListener;
    private IndicatorRepairActionProvider indicatorRepairActionProvider = null;
    private DLightTarget target;
    private boolean visible;
    private final Action defaultAction;
    private final Collection<DataTableMetadata.Column> columnsProvided = new ArrayList<DataTableMetadata.Column>();
    final AtomicReference<Object> oldRef = new AtomicReference();
    private List<VisualizerConfiguration> visualizerConfigurations;

    protected final void notifyListeners(String vcID) {
        for (VisualizerConfiguration vc : this.visualizerConfigurations) {
            if (!vc.getID().equals(vcID)) continue;
            this.notifyListeners(vc);
        }
    }

    protected final String getDescription() {
        return this.toolDecsription;
    }

    protected final String getActionTooltip() {
        if (this.actionTooltip == null) {
            return null;
        }
        StringBuilder st = new StringBuilder();
        st.append("<html><body>");
        st.append(this.actionTooltip.replaceAll("\n", "<br>"));
        st.append("</body></html>");
        return st.toString();
    }

    private void notifyListeners(VisualizerConfiguration vc) {
        for (IndicatorActionListener l : this.listeners) {
            l.openVisualizerForIndicator(this, vc);
        }
    }

    protected final void notifyListeners() {
        for (IndicatorActionListener l : this.listeners) {
            l.mouseClickedOnIndicator(this);
        }
    }

    protected Indicator(T configuration) {
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.metadata = IndicatorConfigurationAccessor.getDefault().getIndicatorMetadata((IndicatorConfiguration)configuration);
        this.visualizerConfigurations = IndicatorConfigurationAccessor.getDefault().getVisualizerConfigurations((IndicatorConfiguration)configuration);
        this.position = IndicatorConfigurationAccessor.getDefault().getIndicatorPosition((IndicatorConfiguration)configuration);
        this.actionDisplayName = IndicatorConfigurationAccessor.getDefault().getActionDisplayName((IndicatorConfiguration)configuration);
        this.actionTooltip = IndicatorConfigurationAccessor.getDefault().getActionTooltip((IndicatorConfiguration)configuration);
        this.tickerListener = new TickerListener(){

            @Override
            public void tick() {
                Indicator.this.tick();
            }
        };
        this.visible = ((IndicatorConfiguration)configuration).isVisible();
        this.setIndicatorActionsProviderContext(Lookup.EMPTY);
        this.defaultAction = new AbstractAction(this.actionDisplayName){

            @Override
            public void actionPerformed(ActionEvent e) {
                Indicator.this.notifyListeners();
            }
        };
        this.defaultAction.putValue("Name", this.actionDisplayName);
        if (this.actionTooltip != null) {
            this.defaultAction.putValue("ShortDescription", this.getActionTooltip());
        }
    }

    public abstract void setIndicatorActionsProviderContext(Lookup var1);

    public final Action getDefaultAction() {
        return this.defaultAction;
    }

    protected abstract void repairNeeded(boolean var1);

    private void setRepairActionProviderFor(IndicatorRepairActionProvider repairActionProvider) {
        this.indicatorRepairActionProvider = repairActionProvider;
        this.indicatorRepairActionProvider.addChangeListener(this);
        this.repairNeeded(true);
    }

    public final int getPosition() {
        return this.position;
    }

    protected final IndicatorRepairActionProvider getRepairActionProvider() {
        return this.indicatorRepairActionProvider;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        boolean needRepair;
        if (this.indicatorRepairActionProvider == null || e.getSource() != this.indicatorRepairActionProvider) {
            return;
        }
        boolean bl = needRepair = this.indicatorRepairActionProvider.needRepair() || !this.indicatorRepairActionProvider.getValidationStatus().isValid();
        if (!needRepair) {
            this.indicatorRepairActionProvider.removeChangeListener(this);
        }
        this.repairNeeded(needRepair);
    }

    @Override
    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.targetStarted(event.target);
                return;
            }
            case FAILED: {
                this.targetFinished(event.target);
                return;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                return;
            }
            case DONE: {
                this.targetFinished(event.target);
                return;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetStarted(DLightTarget target) {
        Object object = this.lock;
        synchronized (object) {
            this.target = target;
            IndicatorTickerService.getInstance().subsribe(this.tickerListener);
            this.targetStarted();
        }
    }

    protected void targetStarted() {
    }

    protected final Collection<DataTableMetadata.Column> getColumnsProvided() {
        return this.columnsProvided;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void targetFinished(DLightTarget target) {
        Object object = this.lock;
        synchronized (object) {
            this.columnsProvided.clear();
            IndicatorTickerService.getInstance().unsubscribe(this.tickerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DLightTarget getTarget() {
        Object object = this.lock;
        synchronized (object) {
            return this.target;
        }
    }

    protected abstract void tick();

    @Override
    public void suggestRepaint() {
    }

    public final boolean isVisible() {
        return this.visible;
    }

    public final void setVisible(boolean visible) {
        this.visible = visible;
    }

    private void initMouseListener() {
        final JComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        component.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                component.requestFocus();
            }
        });
        final Color c = component.getBackground();
        final Color selectionColor = c == null ? UIManager.getColor("Panel.background") : c.darker();
        component.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (component == null) {
                    return;
                }
                component.setBorder(BorderFactory.createEtchedBorder());
                component.setBackground(selectionColor);
                JRootPane rootPane = component.getRootPane();
                if (rootPane == null) {
                    return;
                }
                InputMap iMap = rootPane.getInputMap(1);
                iMap.put(KeyStroke.getKeyStroke(10, 0), "enter");
                ActionMap aMap = rootPane.getActionMap();
                if (component.getActionMap().get("enter") != null) {
                    aMap.put("enter", component.getActionMap().get("enter"));
                } else {
                    aMap.put("enter", new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Indicator.this.notifyListeners();
                        }
                    });
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (component == null) {
                    return;
                }
                component.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                component.setBackground(c);
                JRootPane rootPane = component.getRootPane();
                if (rootPane == null) {
                    return;
                }
                InputMap iMap = rootPane.getInputMap(1);
                iMap.put(KeyStroke.getKeyStroke(10, 0), Indicator.this.oldRef.get());
                ActionMap aMap = rootPane.getActionMap();
                aMap.remove("enter");
            }
        });
    }

    void setToolID(String toolID) {
        this.toolID = toolID;
    }

    private final void setToolDescription(String toolDescription) {
        this.toolDecsription = toolDescription;
        if (toolDescription == null) {
            return;
        }
        JComponent component = this.getComponent();
        if (component == null) {
            return;
        }
        StringBuilder st = new StringBuilder();
        st.append("<html><body>");
        st.append(this.getDescription().replaceAll("\n", "<br>"));
        st.append("</body></html><");
        component.setToolTipText(st.toString());
    }

    final List<VisualizerConfiguration> getVisualizerConfigurations() {
        return this.visualizerConfigurations;
    }

    void addIndicatorActionListener(IndicatorActionListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    void removeIndicatorActionListener(IndicatorActionListener l) {
        this.listeners.remove(l);
    }

    public IndicatorMetadata getMetadata() {
        return this.metadata;
    }

    protected List<DataTableMetadata.Column> getMetadataColumns() {
        return this.metadata.getColumns();
    }

    final void columnProvided(DataTableMetadata.Column c) {
        this.columnsProvided.add(c);
    }

    protected String getMetadataColumnName(int idx) {
        if (idx < 0 || idx >= this.metadata.getColumnsCount()) {
            return null;
        }
        DataTableMetadata.Column col = this.metadata.getColumns().get(idx);
        return col.getColumnName();
    }

    public abstract JComponent getComponent();

    static {
        IndicatorAccessor.setDefault(new IndicatorAccessorImpl());
    }

    private static class IndicatorAccessorImpl
    extends IndicatorAccessor {
        private IndicatorAccessorImpl() {
        }

        @Override
        public void setToolID(Indicator<?> ind, String toolName) {
            ind.setToolID(toolName);
        }

        @Override
        public List<DataTableMetadata.Column> getMetadataColumns(Indicator<?> indicator) {
            return indicator.getMetadataColumns();
        }

        @Override
        public String getMetadataColumnName(Indicator<?> indicator, int idx) {
            return indicator.getMetadataColumnName(idx);
        }

        @Override
        public List<VisualizerConfiguration> getVisualizerConfigurations(Indicator<?> indicator) {
            return indicator.getVisualizerConfigurations();
        }

        @Override
        public void addIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener l) {
            indicator.addIndicatorActionListener(l);
        }

        @Override
        public void removeIndicatorActionListener(Indicator<?> indicator, IndicatorActionListener l) {
            indicator.removeIndicatorActionListener(l);
        }

        @Override
        public String getToolID(Indicator<?> ind) {
            return ((Indicator)ind).toolID;
        }

        @Override
        public void initMouseListener(Indicator<?> indicator) {
            ((Indicator)indicator).initMouseListener();
        }

        @Override
        public void setRepairActionProviderFor(Indicator<?> indicator, IndicatorRepairActionProvider repairActionProvider) {
            ((Indicator)indicator).setRepairActionProviderFor(repairActionProvider);
        }

        @Override
        public void setToolDescription(Indicator<?> ind, String toolDescription) {
            ((Indicator)ind).setToolDescription(toolDescription);
        }
    }
}

