/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.indicator;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.support.ValidateableSupport;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.spi.impl.IndicatorRepairActionProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class IndicatorRepairActionProvider
implements ValidationListener {
    private final DLightConfiguration configuration;
    private final DLightTool currentTool;
    private final DLightTarget targetToRepairFor;
    private ValidationStatus currentStatus;
    private final List<IndicatorDataProvider<?>> toReValidate;
    private final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    private final Lock listenersLock = new Lock();
    private Future<Boolean> repairTask;

    private IndicatorRepairActionProvider(DLightConfiguration configuration, DLightTool tool, DLightTarget targetToRepairFor) {
        this.configuration = configuration;
        this.currentTool = tool;
        this.targetToRepairFor = targetToRepairFor;
        List<IndicatorDataProvider<?>> providers = configuration.getConfigurationOptions(false).getIndicatorDataProviders(this.currentTool);
        if (providers == null || providers.isEmpty()) {
            this.currentStatus = tool.validateIndicatorDataProviders(configuration, targetToRepairFor);
            if (!this.currentStatus.isKnown() || this.currentStatus.isValid()) {
                this.currentStatus = ValidationStatus.invalidStatus(IndicatorRepairActionProvider.getMessage("IndicatorDataProviderNotFound"));
            }
        } else {
            this.currentStatus = ValidationStatus.invalidStatus(IndicatorRepairActionProvider.getMessage("NoIndicatorDataProviderFound"));
        }
        this.toReValidate = new ArrayList();
        if (providers != null) {
            for (IndicatorDataProvider<?> idp : providers) {
                if (idp.getValidationStatus().isKnown() && (!idp.getValidationStatus().isKnown() || !idp.getValidationStatus().isInvalid())) continue;
                idp.addValidationListener(this);
                this.toReValidate.add(idp);
                this.currentStatus = idp.getValidationStatus();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChangeListener(ChangeListener l) {
        Lock lock = this.listenersLock;
        synchronized (lock) {
            if (!this.changeListeners.contains(l)) {
                this.changeListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChangeListener(ChangeListener l) {
        Lock lock = this.listenersLock;
        synchronized (lock) {
            this.changeListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChangeListeners() {
        Lock lock = this.listenersLock;
        synchronized (lock) {
            ChangeListener[] listeners;
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener l : listeners = this.changeListeners.toArray(new ChangeListener[0])) {
                l.stateChanged(evt);
            }
        }
    }

    public final String getMessage(ValidationStatus status) {
        if (status.isValid()) {
            String message = IndicatorRepairActionProvider.getMessage("NextRun");
            if (!this.configuration.getConfigurationOptions(false).areCollectorsTurnedOn()) {
                message = IndicatorRepairActionProvider.getMessage("DataCollectorDisabled");
            }
            return message;
        }
        return status.getReason();
    }

    public boolean isValid() {
        return this.currentStatus.isValid();
    }

    public boolean needRepair() {
        return !this.currentStatus.isKnown();
    }

    public String getReason() {
        return this.currentStatus.getReason();
    }

    public final ValidationStatus getValidationStatus() {
        return this.currentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> asyncRepair() {
        IndicatorRepairActionProvider indicatorRepairActionProvider = this;
        synchronized (indicatorRepairActionProvider) {
            if (this.repairTask == null || this.repairTask.isDone()) {
                this.repairTask = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        for (IndicatorDataProvider idp : IndicatorRepairActionProvider.this.toReValidate) {
                            ValidateableSupport<DLightTarget> support = new ValidateableSupport<DLightTarget>(idp);
                            final Future<ValidationStatus> taskStatus = support.asyncValidate(IndicatorRepairActionProvider.this.targetToRepairFor, true);
                            Future result = DLightExecutorService.submit((Callable)new Callable<Boolean>(){

                                @Override
                                public Boolean call() throws Exception {
                                    final ValidationStatus status = (ValidationStatus)taskStatus.get();
                                    UIThread.invoke((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            IndicatorRepairActionProvider.this.currentStatus = status;
                                        }
                                    });
                                    return status.isKnown();
                                }
                            }, (String)("IndicatorRepairActionProvider task for " + idp.getName()));
                            try {
                                if (!((Boolean)result.get()).booleanValue()) continue;
                                return true;
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                            catch (ExecutionException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        return true;
                    }
                }, (String)"IndicatorRepairActionProvider asyncRepair");
            }
        }
        return this.repairTask;
    }

    @Override
    public void validationStateChanged(Validateable source, ValidationStatus oldStatus, ValidationStatus newStatus) {
        if (newStatus.isKnown()) {
            source.removeValidationListener(this);
            this.currentStatus = newStatus;
            this.notifyChangeListeners();
        }
    }

    private static String getMessage(String name) {
        return NbBundle.getMessage(IndicatorRepairActionProvider.class, (String)name);
    }

    static {
        IndicatorRepairActionProviderAccessor.setDefault(new IndicatorRepairActionProviderAccessorImpl());
    }

    private static final class Lock {
        private Lock() {
        }
    }

    private static class IndicatorRepairActionProviderAccessorImpl
    extends IndicatorRepairActionProviderAccessor {
        private IndicatorRepairActionProviderAccessorImpl() {
        }

        @Override
        public IndicatorRepairActionProvider createNew(DLightConfiguration configuration, DLightTool tool, DLightTarget targetToRepairFor) {
            return new IndicatorRepairActionProvider(configuration, tool, targetToRepairFor);
        }
    }
}

