/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.store;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public abstract class StoreEntry {
    private final File file;
    private final File storeFile;
    private final long ts;
    private final String label;
    private final Date date;
    private String mimeType = null;
    private List<StoreEntry> siblingEntries;

    public static StoreEntry createStoreEntry(File file, File storeFile, long ts, String label) {
        return new DefaultStoreEntry(file, storeFile, ts, label);
    }

    public static StoreEntry createDeletedStoreEntry(File file, long ts) {
        return new DeletedStoreEntry(file, ts);
    }

    public static StoreEntry createFakeStoreEntry(File file, long ts) {
        return new FakeStoreEntry(file, ts);
    }

    private StoreEntry(File file, File storeFile, long ts, String label) {
        this.file = file;
        this.storeFile = storeFile;
        this.ts = ts;
        this.label = label;
        this.date = new Date(ts);
        this.setSiblings(Collections.EMPTY_LIST);
    }

    public File getStoreFile() {
        return this.storeFile;
    }

    public File getFile() {
        return this.file;
    }

    public long getTimestamp() {
        return this.ts;
    }

    public String getLabel() {
        return this.label != null ? this.label : "";
    }

    public Date getDate() {
        return this.date;
    }

    public boolean representsFile() {
        return this.storeFile.isFile();
    }

    public List<StoreEntry> getSiblingEntries() {
        return this.siblingEntries;
    }

    public void setSiblings(Collection<StoreEntry> entries) {
        this.siblingEntries = new ArrayList<StoreEntry>(entries.size());
        for (StoreEntry entry : entries) {
            if (!entry.representsFile() || this.getFile().equals(entry.getFile())) continue;
            this.siblingEntries.add(entry);
        }
        this.siblingEntries = Collections.unmodifiableList(this.siblingEntries);
    }

    public String getMIMEType() {
        if (this.mimeType == null) {
            FileObject fo = FileUtil.toFileObject((File)this.getFile());
            this.mimeType = fo != null ? fo.getMIMEType() : "content/unknown";
        }
        return this.mimeType;
    }

    static OutputStream createStoreFileOutputStream(File storeFile) throws FileNotFoundException, IOException {
        ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(storeFile)));
        ZipEntry entry = new ZipEntry(storeFile.getName());
        zos.putNextEntry(entry);
        return zos;
    }

    abstract OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException;

    public abstract InputStream getStoreFileInputStream() throws FileNotFoundException, IOException;

    private static class FakeStoreEntry
    extends StoreEntry {
        public FakeStoreEntry(File file, long ts) {
            super(file, file, ts, "");
        }

        @Override
        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            throw new FileNotFoundException("There is no OutputStream for this for file " + this.getFile());
        }

        @Override
        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            return new FileInputStream(this.getFile());
        }
    }

    private static class DeletedStoreEntry
    extends StoreEntry {
        public DeletedStoreEntry(File file, long ts) {
            super(file, null, ts, "");
        }

        @Override
        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            this.throwNoStoreEntry();
            return null;
        }

        @Override
        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            this.throwNoStoreEntry();
            return null;
        }

        private void throwNoStoreEntry() throws FileNotFoundException {
            throw new FileNotFoundException("There is no store entry for file " + this.getFile() + " and timestamp " + this.getTimestamp());
        }
    }

    private static class DefaultStoreEntry
    extends StoreEntry {
        private DefaultStoreEntry(File file, File storeFile, long ts, String label) {
            super(file, storeFile, ts, label);
        }

        @Override
        OutputStream getStoreFileOutputStream() throws FileNotFoundException, IOException {
            return DefaultStoreEntry.createStoreFileOutputStream(this.getStoreFile());
        }

        @Override
        public InputStream getStoreFileInputStream() throws FileNotFoundException, IOException {
            ZipEntry entry;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(this.getStoreFile())));
            while ((entry = zis.getNextEntry()) != null) {
                if (!entry.getName().equals(this.getStoreFile().getName())) continue;
                return zis;
            }
            throw new FileNotFoundException();
        }
    }
}

