/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.localhistory.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openide.filesystems.FileUtil;

public class FileUtils {
    private FileUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File targetFile) throws IOException {
        if (sourceFile == null || targetFile == null) {
            throw new NullPointerException("sourceFile and targetFile must not be null");
        }
        BufferedInputStream inputStream = null;
        try {
            inputStream = FileUtils.createInputStream(sourceFile);
            FileUtils.copy(inputStream, targetFile);
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File file, OutputStream os) throws IOException {
        if (file == null) {
            throw new NullPointerException("file must not be null");
        }
        if (os == null) {
            throw new NullPointerException("output stream must not be null");
        }
        BufferedInputStream is = null;
        try {
            is = FileUtils.createInputStream(file);
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException ex) {}
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, File targetFile) throws IOException {
        if (inputStream == null || targetFile == null) {
            throw new NullPointerException("sourcStream and targetFile must not be null");
        }
        File directory = targetFile.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            throw new IOException("Could not create directory '" + directory + "'");
        }
        BufferedOutputStream outputStream = null;
        try {
            outputStream = FileUtils.createOutputStream(targetFile);
            try {
                byte[] buffer = new byte[32768];
                int readBytes = inputStream.read(buffer);
                while (readBytes > 0) {
                    ((OutputStream)outputStream).write(buffer, 0, readBytes);
                    readBytes = inputStream.read(buffer);
                }
            }
            catch (IOException ex) {
                targetFile.delete();
                throw ex;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException ex) {}
            }
            if (outputStream != null) {
                try {
                    ((OutputStream)outputStream).close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void deleteRecursively(File file) {
        File[] files;
        if (file == null) {
            return;
        }
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                FileUtils.deleteRecursively(files[i]);
            }
        }
        file.delete();
    }

    public static void renameFile(File orig, File dest) throws IOException {
        int i;
        boolean destExists = dest.exists();
        if (destExists) {
            for (i = 0; i < 3; ++i) {
                if (dest.delete()) {
                    destExists = false;
                    break;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        if (!destExists) {
            for (i = 0; i < 3; ++i) {
                if (orig.renameTo(dest)) {
                    return;
                }
                try {
                    Thread.sleep(71L);
                    continue;
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
        FileUtils.copyFile(orig, dest);
        for (i = 0; i < 3; ++i) {
            if (orig.delete()) {
                return;
            }
            try {
                Thread.sleep(71L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        throw new IOException("Can not delete: " + orig.getAbsolutePath());
    }

    private static BufferedInputStream createInputStream(File file) throws IOException {
        int retry = 0;
        while (true) {
            try {
                return new BufferedInputStream(new FileInputStream(file));
            }
            catch (IOException ex) {
                if (++retry > 7) {
                    throw ex;
                }
                try {
                    Thread.sleep(retry * 34);
                }
                catch (InterruptedException iex) {
                    throw ex;
                }
            }
        }
    }

    private static BufferedOutputStream createOutputStream(File file) throws IOException {
        int retry = 0;
        while (true) {
            try {
                return new BufferedOutputStream(new FileOutputStream(file));
            }
            catch (IOException ex) {
                if (++retry > 7) {
                    throw ex;
                }
                try {
                    Thread.sleep(retry * 34);
                }
                catch (InterruptedException iex) {
                    throw ex;
                }
            }
        }
    }
}

