/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.dtrace.collector.support;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.logging.Level;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.dtrace.collector.DtraceParser;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;

final class DtraceDataAndStackParser
extends DtraceParser {
    private static final boolean TRACE = Boolean.getBoolean("dlight.dns.parser.trace");
    private static PrintStream traceStream;
    private State state;
    private List<Object> currData;
    private long currSampleDuration;
    private List<CharSequence> currStack = new ArrayList<CharSequence>(32);
    private List<String> colNames;
    private int colCount;
    private final boolean isProfiler;
    private StackDataStorage sds;

    public DtraceDataAndStackParser(DataTableMetadata metadata) {
        this(metadata, null);
    }

    DtraceDataAndStackParser(DataTableMetadata metadata, StackDataStorage sds) {
        super(metadata);
        this.sds = sds;
        this.state = State.WAITING_DATA;
        this.colNames = metadata.getColumnNames();
        this.colCount = metadata.getColumnsCount();
        this.isProfiler = metadata.getName().equals("CallStack");
    }

    void setStackDataStorage(StackDataStorage stackStorage) {
        this.sds = stackStorage;
    }

    protected List<Object> processDataLine(String line) {
        return super.parse(line, this.colCount - 1);
    }

    @Override
    public DataRow process(String line) {
        if (TRACE) {
            traceStream.print(line);
            traceStream.print('\t');
            traceStream.println("" + (Object)((Object)this.state));
        }
        switch (this.state) {
            case WAITING_DATA: {
                if (line.length() == 0) {
                    return null;
                }
                DLightLogger.assertTrue((boolean)this.currStack.isEmpty());
                DLightLogger.assertFalse((boolean)Character.isWhitespace(line.charAt(0)), (String)"Data row shouldn't start with ' '");
                this.currData = this.processDataLine(line);
                if (this.isProfiler) {
                    try {
                        this.currSampleDuration = DataUtil.toLong((Object)this.currData.get(this.colCount - 2));
                    }
                    catch (NumberFormatException ex) {
                        DLightLogger.instance.log(Level.WARNING, "error parsing line " + line, ex);
                    }
                }
                this.state = State.IN_STACK;
                return null;
            }
            case IN_STACK: {
                if (line.length() > 0) {
                    line = line.trim();
                    if (this.isProfiler || !line.startsWith("libc.so.")) {
                        this.currStack.add(line);
                    }
                    return null;
                }
                Collections.reverse(this.currStack);
                long stackId = this.sds == null ? -1L : this.sds.putSample(this.currStack, DataUtil.toLong((Object)this.currData.get(0)), this.currSampleDuration);
                this.currStack.clear();
                this.state = State.WAITING_DATA;
                this.currData.add(stackId);
                return new DataRow(this.colNames, this.currData);
            }
        }
        return null;
    }

    static {
        if (TRACE) {
            String tmpDir = null;
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
                tmpDir = hostInfo.getTempDir();
            }
            catch (IOException ex) {
            }
            catch (CancellationException ex) {
                // empty catch block
            }
            if (tmpDir == null) {
                tmpDir = System.getProperty("java.io.tmpdir");
            }
            try {
                traceStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(tmpDir + "/dsp.log"), 32768));
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
                traceStream = System.err;
            }
        }
    }

    private static enum State {
        WAITING_DATA,
        IN_STACK;

    }
}

