/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.AppletXmlModel;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.filemodels.ParseErrorHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ui.StoreGroup;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class AppletProjectProperties
extends JCProjectProperties {
    private final ProjectKind kind;
    private AID defaultApplet;
    private AppletXmlModel appletXmlFileModel;
    private AppletXmlModel appletXmlUiModel;
    private DeploymentXmlModel deploymentXmlFileModel;
    private DeploymentXmlModel deploymentXmlUIModel;
    private StoreGroup group;
    public ButtonModel SEND_SCRIPT;
    public ComboBoxModel SCRIPTS = new DefaultComboBoxModel();
    private boolean scriptsPathBad;

    public AppletProjectProperties(JCProject project) {
        super(project);
        this.kind = project.kind();
        this.init(project);
    }

    public void setDefaultApplet(AID defaultApplet) {
        this.defaultApplet = defaultApplet;
    }

    public AID getDefaultApplet() {
        return this.defaultApplet;
    }

    private void init(JCProject project) {
        FileObject scriptsDir;
        this.group = new StoreGroup();
        PropertyEvaluator eval = project.evaluator();
        this.onInit(eval);
        this.SEND_SCRIPT = this.group.createToggleButtonModel(eval, "run.apdutool");
        String scriptsPath = this.kind.isApplet() ? "scripts/" : (this.kind == ProjectKind.WEB ? "html/" : null);
        FileObject fileObject = scriptsDir = scriptsPath == null ? null : project.getProjectDirectory().getFileObject(scriptsPath);
        if (scriptsDir != null) {
            Vector<String> scripts = new Vector<String>();
            for (FileObject fo : scriptsDir.getChildren()) {
                if (!"text/x-apduscr".equals(fo.getMIMEType())) continue;
                scripts.add(FileUtil.getRelativePath((FileObject)project.getProjectDirectory(), (FileObject)fo));
            }
            this.SCRIPTS = new DefaultComboBoxModel(scripts);
        } else {
            this.SCRIPTS = new DefaultComboBoxModel<Object>(new Object[]{NbBundle.getMessage(AppletProjectProperties.class, (String)"SCRIPTS_DIR_BAD", (Object)scriptsDir)});
            this.scriptsPathBad = true;
        }
        String mainScript = eval.getProperty("run.script");
        this.SCRIPTS.setSelectedItem(mainScript);
    }

    public DeploymentXmlModel getDeploymentXmlFileModel() {
        return this.deploymentXmlFileModel;
    }

    public void setDeploymentXmlFileModel(DeploymentXmlModel deploymentXmlFileModel) {
        this.deploymentXmlFileModel = deploymentXmlFileModel;
    }

    public DeploymentXmlModel getDeploymentXmlUIModel() {
        return this.deploymentXmlUIModel;
    }

    public void setDeploymentXmlUIModel(DeploymentXmlModel deploymentXmlUIModel) {
        this.deploymentXmlUIModel = deploymentXmlUIModel;
    }

    public void setAppletXmlFromFile(AppletXmlModel aidFromFile) {
        this.appletXmlFileModel = aidFromFile;
    }

    public void setAppletXmlFromUI(AppletXmlModel aidFromUI) {
        this.appletXmlUiModel = aidFromUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Boolean onStoreProperties(EditableProperties props) throws IOException {
        super.onStoreProperties(props);
        boolean result = this.doStoreProperties(props);
        if (result) {
            this.group.store(props);
            if (!this.scriptsPathBad) {
                if (this.SEND_SCRIPT.isSelected() && this.SCRIPTS.getSelectedItem() != null) {
                    props.setProperty("run.script", (String)this.SCRIPTS.getSelectedItem());
                } else {
                    props.remove((Object)"run.script");
                }
            }
            if (this.kind.isApplet()) {
                this.storeDeploymentXml();
                this.storeAppletXML();
                AppletXmlModel xmlModel = this.appletXmlUiModel;
                if (xmlModel == null) {
                    FileObject fo = this.project.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
                    if (fo == null) {
                        fo = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)"APPLET-INF/applet.xml");
                    }
                    if (fo != null && System.getProperty("JCProject.test") == null) {
                        InputStream in = fo.getInputStream();
                        try {
                            PEH peh = new PEH();
                            xmlModel = new AppletXmlModel(in, (ParseErrorHandler)peh);
                        }
                        finally {
                            in.close();
                        }
                    }
                }
            }
        }
        return result;
    }

    protected boolean doStoreProperties(EditableProperties props) throws IOException {
        return true;
    }

    protected void onInit(PropertyEvaluator eval) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeAppletXML() throws IOException {
        boolean shouldStore;
        boolean bl = shouldStore = this.appletXmlUiModel != null && !this.appletXmlUiModel.equals((Object)this.appletXmlFileModel);
        if (shouldStore) {
            FileObject fo = this.project.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
            FileLock lock = fo.lock();
            OutputStream out = fo.getOutputStream(lock);
            PrintWriter writer = new PrintWriter(out);
            try {
                writer.println(this.appletXmlUiModel.toXml());
            }
            finally {
                writer.close();
                out.close();
                lock.releaseLock();
            }
            this.appletXmlFileModel = this.appletXmlUiModel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeDeploymentXml() throws IOException {
        boolean shouldStore;
        boolean bl = shouldStore = this.deploymentXmlUIModel != null && !this.deploymentXmlUIModel.equals((Object)this.deploymentXmlFileModel);
        if (shouldStore) {
            FileObject fo = this.project.getProjectDirectory().getFileObject("nbproject/deployment.xml");
            if (fo == null) {
                fo = FileUtil.createData((FileObject)this.project.getProjectDirectory(), (String)"nbproject/deployment.xml");
            }
            FileLock lock = fo.lock();
            OutputStream out = fo.getOutputStream(lock);
            PrintWriter writer = new PrintWriter(out);
            try {
                writer.println(this.deploymentXmlUIModel.toXml());
            }
            finally {
                writer.close();
                out.close();
                lock.releaseLock();
            }
            this.deploymentXmlUIModel = this.deploymentXmlFileModel;
        }
    }

    private static class PEH
    implements ParseErrorHandler {
        private PEH() {
        }

        public void handleError(IOException ioe) throws IOException {
            throw ioe;
        }

        public void handleBadAIDError(IllegalArgumentException aidParseError, String aidString) {
        }

        public void unrecognizedElementEncountered(String elementName) throws IOException {
        }
    }
}

