/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.AID;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.table.DefaultTableModel;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.JCProjectProperties;
import org.netbeans.modules.javacard.project.customizer.AppletProjectProperties;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public final class ClassicAppletProjectProperties
extends AppletProjectProperties {
    private AID originalPackageAID;
    private AID packageAID;
    private boolean useMyProxies;
    private boolean wasUseMyProxies;
    public static final String PROXY_SOURCE_DIR = "proxies";

    public ClassicAppletProjectProperties(JCProject project) {
        super(project);
    }

    public AID getPackageAID() {
        return this.packageAID;
    }

    public void setPackageAID(AID aid) {
        this.packageAID = aid;
    }

    public boolean isUseMyProxies() {
        return this.useMyProxies;
    }

    public void setUseMyProxies(boolean useMyProxies) {
        this.useMyProxies = useMyProxies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rewriteManifest() throws IOException {
        FileObject manifestFo = this.project.getProjectDirectory().getFileObject("META-INF/MANIFEST.MF");
        Manifest manifest = null;
        if (manifestFo == null) {
            Logger.getLogger(ClassicAppletProjectProperties.class.getName()).log(Level.INFO, "Manifest missing for project {0}.  Recreating.", this.project.getProjectDirectory().getPath());
            manifestFo = this.project.getProjectDirectory().createData("META-INF/MANIFEST.MF");
            manifest = new Manifest();
            Attributes a = manifest.getMainAttributes();
            a.putValue("Runtime-Descriptor-Version", "3.0");
            a.putValue("Application-Type", this.project.kind().getManifestApplicationType());
        } else {
            InputStream in = manifestFo.getInputStream();
            try {
                manifest = new Manifest(in);
            }
            finally {
                in.close();
            }
        }
        manifest.getMainAttributes().putValue("Classic-Package-AID", this.packageAID.toString());
        FileLock lock = manifestFo.lock();
        OutputStream out = manifestFo.getOutputStream(lock);
        try {
            manifest.write(out);
        }
        finally {
            out.close();
            lock.releaseLock();
        }
    }

    @Override
    protected void onBeforeStoreProperties() throws IOException {
        super.onBeforeStoreProperties();
        if (this.wasUseMyProxies != this.useMyProxies || this.useMyProxies && this.project.getProjectDirectory().getFileObject(PROXY_SOURCE_DIR) == null) {
            ClassicAppletProjectProperties.updateProxies(this, this.useMyProxies, this.SOURCE_ROOTS_MODEL);
        }
    }

    static void updateProxies(JCProjectProperties props, boolean useMyProxies, DefaultTableModel srcRootsModel) throws IOException {
        FileObject root = props.getProject().getProjectDirectory();
        FileObject proxies = root.getFileObject(PROXY_SOURCE_DIR);
        boolean created = false;
        if (useMyProxies) {
            if (proxies == null) {
                proxies = root.createFolder(PROXY_SOURCE_DIR);
                created = true;
            }
            int max = props.SOURCE_ROOTS_MODEL.getRowCount();
            boolean found = false;
            File proxiesFile = FileUtil.toFile((FileObject)proxies);
            String proxiesPath = proxiesFile.getAbsolutePath();
            for (int i = 0; i < max; ++i) {
                File f = (File)srcRootsModel.getValueAt(i, 0);
                if (!f.getAbsolutePath().equals(proxiesPath)) continue;
                found = true;
                break;
            }
            if (!found) {
                String label = NbBundle.getMessage(ClassicAppletProjectProperties.class, (String)"LBL_PROXY_SOURCES");
                srcRootsModel.addRow(new Object[]{proxiesFile, label});
            }
        } else if (proxies != null) {
            File f = FileUtil.toFile((FileObject)proxies);
            int max = srcRootsModel.getRowCount();
            Vector<Vector> v = srcRootsModel.getDataVector();
            int toRemove = -1;
            for (int i = 0; i < max; ++i) {
                File test = (File)v.elementAt(i).elementAt(0);
                boolean match = test.getAbsolutePath().equals(f.getAbsolutePath());
                if (!match) continue;
                toRemove = i;
                break;
            }
            if (toRemove != -1) {
                srcRootsModel.removeRow(toRemove);
            }
        }
        if (created || proxies != null && ClassicAppletProjectProperties.isEmpty(proxies)) {
            ClassicAppletProjectProperties.offerToGenerateProxies(props.getProject());
        }
    }

    private static boolean isEmpty(FileObject proxies) {
        return false;
    }

    private static void offerToGenerateProxies(JCProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        if (Boolean.getBoolean("JCProject.test")) {
            return;
        }
        assert (project.kind().isClassic());
        EventQueue.invokeLater(new ProxyGenerator(project));
    }

    @Override
    protected boolean doStoreProperties(EditableProperties props) throws IOException {
        boolean result = false;
        result = this.wasUseMyProxies != this.useMyProxies;
        if (result) {
            props.setProperty("use.my.proxies", String.valueOf(this.useMyProxies));
            if (this.useMyProxies) {
                props.setProperty("src.proxies.dir", PROXY_SOURCE_DIR);
            } else if (PROXY_SOURCE_DIR.equals(props.getProperty("src.proxies.dir"))) {
                props.remove((Object)"src.proxies.dir");
                props.remove((Object)"use.my.proxies");
            }
        }
        if (result |= this.packageAID != null && !this.packageAID.equals((Object)this.originalPackageAID)) {
            props.setProperty("package.aid", this.packageAID.toString());
            this.rewriteManifest();
        }
        return result;
    }

    @Override
    protected void onInit(PropertyEvaluator eval) {
        this.wasUseMyProxies = this.useMyProxies = Boolean.parseBoolean(this.project.evaluator().getProperty("use.my.proxies"));
        String aidString = this.project.evaluator().getProperty("package.aid");
        if (aidString != null) {
            try {
                this.originalPackageAID = this.packageAID = AID.parse((String)aidString);
            }
            catch (IllegalArgumentException e) {
                Logger.getLogger(ClassicAppletProjectProperties.class.getName()).log(Level.INFO, "Bad classic package aid in " + this.project.getProjectDirectory().getPath() + ": " + aidString, e);
            }
        }
    }

    private static final class ProxyGenerator
    implements Runnable {
        private final JCProject project;

        public ProxyGenerator(JCProject project) {
            this.project = project;
        }

        @Override
        public void run() {
            if (EventQueue.isDispatchThread()) {
                String msg = NbBundle.getMessage(ClassicAppletProjectProperties.class, (String)"ASK_GENERATE_PROXIES");
                String title = NbBundle.getMessage(ClassicAppletProjectProperties.class, (String)"TITLE_ASK_GENERATE_PROXIES");
                NotifyDescriptor.Confirmation nd = new NotifyDescriptor.Confirmation((Object)msg, title, 0);
                if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)nd))) {
                    RequestProcessor.getDefault().post((Runnable)this);
                }
            } else {
                FileObject buildFo = this.project.getProjectDirectory().getFileObject("build.xml");
                if (buildFo != null) {
                    try {
                        ExecutorTask task = ActionUtils.runTarget((FileObject)buildFo, (String[])new String[]{"generate-sio-proxies"}, (Properties)new Properties());
                        task.getInputOutput().select();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }
}

