/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.project.customizer;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.FileModelEntry;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javacard.common.AIDPanel;
import org.netbeans.modules.javacard.common.GuiUtils;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.project.customizer.AppletCustomizer;
import org.openide.awt.HtmlRenderer;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CustomizeDeploymentPanel
extends JPanel
implements ChangeListener,
ListSelectionListener,
DocumentListener,
ListCellRenderer,
ActionListener {
    private final ChangeSupport supp = new ChangeSupport((Object)this);
    private DeploymentXmlAppletEntry entry;
    private AID appletAid;
    private String classname;
    private Node node;
    private String problem;
    private JButton addButton;
    private AIDPanel aidPnl;
    private JLabel appletInstanceLabel;
    private JTextField deploymentParamsField;
    private JLabel deploymentParamsLabel;
    private JList instancesList;
    private JScrollPane instancesPane;
    private JScrollPane instructionsPane;
    private JTextArea instructionsTextArea;
    private JButton removeButton;
    private JLabel titleLabel;
    boolean inSetEntry;
    private DeploymentXmlInstanceEntry instance;
    boolean inSetInstance;
    private final HtmlRenderer.Renderer r = HtmlRenderer.createRenderer();

    public CustomizeDeploymentPanel(Node n) {
        this.node = n;
        this.initComponents();
        this.instancesList.setCellRenderer(this);
        this.instancesList.getSelectionModel().addListSelectionListener(this);
        this.classname = (String)n.getLookup().lookup(String.class);
        if (this.classname != null) {
            this.aidPnl.setClassFqn(this.classname);
            this.titleLabel.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CUSTOMIZE_INSTANCES", (Object)this.classname));
        }
        this.appletAid = (AID)n.getValue("applet-AID");
        GuiUtils.prepareContainer((Container)this);
        GuiUtils.filterNonHexadecimalKeys((JTextComponent)this.deploymentParamsField);
        this.deploymentParamsField.getDocument().addDocumentListener(this);
        DeploymentXmlAppletEntry e = (DeploymentXmlAppletEntry)n.getValue("deploymentInfo");
        if (e != null) {
            this.setEntry((DeploymentXmlAppletEntry)e.clone());
        }
        this.aidPnl.addChangeListener((ChangeListener)this);
        HelpCtx.setHelpIDString((JComponent)this, (String)"org.netbeans.modules.javacard.ClassicAppletAddInstanceApplet");
        this.instructionsPane.getViewport().setOpaque(false);
        this.instructionsTextArea.getCaret().setVisible(false);
    }

    public void saveChanges() {
        if (this.entry != null && this.node != null) {
            this.node.setValue("deploymentInfo", (Object)this.entry);
        }
    }

    private void change() {
        String prb;
        if (this.inSetInstance) {
            return;
        }
        String deployParams = this.deploymentParamsField.getText().trim();
        if (deployParams.length() > 0) {
            if (deployParams.length() % 2 != 0) {
                this.setProblem(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"ODD_NUMBER_OF_DIGITS"));
                return;
            }
            try {
                byte[] b = new byte[deployParams.length() / 2 + 1];
                Utils.getByteArrayForString((String)deployParams, (byte[])b, (int)0);
            }
            catch (Exception e) {
                this.setProblem(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"ILLEGAL_HEX", (Object)deployParams));
                return;
            }
        }
        AID aid = this.aidPnl.getAID();
        if (this.entry != null) {
            HashSet<AID> aids = new HashSet<AID>();
            for (DeploymentXmlInstanceEntry e : this.entry.getData()) {
                AID a;
                if (e == this.instance || (a = e.getInstanceAID()) == null) continue;
                aids.add(e.getInstanceAID());
            }
            if (aids.contains(aid)) {
                this.setProblem(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"AID_IN_USE", (Object)aid));
                return;
            }
        }
        if ((prb = this.aidPnl.getProblem()) == null && this.instance != null && aid != null) {
            this.instance.setDeploymentParams(deployParams);
            this.instance.setInstanceAID(aid);
        }
        this.setProblem(prb);
    }

    public String getProblem() {
        return this.problem;
    }

    private void setProblem(String problem) {
        this.problem = problem;
        boolean isProblem = this.isProblem();
        this.addButton.setEnabled(!isProblem);
        this.removeButton.setEnabled(!isProblem);
        this.instancesList.setEnabled(!isProblem);
        this.fireChange();
    }

    public boolean isProblem() {
        return this.problem != null && this.problem.trim().length() > 0;
    }

    private void initComponents() {
        this.titleLabel = new JLabel();
        this.instructionsPane = new JScrollPane();
        this.instructionsTextArea = new JTextArea();
        this.instancesPane = new JScrollPane();
        this.instancesList = new JList();
        this.aidPnl = new AIDPanel();
        this.appletInstanceLabel = new JLabel();
        this.deploymentParamsLabel = new JLabel();
        this.deploymentParamsField = new JTextField();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(this.titleLabel.getFont().getStyle() | 1));
        this.titleLabel.setLabelFor(this.instructionsTextArea);
        this.titleLabel.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.titleLabel.text", (Object[])new Object[0]));
        this.titleLabel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0, 0, 0)));
        this.instructionsPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.instructionsPane.setHorizontalScrollBarPolicy(31);
        this.instructionsPane.setViewportBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.instructionsPane.setOpaque(false);
        this.instructionsTextArea.setBackground(UIManager.getDefaults().getColor("control"));
        this.instructionsTextArea.setColumns(20);
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setFont(this.aidPnl.getFont());
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setRows(5);
        this.instructionsTextArea.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.instructionsTextArea.text", (Object[])new Object[0]));
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        this.instructionsPane.setViewportView(this.instructionsTextArea);
        this.instancesList.setSelectionMode(0);
        this.instancesList.setToolTipText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.instancesList.toolTipText", (Object[])new Object[0]));
        this.instancesList.setEnabled(false);
        this.instancesPane.setViewportView(this.instancesList);
        this.aidPnl.setEnabled(false);
        this.aidPnl.setTitle(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.aidPnl.title", (Object[])new Object[0]));
        this.appletInstanceLabel.setFont(this.appletInstanceLabel.getFont().deriveFont(this.appletInstanceLabel.getFont().getStyle() | 1));
        this.appletInstanceLabel.setLabelFor(this.instancesList);
        this.appletInstanceLabel.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.appletInstanceLabel.text", (Object[])new Object[0]));
        this.appletInstanceLabel.setEnabled(false);
        this.deploymentParamsLabel.setFont(this.deploymentParamsLabel.getFont().deriveFont(this.deploymentParamsLabel.getFont().getStyle() | 1));
        this.deploymentParamsLabel.setLabelFor(this.deploymentParamsField);
        this.deploymentParamsLabel.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.deploymentParamsLabel.text", (Object[])new Object[0]));
        this.deploymentParamsLabel.setEnabled(false);
        this.deploymentParamsField.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.deploymentParamsField.text", (Object[])new Object[0]));
        this.deploymentParamsField.setToolTipText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.deploymentParamsField.toolTipText", (Object[])new Object[0]));
        this.deploymentParamsField.setEnabled(false);
        this.addButton.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.addButton.text", (Object[])new Object[0]));
        this.addButton.setToolTipText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.addButton.toolTipText", (Object[])new Object[0]));
        this.addButton.setEnabled(false);
        this.addButton.addActionListener(this);
        this.removeButton.setText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.removeButton.text", (Object[])new Object[0]));
        this.removeButton.setToolTipText(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"CustomizeDeploymentPanel.removeButton.toolTipText", (Object[])new Object[0]));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(this);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.instructionsPane, -1, 615, Short.MAX_VALUE).add((Component)this.titleLabel).add((Component)this.appletInstanceLabel).add((Component)this.deploymentParamsLabel).add((Component)this.deploymentParamsField, -1, 615, Short.MAX_VALUE).add((Component)this.aidPnl, -1, 615, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.instancesPane, -1, 502, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.removeButton).add((Component)this.addButton)))).addContainerGap()));
        layout.linkSize(new Component[]{this.addButton, this.removeButton}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.titleLabel).addPreferredGap(0).add((Component)this.instructionsPane, -2, 93, -2).addPreferredGap(1).add((Component)this.appletInstanceLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.instancesPane, -1, 105, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.deploymentParamsLabel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.addButton).addPreferredGap(0).add((Component)this.removeButton))).addPreferredGap(0).add((Component)this.deploymentParamsField, -2, -1, -2).addPreferredGap(1).add((Component)this.aidPnl, -2, -1, -2).addContainerGap()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.addButton) {
            this.addButtonActionPerformed(evt);
        } else if (evt.getSource() == this.removeButton) {
            this.removeButtonActionPerformed(evt);
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        AID aid = this.nextUniqueAid();
        String params = this.deploymentParamsField.getText().trim();
        int sz = this.instancesList.getModel().getSize();
        DeploymentXmlInstanceEntry e = new DeploymentXmlInstanceEntry(aid, params, sz);
        this.entry.add((FileModelEntry)e);
        ((DefaultListModel)this.instancesList.getModel()).addElement(e);
        this.instancesList.setSelectedIndex(sz);
        this.deploymentParamsField.requestFocus();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        Object o = this.instancesList.getSelectedValue();
        if (o != null && o instanceof DeploymentXmlInstanceEntry) {
            DeploymentXmlInstanceEntry e = (DeploymentXmlInstanceEntry)o;
            int ix = ((DefaultListModel)this.instancesList.getModel()).indexOf(e);
            this.entry.remove(e);
            ((DefaultListModel)this.instancesList.getModel()).removeElement(e);
            int size = this.instancesList.getModel().getSize();
            if (size > 0) {
                if (ix < size - 1) {
                    this.instancesList.setSelectedIndex(ix);
                } else {
                    this.instancesList.setSelectedIndex(size - 1);
                }
                this.instancesList.requestFocus();
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void enabled(boolean val) {
        this.addButton.setEnabled(val);
        this.removeButton.setEnabled(val);
        this.appletInstanceLabel.setEnabled(val);
        this.instancesList.setEnabled(val);
        this.aidPnl.setEnabled(val);
        this.deploymentParamsField.setEnabled(val);
        this.deploymentParamsLabel.setEnabled(val);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.instancesList.requestFocusInWindow();
    }

    public void removeChangeListener(ChangeListener arg0) {
        this.supp.removeChangeListener(arg0);
    }

    private void fireChange() {
        this.supp.fireChange();
    }

    public void addChangeListener(ChangeListener arg0) {
        this.supp.addChangeListener(arg0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEntry(DeploymentXmlAppletEntry entry) {
        this.inSetEntry = true;
        try {
            this.entry = entry;
            DefaultListModel<DeploymentXmlInstanceEntry> mdl = new DefaultListModel<DeploymentXmlInstanceEntry>();
            for (DeploymentXmlInstanceEntry e : entry.getData()) {
                mdl.addElement(e);
            }
            this.instancesList.setEnabled(entry != null);
            this.instancesList.setModel(mdl);
            if (this.instancesList.getSelectedValue() == null && mdl.getSize() > 0) {
                this.instancesList.setSelectedIndex(0);
            }
            this.instancesList.requestFocus();
        }
        finally {
            this.inSetEntry = false;
        }
        this.addButton.setEnabled(true);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.change();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object o = this.instancesList.getSelectedValue();
        if (o instanceof DeploymentXmlInstanceEntry) {
            this.enabled(true);
            this.setInstance((DeploymentXmlInstanceEntry)o);
            DefaultListModel mdl = (DefaultListModel)this.instancesList.getModel();
            int ix = mdl.indexOf(o);
            this.aidPnl.setTitle(NbBundle.getMessage(CustomizeDeploymentPanel.class, (String)"SPECIFIC_INSTANCE_AID", (Object)(ix + 1)));
        } else {
            this.enabled(false);
            this.addButton.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInstance(DeploymentXmlInstanceEntry i) {
        this.inSetInstance = true;
        try {
            this.instance = i;
            this.aidPnl.setAID(i.getInstanceAID());
            this.deploymentParamsField.setText(i.getDeploymentParams());
        }
        finally {
            this.inSetInstance = false;
        }
        this.change();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.change();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.change();
    }

    private AID findLastAID() {
        Object o;
        AID aid = null;
        if (this.instancesList.getModel().getSize() > 0 && (o = this.instancesList.getModel().getElementAt(this.instancesList.getModel().getSize() - 1)) instanceof DeploymentXmlInstanceEntry) {
            aid = ((DeploymentXmlInstanceEntry)o).getInstanceAID();
        }
        if (aid == null) {
            aid = this.appletAid;
        }
        if (aid == null) {
            aid = Utils.generateInstanceAid((String)this.classname, (String)this.classname);
        }
        return aid;
    }

    private AID nextUniqueAid() {
        AID aid = this.findLastAID();
        HashSet<AID> used = new HashSet<AID>();
        if (this.entry != null) {
            for (DeploymentXmlInstanceEntry e : this.entry.getData()) {
                AID usedAid = e.getInstanceAID();
                if (usedAid == null) continue;
                used.add(usedAid);
            }
        }
        while (used.contains(aid)) {
            aid = aid.increment();
        }
        return aid;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String val;
        if (value instanceof DeploymentXmlInstanceEntry) {
            DeploymentXmlInstanceEntry e = (DeploymentXmlInstanceEntry)value;
            AID aid = e.getInstanceAID();
            String params = e.getDeploymentParams();
            StringBuilder sb = new StringBuilder("<html>");
            if (aid == null) {
                sb.append("<s><font color='!nb.errorForeground'>");
                sb.append(NbBundle.getMessage(AppletCustomizer.class, (String)"LBL_INVALID_AID"));
                sb.append("</s></font>");
            } else {
                sb.append(aid.toString());
            }
            if (params != null && params.length() > 0) {
                sb.append("<font color='!controlShadow'>");
                sb.append(" (");
                sb.append(params);
                sb.append(')');
            }
            val = sb.toString();
        } else {
            val = value == null ? "" : value.toString();
        }
        return this.r.getListCellRendererComponent(list, (Object)val, index, isSelected, cellHasFocus);
    }
}

