/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.jdi;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.debugger.jpda.JDIExceptionReporter;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.jdi.ClassNotPreparedExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.InternalExceptionWrapper;
import org.netbeans.modules.debugger.jpda.jdi.VMDisconnectedExceptionWrapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public final class ClassTypeWrapper {
    private ClassTypeWrapper() {
    }

    public static List<InterfaceType> allInterfaces0(ClassType classType) throws ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "allInterfaces", "JDI CALL: com.sun.jdi.ClassType({0}).allInterfaces()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<InterfaceType> list = classType.allInterfaces();
            object = list;
            List<InterfaceType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            List<InterfaceType> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            List<InterfaceType> list = Collections.emptyList();
            return list;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            object = classNotPreparedException;
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "allInterfaces", object);
            }
        }
    }

    public static List<InterfaceType> allInterfaces(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "allInterfaces", "JDI CALL: com.sun.jdi.ClassType({0}).allInterfaces()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<InterfaceType> list = classType.allInterfaces();
            object = list;
            List<InterfaceType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            object = classNotPreparedException;
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "allInterfaces", object);
            }
        }
    }

    public static Method concreteMethodByName(ClassType classType, String string, String string2) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "concreteMethodByName", "JDI CALL: com.sun.jdi.ClassType({0}).concreteMethodByName({1}, {2})", new Object[]{classType, string, string2});
        }
        Object object = null;
        try {
            Method method = classType.concreteMethodByName(string, string2);
            object = method;
            Method method2 = method;
            return method2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            object = classNotPreparedException;
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "concreteMethodByName", object);
            }
        }
    }

    public static List<InterfaceType> interfaces0(ClassType classType) throws ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "interfaces", "JDI CALL: com.sun.jdi.ClassType({0}).interfaces()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<InterfaceType> list = classType.interfaces();
            object = list;
            List<InterfaceType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            List<InterfaceType> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            List<InterfaceType> list = Collections.emptyList();
            return list;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            object = classNotPreparedException;
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "interfaces", object);
            }
        }
    }

    public static List<InterfaceType> interfaces(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "interfaces", "JDI CALL: com.sun.jdi.ClassType({0}).interfaces()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<InterfaceType> list = classType.interfaces();
            object = list;
            List<InterfaceType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            object = classNotPreparedException;
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "interfaces", object);
            }
        }
    }

    public static Value invokeMethod(ClassType classType, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "invokeMethod", "JDI CALL: com.sun.jdi.ClassType({0}).invokeMethod({1}, {2}, {3}, {4})", new Object[]{classType, threadReference, method, list, n});
        }
        Object object = null;
        try {
            Value value = classType.invokeMethod(threadReference, method, list, n);
            object = value;
            Value value2 = value;
            return value2;
        }
        catch (InternalException internalException) {
            if (internalException.errorCode() == 502) {
                InternalException internalException2 = (InternalException)Exceptions.attachLocalizedMessage((Throwable)internalException, (String)NbBundle.getMessage(JPDADebuggerImpl.class, (String)"JDWPError502"));
                Exceptions.printStackTrace((Throwable)internalException2);
                Value value = null;
                return value;
            }
            try {
                throw internalException;
            }
            catch (InternalException internalException3) {
                object = internalException3;
                JDIExceptionReporter.report(internalException3);
                throw new InternalExceptionWrapper(internalException3);
            }
            catch (VMDisconnectedException vMDisconnectedException) {
                object = vMDisconnectedException;
                throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
            }
            catch (InvalidTypeException invalidTypeException) {
                object = invalidTypeException;
                throw invalidTypeException;
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                object = classNotLoadedException;
                throw classNotLoadedException;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                object = incompatibleThreadStateException;
                throw incompatibleThreadStateException;
            }
            catch (InvocationException invocationException) {
                object = invocationException;
                throw invocationException;
            }
            catch (Error error) {
                object = error;
                throw error;
            }
            catch (RuntimeException runtimeException) {
                object = runtimeException;
                throw runtimeException;
            }
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "invokeMethod", object);
            }
        }
    }

    public static boolean isEnum0(ClassType classType) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "isEnum", "JDI CALL: com.sun.jdi.ClassType({0}).isEnum()", new Object[]{classType});
        }
        Serializable serializable = null;
        try {
            boolean bl = classType.isEnum();
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            boolean bl = false;
            return bl;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            boolean bl = false;
            return bl;
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "isEnum", serializable);
            }
        }
    }

    public static boolean isEnum(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "isEnum", "JDI CALL: com.sun.jdi.ClassType({0}).isEnum()", new Object[]{classType});
        }
        Serializable serializable = null;
        try {
            boolean bl = classType.isEnum();
            serializable = Boolean.valueOf(bl);
            boolean bl2 = bl;
            return bl2;
        }
        catch (InternalException internalException) {
            serializable = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            serializable = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (Error error) {
            serializable = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            serializable = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "isEnum", serializable);
            }
        }
    }

    public static ObjectReference newInstance(ClassType classType, ThreadReference threadReference, Method method, List<? extends Value> list, int n) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "newInstance", "JDI CALL: com.sun.jdi.ClassType({0}).newInstance({1}, {2}, {3}, {4})", new Object[]{classType, threadReference, method, list, n});
        }
        Object object = null;
        try {
            ObjectReference objectReference = classType.newInstance(threadReference, method, list, n);
            object = objectReference;
            ObjectReference objectReference2 = objectReference;
            return objectReference2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (InvalidTypeException invalidTypeException) {
            object = invalidTypeException;
            throw invalidTypeException;
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            object = classNotLoadedException;
            throw classNotLoadedException;
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            object = incompatibleThreadStateException;
            throw incompatibleThreadStateException;
        }
        catch (InvocationException invocationException) {
            object = invocationException;
            throw invocationException;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "newInstance", object);
            }
        }
    }

    public static void setValue(ClassType classType, Field field, Value value) throws InvalidTypeException, ClassNotLoadedException, InternalExceptionWrapper, VMDisconnectedExceptionWrapper, ClassNotPreparedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "setValue", "JDI CALL: com.sun.jdi.ClassType({0}).setValue({1}, {2})", new Object[]{classType, field, value});
        }
        try {
            classType.setValue(field, value);
        }
        catch (InternalException internalException) {
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw new ClassNotPreparedExceptionWrapper(classNotPreparedException);
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "setValue", JDIExceptionReporter.RET_VOID);
            }
        }
    }

    public static List<ClassType> subclasses0(ClassType classType) {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "subclasses", "JDI CALL: com.sun.jdi.ClassType({0}).subclasses()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<ClassType> list = classType.subclasses();
            object = list;
            List<ClassType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            List<ClassType> list = Collections.emptyList();
            return list;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            List<ClassType> list = Collections.emptyList();
            return list;
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "subclasses", object);
            }
        }
    }

    public static List<ClassType> subclasses(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "subclasses", "JDI CALL: com.sun.jdi.ClassType({0}).subclasses()", new Object[]{classType});
        }
        Object object = null;
        try {
            List<ClassType> list = classType.subclasses();
            object = list;
            List<ClassType> list2 = list;
            return list2;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "subclasses", object);
            }
        }
    }

    public static ClassType superclass(ClassType classType) throws InternalExceptionWrapper, VMDisconnectedExceptionWrapper {
        if (JDIExceptionReporter.isLoggable()) {
            JDIExceptionReporter.logCallStart("com.sun.jdi.ClassType", "superclass", "JDI CALL: com.sun.jdi.ClassType({0}).superclass()", new Object[]{classType});
        }
        Object object = null;
        try {
            ClassType classType2 = classType.superclass();
            object = classType2;
            ClassType classType3 = classType2;
            return classType3;
        }
        catch (InternalException internalException) {
            object = internalException;
            JDIExceptionReporter.report(internalException);
            throw new InternalExceptionWrapper(internalException);
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            object = vMDisconnectedException;
            throw new VMDisconnectedExceptionWrapper(vMDisconnectedException);
        }
        catch (Error error) {
            object = error;
            throw error;
        }
        catch (RuntimeException runtimeException) {
            object = runtimeException;
            throw runtimeException;
        }
        finally {
            if (JDIExceptionReporter.isLoggable()) {
                JDIExceptionReporter.logCallEnd("com.sun.jdi.ClassType", "superclass", object);
            }
        }
    }
}

