/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.j2ee.dd.api.ejb.CmrField;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbRelation;
import org.netbeans.modules.j2ee.dd.api.ejb.Entity;
import org.netbeans.modules.j2ee.dd.api.ejb.Relationships;
import org.netbeans.modules.j2ee.ddloaders.multiview.EjbJarMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.multiview.RelationshipHelper;
import org.netbeans.modules.j2ee.ddloaders.multiview.Utils;
import org.netbeans.modules.j2ee.ddloaders.multiview.ui.CmpRelationshipsForm;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.Utilities;

public class CmpRelationshipsDialogHelper {
    private static final String CLASS_COLLECTION = "java.util.Collection";
    private static final String CLASS_SET = "java.util.Set";
    private static final String[] FILED_TYPE_ITEMS = new String[]{"java.util.Collection", "java.util.Set"};
    private final EjbJarMultiViewDataObject dataObject;
    private final EjbJar ejbJar;
    private JTextField relationshipNameTextField;
    private JTextArea descriptionTextArea;
    private Vector entityNames;
    private RelationshipDialogActionListener listener;
    FormRoleHelper roleA = new FormRoleHelper();
    FormRoleHelper roleB = new FormRoleHelper();

    public CmpRelationshipsDialogHelper(EjbJarMultiViewDataObject ejbJarMultiViewDataObject, EjbJar ejbJar) {
        this.dataObject = ejbJarMultiViewDataObject;
        this.ejbJar = ejbJar;
    }

    public boolean showCmpRelationshipsDialog(String string, EjbRelation ejbRelation) {
        RelationshipHelper relationshipHelper;
        CmpRelationshipsForm cmpRelationshipsForm = this.initForm();
        JLabel jLabel = cmpRelationshipsForm.getErrorLabel();
        if (ejbRelation != null) {
            relationshipHelper = new RelationshipHelper(ejbRelation);
            this.populateFormFields(relationshipHelper);
        } else {
            relationshipHelper = null;
        }
        this.listener.validate();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)cmpRelationshipsForm, string);
        dialogDescriptor.setOptionType(2);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setFocusTraversalPolicy(cmpRelationshipsForm.createFocusTraversalPolicy());
        DialogListener dialogListener = new DialogListener(jLabel, dialogDescriptor);
        cmpRelationshipsForm.getFieldNameTextField().getDocument().addDocumentListener(dialogListener);
        cmpRelationshipsForm.getFieldNameTextField2().getDocument().addDocumentListener(dialogListener);
        cmpRelationshipsForm.getCreateCmrFieldCheckBox().addActionListener(dialogListener);
        cmpRelationshipsForm.getCreateCmrFieldCheckBox2().addActionListener(dialogListener);
        cmpRelationshipsForm.getRoleNameTextField().getDocument().addDocumentListener(dialogListener);
        cmpRelationshipsForm.getRoleNameTextField2().getDocument().addDocumentListener(dialogListener);
        cmpRelationshipsForm.getEjbComboBox().addActionListener(dialogListener);
        cmpRelationshipsForm.getEjbComboBox2().addActionListener(dialogListener);
        dialogListener.validateFields();
        if (this.dataObject.getEjbJar().getEnterpriseBeans().getEntity().length == 0) {
            dialogDescriptor.setValid(false);
        }
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            if (relationshipHelper == null) {
                Relationships relationships = this.ejbJar.getSingleRelationships();
                if (relationships == null) {
                    relationships = this.ejbJar.newRelationships();
                    this.ejbJar.setRelationships(relationships);
                }
                relationshipHelper = new RelationshipHelper(relationships);
            }
            this.processResult(relationshipHelper);
            return true;
        }
        return false;
    }

    private Vector getEntities() {
        Vector<String> vector = new Vector<String>();
        Entity[] entityArray = this.ejbJar.getEnterpriseBeans().getEntity();
        for (int i = 0; i < entityArray.length; ++i) {
            Entity entity = entityArray[i];
            if (entity.getLocal() == null) continue;
            vector.add(entity.getEjbName());
        }
        return vector;
    }

    private void processResult(RelationshipHelper relationshipHelper) {
        String string = this.relationshipNameTextField.getText().trim();
        if (string.length() == 0) {
            string = this.roleA.getEjbName() + "-" + this.roleB.getEjbName();
        }
        relationshipHelper.setRelationName(string);
        relationshipHelper.setDescription(this.descriptionTextArea.getText().trim());
        this.roleA.processResult(relationshipHelper.roleA);
        this.roleB.processResult(relationshipHelper.roleB);
    }

    private void populateFormFields(RelationshipHelper relationshipHelper) {
        this.relationshipNameTextField.setText(relationshipHelper.getRelationName());
        this.descriptionTextArea.setText(relationshipHelper.getDescription());
        this.roleA.populateFormFields(relationshipHelper.roleA);
        this.roleB.populateFormFields(relationshipHelper.roleB);
    }

    private Entity getEntity(String string) {
        if (string == null) {
            return null;
        }
        Entity[] entityArray = this.ejbJar.getEnterpriseBeans().getEntity();
        for (int i = 0; i < entityArray.length; ++i) {
            Entity entity = entityArray[i];
            if (!string.equals(entity.getEjbName())) continue;
            return entity;
        }
        return null;
    }

    private CmpRelationshipsForm initForm() {
        this.listener = new RelationshipDialogActionListener();
        this.entityNames = this.getEntities();
        CmpRelationshipsForm cmpRelationshipsForm = new CmpRelationshipsForm();
        this.relationshipNameTextField = cmpRelationshipsForm.getRelationshipNameTextField();
        this.descriptionTextArea = cmpRelationshipsForm.getDescriptionTextArea();
        this.roleA.roleNameTextField = cmpRelationshipsForm.getRoleNameTextField();
        this.roleA.ejbComboBox = cmpRelationshipsForm.getEjbComboBox();
        this.roleA.multiplicityManyRadioButton = cmpRelationshipsForm.getMultiplicityManyRadioButton();
        this.roleA.multiplicityOneRadioButton = cmpRelationshipsForm.getMultiplicityOneRadioButton();
        this.roleA.cascadeDeleteCheckBox = cmpRelationshipsForm.getCascadeDeleteCheckBox();
        this.roleA.createCmrFieldCheckBox = cmpRelationshipsForm.getCreateCmrFieldCheckBox();
        this.roleA.fieldNameTextField = cmpRelationshipsForm.getFieldNameTextField();
        this.roleA.fieldTypeComboBox = cmpRelationshipsForm.getFieldTypeComboBox();
        this.roleA.init();
        this.roleB.roleNameTextField = cmpRelationshipsForm.getRoleNameTextField2();
        this.roleB.ejbComboBox = cmpRelationshipsForm.getEjbComboBox2();
        this.roleB.multiplicityManyRadioButton = cmpRelationshipsForm.getMultiplicityManyRadioButton2();
        this.roleB.multiplicityOneRadioButton = cmpRelationshipsForm.getMultiplicityOneRadioButton2();
        this.roleB.cascadeDeleteCheckBox = cmpRelationshipsForm.getCascadeDeleteCheckBox2();
        this.roleB.createCmrFieldCheckBox = cmpRelationshipsForm.getCreateCmrFieldCheckBox2();
        this.roleB.fieldNameTextField = cmpRelationshipsForm.getFieldNameTextField2();
        this.roleB.fieldTypeComboBox = cmpRelationshipsForm.getFieldTypeComboBox2();
        this.roleB.init();
        return cmpRelationshipsForm;
    }

    private class DialogListener
    implements DocumentListener,
    ActionListener {
        private final JLabel errorLabel;
        private final DialogDescriptor dialogDescriptor;

        public DialogListener(JLabel jLabel, DialogDescriptor dialogDescriptor) {
            this.errorLabel = jLabel;
            this.dialogDescriptor = dialogDescriptor;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.validateFields();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.validateFields();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.validateFields();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.validateFields();
        }

        private boolean isCmrFieldSpecified() {
            boolean bl = CmpRelationshipsDialogHelper.this.roleA.createCmrFieldCheckBox.isSelected() && !CmpRelationshipsDialogHelper.this.roleA.fieldNameTextField.getText().trim().equals("");
            boolean bl2 = CmpRelationshipsDialogHelper.this.roleB.createCmrFieldCheckBox.isSelected() && !CmpRelationshipsDialogHelper.this.roleB.fieldNameTextField.getText().trim().equals("");
            return bl || bl2;
        }

        private void validateFields() {
            String string = CmpRelationshipsDialogHelper.this.roleA.getRoleName();
            String string2 = CmpRelationshipsDialogHelper.this.roleB.getRoleName();
            if (string != null && string.equals(string2)) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_SameRoleNames"));
                this.dialogDescriptor.setValid(false);
            } else if (!this.isCmrFieldSpecified()) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoCmrDefined"));
                this.dialogDescriptor.setValid(false);
            } else if (CmpRelationshipsDialogHelper.this.ejbJar.getEnterpriseBeans().getEntity() == null || CmpRelationshipsDialogHelper.this.ejbJar.getEnterpriseBeans().getEntity().length == 0) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoEntitiesFound"));
                this.dialogDescriptor.setValid(false);
            } else if (this.isEmpty(CmpRelationshipsDialogHelper.this.roleA.getEjbName()) || this.isEmpty(CmpRelationshipsDialogHelper.this.roleB.getEjbName())) {
                this.errorLabel.setText(Utils.getBundleMessage("MSG_NoEJbNameSpecified"));
                this.dialogDescriptor.setValid(false);
            } else {
                String string3 = CmpRelationshipsDialogHelper.this.roleA.validateFieldName();
                if (string3 != null) {
                    this.errorLabel.setText(string3);
                    this.dialogDescriptor.setValid(false);
                } else {
                    String string4 = CmpRelationshipsDialogHelper.this.roleB.validateFieldName();
                    if (string4 != null) {
                        this.errorLabel.setText(string4);
                        this.dialogDescriptor.setValid(false);
                    } else {
                        this.errorLabel.setText(" ");
                        this.dialogDescriptor.setValid(true);
                    }
                }
            }
        }

        private boolean isEmpty(String string) {
            return null == string || "".equals(string.trim());
        }
    }

    private class RelationshipDialogActionListener
    implements ActionListener {
        private RelationshipDialogActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.validate();
        }

        public void validate() {
            CmpRelationshipsDialogHelper.this.roleA.setFieldStates(CmpRelationshipsDialogHelper.this.roleB);
            CmpRelationshipsDialogHelper.this.roleB.setFieldStates(CmpRelationshipsDialogHelper.this.roleA);
        }
    }

    private class FormRoleHelper {
        private JTextField roleNameTextField;
        private JComboBox ejbComboBox;
        private JRadioButton multiplicityManyRadioButton;
        private JRadioButton multiplicityOneRadioButton;
        private JCheckBox cascadeDeleteCheckBox;
        private JCheckBox createCmrFieldCheckBox;
        private JTextField fieldNameTextField;
        private JComboBox fieldTypeComboBox;
        private String origEjbName;
        private String origFieldName;
        private String origFieldType;
        protected boolean origGetter;
        protected boolean origSetter;
        private String lastFieldName;
        private String lastFieldType = "java.util.Collection";
        private boolean createCmrFieldChanged = true;

        private FormRoleHelper() {
        }

        private void init() {
            this.ejbComboBox.setModel(new DefaultComboBoxModel(CmpRelationshipsDialogHelper.this.entityNames));
            this.fieldTypeComboBox.setModel(new DefaultComboBoxModel<String>(FILED_TYPE_ITEMS));
            this.multiplicityOneRadioButton.addActionListener(CmpRelationshipsDialogHelper.this.listener);
            this.multiplicityManyRadioButton.addActionListener(CmpRelationshipsDialogHelper.this.listener);
            this.createCmrFieldCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FormRoleHelper.this.createCmrFieldChanged = true;
                    CmpRelationshipsDialogHelper.this.listener.validate();
                }
            });
        }

        private void processResult(RelationshipHelper.RelationshipRoleHelper relationshipRoleHelper) {
            String string = this.getEjbName();
            String string2 = this.getRoleName();
            relationshipRoleHelper.setEjbName(string);
            relationshipRoleHelper.setRoleName(string2);
            relationshipRoleHelper.setMultiple(this.isMultiple());
            relationshipRoleHelper.setCascadeDelete(this.isCascadeDelete());
            if (this.isCreateCmrField()) {
                String string3 = this.getFieldName();
                String string4 = this.getFieldType();
                relationshipRoleHelper.setCmrField(string3, string4);
            } else {
                Object var4_5 = null;
                Object var5_7 = null;
                relationshipRoleHelper.setCmrField(null);
            }
        }

        private boolean equal(String string, String string2) {
            return string == null ? string2 == null : string.equals(string2);
        }

        private boolean isCascadeDelete() {
            return this.cascadeDeleteCheckBox.isSelected();
        }

        private void setCascadeDelete(boolean bl) {
            this.cascadeDeleteCheckBox.setSelected(bl);
        }

        private boolean isMultiple() {
            return this.multiplicityManyRadioButton.isSelected();
        }

        private void setMultiple(boolean bl) {
            if (bl) {
                this.multiplicityManyRadioButton.setSelected(true);
            } else {
                this.multiplicityOneRadioButton.setSelected(true);
            }
        }

        private boolean isCreateCmrField() {
            return this.createCmrFieldCheckBox.isSelected();
        }

        private String getFieldType() {
            return (String)this.fieldTypeComboBox.getSelectedItem();
        }

        private void setFieldType(String string) {
            if (string != null) {
                this.lastFieldType = string;
            }
            this.fieldTypeComboBox.setSelectedItem(string);
        }

        private String getRoleName() {
            String string = this.roleNameTextField.getText().trim();
            return string.length() == 0 ? null : string;
        }

        private void setRoleName(String string) {
            this.roleNameTextField.setText(string);
        }

        private String getEjbName() {
            return (String)this.ejbComboBox.getSelectedItem();
        }

        private void setEjbName(String string) {
            this.ejbComboBox.setSelectedItem(string);
        }

        private void populateFormFields(RelationshipHelper.RelationshipRoleHelper relationshipRoleHelper) {
            this.setRoleName(relationshipRoleHelper.getRoleName());
            this.origEjbName = relationshipRoleHelper.getEjbName();
            this.setEjbName(this.origEjbName);
            this.setMultiple(relationshipRoleHelper.isMultiple());
            this.setCascadeDelete(relationshipRoleHelper.isCascadeDelete());
            CmrField cmrField = relationshipRoleHelper.getCmrField();
            if (cmrField == null) {
                this.origFieldName = null;
                this.origFieldType = null;
                this.setCreateCmrField(false);
                this.setFieldName(null);
                this.setFieldType(null);
            } else {
                this.origFieldName = cmrField.getCmrFieldName();
                this.origFieldType = cmrField.getCmrFieldType();
                this.setCreateCmrField(true);
                this.setFieldName(this.origFieldName);
                this.setFieldType(this.origFieldType);
            }
        }

        private void setCreateCmrField(boolean bl) {
            this.createCmrFieldCheckBox.setSelected(bl);
        }

        public String getFieldName() {
            return this.fieldNameTextField.getText().trim();
        }

        private void setFieldName(String string) {
            if (string != null && string.length() > 0) {
                this.lastFieldName = string;
            }
            this.fieldNameTextField.setText(string);
        }

        public void setFieldStates(FormRoleHelper formRoleHelper) {
            boolean bl = this.isCreateCmrField();
            String string = this.getFieldName();
            if (this.createCmrFieldChanged) {
                this.createCmrFieldChanged = false;
                if (bl) {
                    if (string.length() == 0) {
                        this.setFieldName(this.lastFieldName);
                    }
                    this.fieldNameTextField.setEnabled(true);
                } else {
                    if (string.length() > 0) {
                        this.lastFieldName = string;
                    }
                    this.setFieldName(null);
                    this.fieldNameTextField.setEnabled(false);
                }
            }
            boolean bl2 = formRoleHelper.isMultiple();
            String string2 = this.getFieldType();
            if (bl && bl2) {
                if (string2 == null) {
                    this.setFieldType(this.lastFieldType);
                }
                this.fieldTypeComboBox.setEnabled(true);
            } else {
                if (string2 != null) {
                    this.lastFieldType = string2;
                }
                this.setFieldType(null);
                this.fieldTypeComboBox.setEnabled(false);
            }
        }

        private String validateFieldName() {
            String string;
            if (this.isCreateCmrField() && !Utilities.isJavaIdentifier((String)(string = this.getFieldName()))) {
                return Utils.getBundleMessage("MSG_InvalidFieldName");
            }
            return null;
        }
    }
}

