/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web.multiview;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

class OrderingItemPanel
extends JPanel {
    public static final String OTHERS = "<others>";
    private DialogDescriptor desc;
    private ButtonGroup buttonGroup1;
    private JRadioButton rbName;
    private JRadioButton rbOthers;
    private JTextField tfNameRef;

    public OrderingItemPanel(String item) {
        this.initComponents();
        if (item != null && !item.equals(OTHERS)) {
            this.tfNameRef.setText(item);
            this.rbName.setSelected(true);
        } else {
            this.tfNameRef.setEnabled(false);
            this.rbOthers.setSelected(true);
        }
        this.tfNameRef.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                OrderingItemPanel.this.check();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                OrderingItemPanel.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                OrderingItemPanel.this.check();
            }
        });
    }

    void setDlgSupport(DialogDescriptor desc) {
        this.desc = desc;
    }

    private void check() {
        if (this.desc == null) {
            return;
        }
        NotificationLineSupport supp = this.desc.getNotificationLineSupport();
        if (this.rbName.isSelected()) {
            String s = this.tfNameRef.getText();
            if (s == null || s.length() < 1) {
                supp.setInformationMessage(NbBundle.getMessage(OrderingItemPanel.class, (String)"ERR_NO_NAME"));
                this.desc.setValid(false);
                return;
            }
            if (!Utilities.isJavaIdentifier((String)s)) {
                supp.setErrorMessage(NbBundle.getMessage(OrderingItemPanel.class, (String)"ERR_WRONG_NAME"));
                this.desc.setValid(false);
                return;
            }
        }
        supp.clearMessages();
        this.desc.setValid(true);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.tfNameRef = new JTextField();
        this.rbName = new JRadioButton();
        this.rbOthers = new JRadioButton();
        this.setMinimumSize(new Dimension(250, 150));
        this.tfNameRef.setColumns(20);
        this.buttonGroup1.add(this.rbName);
        Mnemonics.setLocalizedText((AbstractButton)this.rbName, (String)NbBundle.getMessage(OrderingItemPanel.class, (String)"RB_Name"));
        this.rbName.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                OrderingItemPanel.this.rbNameStateChanged(evt);
            }
        });
        this.buttonGroup1.add(this.rbOthers);
        Mnemonics.setLocalizedText((AbstractButton)this.rbOthers, (String)NbBundle.getMessage(OrderingItemPanel.class, (String)"RB_Others"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.rbName).addPreferredGap(0).add((Component)this.tfNameRef, -2, -1, -2)).add((Component)this.rbOthers)).addContainerGap(113, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rbName).add((Component)this.tfNameRef, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbOthers).addContainerGap(87, Short.MAX_VALUE)));
    }

    private void rbNameStateChanged(ChangeEvent evt) {
        this.tfNameRef.setEnabled(this.rbName.isSelected());
        this.check();
    }

    public String getResult() {
        if (this.rbName.isSelected()) {
            String res = this.tfNameRef.getText().trim();
            return res.length() < 1 ? null : res;
        }
        return OTHERS;
    }
}

