/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.crudsample;

import java.awt.Component;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.apisupport.crudsample.SampleAppWizardExtraPanel;
import org.netbeans.modules.apisupport.crudsample.SampleAppWizardPanel;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SampleAppWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private static final long serialVersionUID = 1L;
    private transient int index;
    private transient WizardDescriptor.Panel[] panels;
    private transient WizardDescriptor wiz;
    private SampleAppWizardExtraPanel configurationPanel;

    public static SampleAppWizardIterator createIterator() {
        return new SampleAppWizardIterator();
    }

    private WizardDescriptor.Panel[] createPanels() {
        this.configurationPanel = new SampleAppWizardExtraPanel();
        return new WizardDescriptor.Panel[]{new SampleAppWizardPanel(this.configurationPanel.isValid()), this.configurationPanel};
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(SampleAppWizardIterator.class, (String)"LBL_CreateProjectStep"), NbBundle.getMessage(SampleAppWizardIterator.class, (String)"LBL_CreatePersistenceStep")};
    }

    public Set instantiate() throws IOException {
        LinkedHashSet<FileObject> resultSet = new LinkedHashSet<FileObject>();
        File dirF = FileUtil.normalizeFile((File)((File)this.wiz.getProperty("projdir")));
        dirF.mkdirs();
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wiz);
        FileObject dir = FileUtil.toFileObject((File)dirF);
        SampleAppWizardIterator.unZipFile(template.getInputStream(), dir);
        try {
            this.copyPersistenceLibraries(this.configurationPanel.getSelectedLibrary(), dir);
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
        catch (IllegalStateException ex) {
            throw new IOException(ex);
        }
        this.configureDerby(this.configurationPanel.getDerbyLocation(), dir);
        resultSet.add(dir);
        Enumeration e = dir.getFolders(true);
        while (e.hasMoreElements()) {
            FileObject subfolder = (FileObject)e.nextElement();
            if (!ProjectManager.getDefault().isProject(subfolder)) continue;
            resultSet.add(subfolder);
        }
        File parent = dirF.getParentFile();
        if (parent != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        return resultSet;
    }

    public void initialize(WizardDescriptor wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.length; ++i) {
            Component c = this.panels[i].getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public void uninitialize(WizardDescriptor wiz) {
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
        this.wiz = null;
        this.panels = null;
    }

    public String name() {
        return NbBundle.getMessage(SampleAppWizardIterator.class, (String)"SampleAppWizardIterator.name.format", (Object[])new Object[]{new Integer(this.index + 1), new Integer(this.panels.length)});
    }

    public boolean hasNext() {
        return this.index < this.panels.length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public WizardDescriptor.Panel current() {
        return this.panels[this.index];
    }

    public final void addChangeListener(ChangeListener l) {
    }

    public final void removeChangeListener(ChangeListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unZipFile(InputStream source, FileObject projectRoot) throws IOException {
        try {
            ZipEntry entry;
            ZipInputStream str = new ZipInputStream(source);
            while ((entry = str.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    FileUtil.createFolder((FileObject)projectRoot, (String)entry.getName());
                    continue;
                }
                FileObject fo = FileUtil.createData((FileObject)projectRoot, (String)entry.getName());
                OutputStream out = fo.getOutputStream();
                try {
                    FileUtil.copy((InputStream)str, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            source.close();
        }
    }

    private void copyPersistenceLibraries(Library l, FileObject projectRoot) throws URISyntaxException, IllegalStateException, FileNotFoundException, IOException {
        ArrayList<FileObject> libs = new ArrayList<FileObject>();
        for (URL url : l.getContent("classpath")) {
            FileObject fo = URLMapper.findFileObject((URL)url);
            Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "Libary {0} has jar: {1}", new Object[]{l.getName(), fo});
            FileObject jarFO = null;
            if ("jar".equals(url.getProtocol())) {
                jarFO = FileUtil.getArchiveFile((FileObject)fo);
            }
            if (jarFO == null) {
                throw new IllegalStateException("No file object on " + url);
            }
            libs.add(jarFO);
        }
        File targetFile = new File(FileUtil.toFile((FileObject)projectRoot), "CustomerDBAccessLibrary" + File.separator + "external");
        targetFile.mkdirs();
        FileObject targetFO = FileUtil.toFileObject((File)targetFile);
        for (FileObject fo : libs) {
            File f = FileUtil.toFile((FileObject)fo);
            Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "Copy {0} in {1} as {2}", new Object[]{fo, targetFO, f.getName()});
            FileUtil.copyFile((FileObject)fo, (FileObject)targetFO, (String)fo.getName());
        }
        File projectXMLFile = new File(FileUtil.toFile((FileObject)projectRoot), "CustomerDBAccessLibrary" + File.separator + "nbproject" + File.separator + "project.xml");
        FileObject projectXMLFO = FileUtil.toFileObject((File)projectXMLFile);
        HashSet<String> publicPackages = new HashSet<String>();
        Collections.addAll(publicPackages, "demo", "javax.persistence", "javax.persistence.spi", "javax.persistence.metamodel", "javax.persistence.criteria", "org.netbeans.modules.customerdb");
        HashMap<String, String> cp2origin = new HashMap<String, String>(libs.size());
        cp2origin.put("ext/CustomerDBAccess.jar", "../CustomerDBAccess/dist/CustomerDBAccess.jar");
        for (FileObject jar : libs) {
            String cp = "ext/persistence/" + jar.getNameExt();
            String origin = "external/" + jar.getNameExt();
            cp2origin.put(cp, origin);
        }
        HashMap<String, String> dep2version = new HashMap<String, String>();
        dep2version.put("org.netbeans.modules.derbyclientlibrary", "1.1");
        dep2version.put("org.openide.execution", "1.17");
        dep2version.put("org.openide.util", "8.2");
        SampleAppWizardIterator.generateLibraryModuleTemplate(projectXMLFO, "org.netbeans.modules.customerdb", publicPackages, cp2origin, dep2version);
        Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "project.xml file written : {0}", new Object[]{projectXMLFO});
        File libraryConfFile = new File(FileUtil.toFile((FileObject)projectRoot), "CustomerDBAccess" + File.separator + "src" + File.separator + "META-INF" + File.separator + l.getName() + ".xml");
        Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "META-INF/peristence.xml found at {0}", new Object[]{libraryConfFile});
        assert (libraryConfFile.exists()) : libraryConfFile + " exists.";
        final File persistenceConfFile = new File(libraryConfFile.getParent(), "persistence.xml");
        libraryConfFile.renameTo(persistenceConfFile);
        for (File f : libraryConfFile.getParentFile().listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".xml") && !persistenceConfFile.equals(pathname);
            }
        })) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureDerby(String loc, FileObject projectRoot) throws FileNotFoundException, IOException {
        File projectPropertiesFile = new File(FileUtil.toFile((FileObject)projectRoot), "derbyclient-library" + File.separator + "nbproject" + File.separator + "project.properties");
        FileObject projectPropertiesFO = FileUtil.toFileObject((File)projectPropertiesFile);
        Properties projectProperties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = projectPropertiesFO.getInputStream();
            projectProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        projectProperties.setProperty("derbyclient.jar", loc + "/lib/derbyclient.jar");
        OutputStream outputStream = null;
        try {
            outputStream = projectPropertiesFO.getOutputStream();
            projectProperties.store(outputStream, null);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "derbyclient.jar location in project.properties is {0}", new Object[]{loc + "/lib/derbyclient.jar"});
        File bundleFile = new File(FileUtil.toFile((FileObject)projectRoot), "CustomerDBAccessLibrary" + File.separator + "src" + File.separator + "org" + File.separator + "netbeans" + File.separator + "modules" + File.separator + "customerdb" + File.separator + "Bundle.properties");
        FileObject bundleFO = FileUtil.toFileObject((File)bundleFile);
        Properties bundleProperties = new Properties();
        inputStream = null;
        try {
            inputStream = bundleFO.getInputStream();
            bundleProperties.load(inputStream);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        bundleProperties.setProperty("javadb.home", loc);
        outputStream = null;
        try {
            outputStream = bundleFO.getOutputStream();
            bundleProperties.store(outputStream, null);
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        Logger.getLogger(SampleAppWizardIterator.class.getName()).log(Level.FINE, "JavaDB home is {0}", new Object[]{loc});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateLibraryModuleTemplate(FileObject projectXml, String cnb, Set<String> publicPackages, Map<String, String> extensions, Map<String, String> dep2version) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)"http://www.netbeans.org/ns/project/1", null, null);
        Element typeEl = prjDoc.createElementNS("http://www.netbeans.org/ns/project/1", "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS("http://www.netbeans.org/ns/project/1", "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = SampleAppWizardIterator.createModuleElement(confEl.getOwnerDocument(), "data");
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(SampleAppWizardIterator.createModuleElement(dataDoc, "code-name-base", cnb));
        Element moduleTypeEl = SampleAppWizardIterator.createModuleElement(dataDoc, "suite-component");
        if (moduleTypeEl != null) {
            dataEl.appendChild(moduleTypeEl);
        }
        Element moduleDependeciesElement = SampleAppWizardIterator.createModuleElement(dataDoc, "module-dependencies");
        if (dep2version != null && !dep2version.isEmpty()) {
            for (String dep : dep2version.keySet()) {
                SampleAppWizardIterator.createModuleDependencyElement(moduleDependeciesElement, dep, dep2version.get(dep));
            }
        }
        dataEl.appendChild(moduleDependeciesElement);
        Element packages = SampleAppWizardIterator.createModuleElement(dataDoc, "public-packages");
        dataEl.appendChild(packages);
        for (String string : publicPackages) {
            packages.appendChild(SampleAppWizardIterator.createModuleElement(dataDoc, "package", string));
        }
        for (Map.Entry entry : extensions.entrySet()) {
            Element cp = SampleAppWizardIterator.createModuleElement(dataDoc, "class-path-extension");
            dataEl.appendChild(cp);
            cp.appendChild(SampleAppWizardIterator.createModuleElement(dataDoc, "runtime-relative-path", (String)entry.getKey()));
            cp.appendChild(SampleAppWizardIterator.createModuleElement(dataDoc, "binary-origin", (String)entry.getValue()));
        }
        OutputStream os = projectXml.getOutputStream();
        try {
            XMLUtil.write((Document)prjDoc, (OutputStream)os, (String)"UTF-8");
        }
        finally {
            os.close();
        }
    }

    static void createModuleDependencyElement(Element moduleDependencies, String depCNB, String depSV) {
        Document doc = moduleDependencies.getOwnerDocument();
        Element modDepEl = SampleAppWizardIterator.createModuleElement(doc, "dependency");
        moduleDependencies.insertBefore(modDepEl, null);
        modDepEl.appendChild(SampleAppWizardIterator.createModuleElement(doc, "code-name-base", depCNB));
        if (depCNB.startsWith("org.openide")) {
            modDepEl.appendChild(SampleAppWizardIterator.createModuleElement(doc, "build-prerequisite"));
            modDepEl.appendChild(SampleAppWizardIterator.createModuleElement(doc, "compile-dependency"));
        }
        Element runDepEl = SampleAppWizardIterator.createModuleElement(doc, "run-dependency");
        modDepEl.appendChild(runDepEl);
        if (depSV != null && !"".equals(depSV)) {
            runDepEl.appendChild(SampleAppWizardIterator.createModuleElement(doc, "specification-version", depSV));
        }
    }

    private static Element createModuleElement(Document doc, String name) {
        return doc.createElementNS("http://www.netbeans.org/ns/nb-module-project/3", name);
    }

    private static Element createModuleElement(Document doc, String name, String innerText) {
        Element el = SampleAppWizardIterator.createModuleElement(doc, name);
        el.appendChild(doc.createTextNode(innerText));
        return el;
    }
}

