/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.ArrayList;
import javax.lang.model.element.Element;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoring;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringElement;
import org.netbeans.modules.groovy.refactoring.GroovyRefactoringPlugin;
import org.netbeans.modules.groovy.refactoring.GroovyWhereUsed;
import org.netbeans.modules.groovy.refactoring.RefactoringUtil;
import org.netbeans.modules.groovy.refactoring.Utils;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class GroovyRefactoringFactory
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring abstractRefactoring) {
        boolean bl;
        NonRecursiveFolder nonRecursiveFolder = (NonRecursiveFolder)abstractRefactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        FileObject fileObject = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        TreePathHandle treePathHandle = this.resolveTreePathHandle(abstractRefactoring);
        GroovyRefactoringElement groovyRefactoringElement = (GroovyRefactoringElement)((Object)abstractRefactoring.getRefactoringSource().lookup(GroovyRefactoringElement.class));
        boolean bl2 = nonRecursiveFolder != null && RefactoringUtil.isOnSourceClasspath(nonRecursiveFolder.getFolder());
        boolean bl3 = bl = fileObject != null && fileObject.isFolder();
        if (fileObject == null) {
            if (treePathHandle != null) {
                fileObject = treePathHandle.getFileObject();
            } else if (nonRecursiveFolder != null) {
                fileObject = nonRecursiveFolder.getFolder();
            } else if (groovyRefactoringElement != null) {
                fileObject = groovyRefactoringElement.getFileObject();
            }
        }
        if (fileObject == null) {
            return null;
        }
        boolean bl4 = fileObject != null && Utils.isInGroovyProject(fileObject) && (RefactoringUtil.isJavaFile(fileObject) || Utils.isGroovyFile(fileObject));
        String string = null;
        if (treePathHandle != null) {
            string = this.resolveClass(treePathHandle);
        } else if (groovyRefactoringElement != null) {
            string = groovyRefactoringElement.getDefClass();
        }
        if (bl4 && string == null) {
            return null;
        }
        ArrayList<GroovyRefactoring> arrayList = new ArrayList<GroovyRefactoring>();
        if (abstractRefactoring instanceof WhereUsedQuery && bl4) {
            WhereUsedQuery whereUsedQuery = (WhereUsedQuery)abstractRefactoring;
            arrayList.add(new GroovyWhereUsed(fileObject, string, whereUsedQuery));
        }
        return arrayList.isEmpty() ? null : new GroovyRefactoringPlugin(arrayList);
    }

    private TreePathHandle resolveTreePathHandle(AbstractRefactoring abstractRefactoring) {
        TreePathHandle treePathHandle = (TreePathHandle)abstractRefactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (treePathHandle != null) {
            return treePathHandle;
        }
        FileObject fileObject = (FileObject)abstractRefactoring.getRefactoringSource().lookup(FileObject.class);
        if (fileObject == null || !RefactoringUtil.isJavaFile(fileObject)) {
            return null;
        }
        final TreePathHandle[] treePathHandleArray = new TreePathHandle[1];
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    CompilationUnitTree compilationUnitTree = compilationController.getCompilationUnit();
                    if (compilationUnitTree.getTypeDecls().isEmpty()) {
                        return;
                    }
                    treePathHandleArray[0] = TreePathHandle.create((TreePath)TreePath.getPath(compilationUnitTree, compilationUnitTree.getTypeDecls().get(0)), (CompilationInfo)compilationController);
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return treePathHandleArray[0];
    }

    private String resolveClass(final TreePathHandle treePathHandle) {
        if (treePathHandle == null) {
            return null;
        }
        final String[] stringArray = new String[1];
        try {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)treePathHandle.getFileObject());
            if (javaSource == null) {
                return null;
            }
            javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                public void cancel() {
                }

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.RESOLVED);
                    if (treePathHandle != null) {
                        Element element = treePathHandle.resolveElement((CompilationInfo)compilationController);
                        stringArray[0] = ((Object)element.asType()).toString();
                    }
                }
            }, true);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        return stringArray[0];
    }
}

