/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitPanel;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.status.StatusAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.hooks.HgHook;
import org.netbeans.modules.versioning.hooks.HgHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";

    @Override
    protected boolean enable(Node[] nodes) {
        Set ctxFiles;
        VCSContext context = HgUtils.getCurrentContext(nodes);
        Set set = ctxFiles = context != null ? context.getRootFiles() : null;
        return HgUtils.isFromHgRepository(context) && ctxFiles != null && !ctxFiles.isEmpty();
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        File root = HgUtils.getRootFile(context);
        if (root == null) {
            OutputLogger logger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_INFO"));
            logger.output("");
            logger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String contentTitle = Utils.getContextDisplayName((VCSContext)context);
        CommitAction.commit(contentTitle, context);
    }

    public static void commit(String contentTitle, VCSContext ctx) {
        File repository = HgUtils.getRootFile(ctx);
        if (repository == null) {
            return;
        }
        final CommitPanel panel = new CommitPanel();
        final Collection hooks = VCSHooks.getInstance().getHooks(HgHook.class);
        panel.setHooks(hooks, new HgHookContext(ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]), null, new HgHookContext.LogEntry[0]));
        final CommitTable data = new CommitTable(panel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        panel.setCommitTable(data);
        data.setCommitPanel(panel);
        final JButton commitButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)commitButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        commitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        commitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        final JButton cancelButton = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)contentTitle), true, new Object[]{commitButton, cancelButton}, (Object)commitButton, 0, new HelpCtx(CommitAction.class), null);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dd.setClosingOptions(new Object[]{commitButton, cancelButton});
                SaveCookie[] saveCookies = panel.getSaveCookies();
                if (cancelButton == e.getSource()) {
                    if (saveCookies.length > 0) {
                        if (SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies) || !panel.isShowing()) {
                            EditorCookie[] editorCookies;
                            for (EditorCookie cookie : editorCookies = panel.getEditorCookies()) {
                                cookie.open();
                            }
                        } else {
                            dd.setClosingOptions(new Object[0]);
                        }
                    }
                    dd.setValue((Object)cancelButton);
                } else if (commitButton == e.getSource()) {
                    if (saveCookies.length > 0 && !SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
                        dd.setClosingOptions(new Object[0]);
                    } else if (!panel.canCommit()) {
                        dd.setClosingOptions(new Object[0]);
                    }
                    dd.setValue((Object)commitButton);
                }
            }
        };
        dd.setButtonListener(al);
        CommitAction.computeNodes(data, panel, ctx, repository, cancelButton);
        commitButton.setEnabled(false);
        panel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        data.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        commitButton.setEnabled(CommitAction.containsCommitable(data));
        panel.putClientProperty("contentTitle", contentTitle);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), "hg.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        final String message = panel.getCommitMessage().trim();
        if (dd.getValue() != commitButton && !message.isEmpty()) {
            HgModuleConfig.getDefault().setLastCanceledCommitMessage(message);
        }
        if (dd.getValue() == DialogDescriptor.CLOSED_OPTION) {
            al.actionPerformed(new ActionEvent(cancelButton, 1001, null));
        } else if (dd.getValue() == commitButton) {
            final Map<HgFileNode, CommitOptions> commitFiles = data.getCommitFiles();
            final Map<File, Set<File>> rootFiles = HgUtils.sortUnderRepository(ctx, true);
            HgModuleConfig.getDefault().setLastCanceledCommitMessage("");
            Utils.insert((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)message.trim(), (int)20);
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
            HgProgressSupport support = new HgProgressSupport(){

                @Override
                public void perform() {
                    OutputLogger logger = this.getLogger();
                    CommitAction.performCommit(message, commitFiles, rootFiles, this, logger, hooks);
                }
            };
            support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static void computeNodes(final CommitTable table, final CommitPanel panel, final VCSContext ctx, File repository, JButton cancel) {
        RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(repository);
        HgProgressSupport support = new HgProgressSupport(NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit"), cancel){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                try {
                    panel.progressPanel.setVisible(true);
                    StatusAction.executeStatus(ctx, this);
                    FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
                    File[] roots = ctx.getRootFiles().toArray(new File[ctx.getRootFiles().size()]);
                    File[][] split = Utils.splitFlatOthers((File[])roots);
                    ArrayList<File> fileList = new ArrayList<File>();
                    for (int c = 0; c < split.length; ++c) {
                        boolean recursive;
                        roots = split[c];
                        boolean bl = recursive = c == 1;
                        if (recursive) {
                            Set<File> repositories = HgUtils.getRepositoryRoots(ctx);
                            File[] files = cache.listFiles(ctx, 6612);
                            for (int i = 0; i < files.length; ++i) {
                                for (int r = 0; r < roots.length; ++r) {
                                    if (!repositories.contains(Mercurial.getInstance().getRepositoryRoot(files[i])) || !HgUtils.isParentOrEqual(roots[r], files[i]) || fileList.contains(files[i])) continue;
                                    fileList.add(files[i]);
                                }
                            }
                            continue;
                        }
                        File[] files = HgUtils.flatten(roots, 6612);
                        for (int i = 0; i < files.length; ++i) {
                            if (fileList.contains(files[i])) continue;
                            fileList.add(files[i]);
                        }
                    }
                    if (fileList.isEmpty()) {
                        return;
                    }
                    ArrayList<HgFileNode> nodesList = new ArrayList<HgFileNode>(fileList.size());
                    for (File file : fileList) {
                        HgFileNode node = new HgFileNode(file);
                        nodesList.add(node);
                    }
                    final HgFileNode[] nodes = nodesList.toArray(new HgFileNode[fileList.size()]);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            table.setNodes(nodes);
                        }
                    });
                }
                finally {
                    panel.progressPanel.setVisible(false);
                }
            }
        };
        panel.progressPanel.add((Component)support.getProgressComponent());
        panel.progressPanel.setVisible(true);
        support.start(rp);
    }

    private static boolean containsCommitable(CommitTable data) {
        Map<HgFileNode, CommitOptions> map = data.getCommitFiles();
        for (CommitOptions co : map.values()) {
            if (co == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel panel, CommitTable table, JButton commit) {
        String errorLabel;
        String msg;
        assert (EventQueue.isDispatchThread());
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        Map<HgFileNode, CommitOptions> files = table.getCommitFiles();
        HashSet stickyTags = new HashSet();
        boolean conflicts = false;
        boolean enabled = commit.isEnabled();
        for (HgFileNode fileNode : files.keySet()) {
            int status;
            CommitOptions options = files.get(fileNode);
            if (options == CommitOptions.EXCLUDE || ((status = fileNode.getInformation().getStatus()) & 0x6A0) == 0 && status != 64) continue;
            enabled = false;
            msg = status == 64 ? loc.getString("MSG_CommitForm_ErrorConflicts") : loc.getString("MSG_CommitForm_ErrorRemoteChanges");
            panel.setErrorLabel("<html><font color=\"#002080\">" + msg + "</font></html>");
            conflicts = true;
        }
        if (stickyTags.size() > 1) {
            table.setColumns(new String[]{"commit", "name", "branch", "status", "action", "path"});
        } else {
            table.setColumns(new String[]{"commit", "name", "status", "action", "path"});
        }
        String contentTitle = (String)panel.getClientProperty("contentTitle");
        DialogDescriptor dd = (DialogDescriptor)panel.getClientProperty("DialogDescriptor");
        if (stickyTags.size() <= 1) {
            String stickyTag;
            String string = stickyTag = stickyTags.isEmpty() ? null : (String)stickyTags.iterator().next();
            if (stickyTag == null) {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle));
                errorLabel = "";
            } else {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branch"), contentTitle, stickyTag));
                msg = MessageFormat.format(loc.getString("MSG_CommitForm_InfoBranch"), stickyTag);
                errorLabel = "<html><font color=\"#002080\">" + msg + "</font></html>";
            }
        } else {
            dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branches"), contentTitle));
            String msg2 = loc.getString("MSG_CommitForm_ErrorMultipleBranches");
            errorLabel = "<html><font color=\"#CC0000\">" + msg2 + "</font></html>";
        }
        if (!conflicts) {
            panel.setErrorLabel(errorLabel);
            enabled = true;
        }
        commit.setEnabled(enabled && CommitAction.containsCommitable(table));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performCommit(String message, Map<HgFileNode, CommitOptions> commitFiles, Map<File, Set<File>> rootFiles, HgProgressSupport support, OutputLogger logger, Collection<HgHook> hooks) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        HashMap<File, List<File>> addCandidates = new HashMap<File, List<File>>();
        HashMap<File, List<File>> deleteCandidates = new HashMap<File, List<File>>();
        HashMap<File, List<File>> commitCandidates = new HashMap<File, List<File>>();
        HashMap<File, Set<File>> filesToRefresh = new HashMap<File, Set<File>>();
        Iterator<HgFileNode> it = commitFiles.keySet().iterator();
        ArrayList<String> excPaths = new ArrayList<String>();
        HashMap<File, Boolean> locallyModifiedExcluded = new HashMap<File, Boolean>();
        ArrayList<String> incPaths = new ArrayList<String>();
        while (it.hasNext()) {
            int status;
            if (support.isCanceled()) {
                return;
            }
            HgFileNode node = it.next();
            CommitOptions option = commitFiles.get(node);
            File repository = Mercurial.getInstance().getRepositoryRoot(node.getFile());
            if (option != CommitOptions.EXCLUDE) {
                status = cache.getStatus(node.getFile()).getStatus();
                if ((status & 4) != 0) {
                    CommitAction.putCandidate(addCandidates, repository, node.getFile());
                } else if ((status & 0x800) != 0) {
                    CommitAction.putCandidate(deleteCandidates, repository, node.getFile());
                }
                CommitAction.putCandidate(commitCandidates, repository, node.getFile());
                incPaths.add(node.getFile().getAbsolutePath());
                continue;
            }
            excPaths.add(node.getFile().getAbsolutePath());
            if (Boolean.TRUE.equals(locallyModifiedExcluded.get(repository))) continue;
            status = cache.getCachedStatus(node.getFile()).getStatus();
            locallyModifiedExcluded.put(repository, (status & 4) == 0);
        }
        if (support.isCanceled()) {
            return;
        }
        if (!excPaths.isEmpty()) {
            HgModuleConfig.getDefault().addExclusionPaths(excPaths);
        }
        if (!incPaths.isEmpty()) {
            HgModuleConfig.getDefault().removeExclusionPaths(incPaths);
        }
        try {
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            logger.output(message);
            new Cmd.AddCmd(addCandidates, logger, null, "hg add {0} into {1}").handle();
            new Cmd.RemoveCmd(deleteCandidates, logger, null, "hg delete {0} from {1}").handle();
            File[] hookFiles = null;
            if (hooks.size() > 0) {
                LinkedList candidates = new LinkedList();
                for (List values : commitCandidates.values()) {
                    candidates.addAll(values);
                }
                hookFiles = candidates.toArray(new File[candidates.size()]);
            }
            HgHookContext context = new HgHookContext(hookFiles, message, new HgHookContext.LogEntry[0]);
            for (HgHook hook : hooks) {
                try {
                    if ((context = hook.beforeCommit(context)) == null) continue;
                    message = context.getMessage();
                }
                catch (IOException ex) {}
            }
            Cmd.CommitCmd commitCmd = new Cmd.CommitCmd(commitCandidates, logger, message, support, rootFiles, locallyModifiedExcluded, filesToRefresh);
            commitCmd.setCommitHooks(context, hooks, hookFiles);
            commitCmd.handle();
        }
        catch (HgException.HgCommandCanceledException ex) {
        }
        catch (HgException ex) {
            NotifyDescriptor.Exception e = new NotifyDescriptor.Exception((Throwable)ex);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)e);
        }
        finally {
            CommitAction.refreshFS(filesToRefresh);
            cache.refreshAllRoots(filesToRefresh);
            logger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
            logger.output("");
        }
    }

    private static void refreshFS(Map<File, Set<File>> filesPerRepository) {
        final HashSet<File> files = new HashSet<File>();
        for (Set<File> values : filesPerRepository.values()) {
            files.addAll(values);
        }
        Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])files.toArray(new File[files.size()]));
            }
        }, 100);
    }

    private static void putCandidate(Map<File, List<File>> m, File repository, File file) {
        List<File> l = m.get(repository);
        if (l == null) {
            l = new ArrayList<File>();
            m.put(repository, l);
        }
        l.add(file);
    }

    private static boolean commitAfterMerge(boolean locallyModifiedExcluded, File repository) {
        if (locallyModifiedExcluded || HgModuleConfig.getDefault().getConfirmCommitAfterMerge()) {
            NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_QUERY"));
            descriptor.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_AFTER_MERGE_TITLE"));
            descriptor.setMessageType(2);
            descriptor.setOptionType(0);
            Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            return res == NotifyDescriptor.YES_OPTION;
        }
        return true;
    }

    private static abstract class Cmd {
        protected final Map<File, List<File>> m;
        protected final OutputLogger logger;
        protected final String logMsgFormat;
        protected final String msg;

        public Cmd(Map<File, List<File>> m, OutputLogger logger, String msg, String logMsgFormat) {
            this.m = m;
            this.logger = logger;
            this.logMsgFormat = logMsgFormat;
            this.msg = msg;
        }

        void handle() throws HgException {
            if (this.m.isEmpty()) {
                return;
            }
            for (Map.Entry<File, List<File>> e : this.m.entrySet()) {
                this.doCmd(e.getKey(), e.getValue());
                for (File f : e.getValue()) {
                    this.logger.output(MessageFormat.format(this.logMsgFormat, f.getName(), e.getKey()));
                }
            }
        }

        abstract void doCmd(File var1, List<File> var2) throws HgException;

        static class CommitCmd
        extends Cmd {
            private HgHookContext context;
            private Collection<HgHook> hooks;
            private final HgProgressSupport support;
            private File[] hookFiles;
            private final Map<File, Set<File>> rootFilesPerRepository;
            private final Map<File, Set<File>> refreshFilesPerRepository;
            private final Map<File, Boolean> locallyModifiedExcluded;

            public CommitCmd(Map<File, List<File>> m, OutputLogger logger, String commitMessage, HgProgressSupport support, Map<File, Set<File>> rootFilesPerRepository, Map<File, Boolean> locallyModifiedExcluded, Map<File, Set<File>> filesToRefresh) {
                super(m, logger, commitMessage, null);
                this.support = support;
                this.rootFilesPerRepository = rootFilesPerRepository;
                this.locallyModifiedExcluded = locallyModifiedExcluded;
                this.refreshFilesPerRepository = filesToRefresh;
            }

            public void setCommitHooks(HgHookContext context, Collection<HgHook> hooks, File[] hookFiles) {
                this.context = context;
                this.hooks = hooks;
                this.hookFiles = hookFiles;
            }

            @Override
            void handle() throws HgException {
                if (this.m.isEmpty()) {
                    return;
                }
                for (Map.Entry e : this.m.entrySet()) {
                    this.doCmd((File)e.getKey(), (List)e.getValue());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                boolean commitAfterMerge;
                block23: {
                    commitAfterMerge = false;
                    Set<File> refreshFiles = new HashSet<File>(candidates);
                    try {
                        HgCommand.doCommit(repository, candidates, this.msg, this.logger);
                    }
                    catch (HgException.HgTooLongArgListException e) {
                        ArrayList<File> reducedCommitCandidates;
                        Mercurial.LOG.log(Level.INFO, null, e);
                        String offeredFileNames = "";
                        Set<File> roots = this.rootFilesPerRepository.get(repository);
                        if (roots != null && roots.size() < 5) {
                            reducedCommitCandidates = new ArrayList<File>(roots);
                            refreshFiles = new HashSet<File>(roots);
                            for (File f : reducedCommitCandidates) {
                                offeredFileNames = offeredFileNames + "\n" + f.getName();
                            }
                        } else {
                            reducedCommitCandidates = Collections.EMPTY_LIST;
                            refreshFiles = Collections.singleton(repository);
                            offeredFileNames = "\n" + repository.getName();
                        }
                        NotifyDescriptor.Confirmation descriptor = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_QUERY", (Object)offeredFileNames));
                        descriptor.setTitle(NbBundle.getMessage(CommitAction.class, (String)"MSG_LONG_COMMAND_TITLE"));
                        descriptor.setMessageType(2);
                        descriptor.setOptionType(0);
                        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
                        if (res == NotifyDescriptor.NO_OPTION) {
                            return;
                        }
                        Mercurial.LOG.log(Level.INFO, "CommitAction: committing with a reduced set of files: {0}", ((Object)reducedCommitCandidates).toString());
                        HgCommand.doCommit(repository, reducedCommitCandidates, this.msg, this.logger);
                    }
                    catch (HgException ex) {
                        if ("commitAfterMerge".equals(ex.getMessage())) {
                            if (this.support.isCanceled()) {
                                return;
                            }
                            if (!CommitAction.commitAfterMerge(Boolean.TRUE.equals(this.locallyModifiedExcluded.get(repository)), repository)) {
                                return;
                            }
                            HgCommand.doCommit(repository, Collections.EMPTY_LIST, this.msg, this.logger);
                            refreshFiles = new HashSet<File>(Mercurial.getInstance().getSeenRoots(repository));
                            commitAfterMerge = true;
                            break block23;
                        }
                        throw ex;
                    }
                    finally {
                        this.refreshFilesPerRepository.put(repository, refreshFiles);
                    }
                }
                HgLogMessage tip = HgCommand.doTip(repository, this.logger);
                this.context = new HgHookContext(this.hookFiles, this.msg, new HgHookContext.LogEntry[]{new HgHookContext.LogEntry(tip.getMessage(), tip.getAuthor(), tip.getCSetShortID(), tip.getDate())});
                for (HgHook hook : this.hooks) {
                    hook.afterCommit(this.context);
                }
                if (commitAfterMerge) {
                    this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMITED_FILES_AFTER_MERGE"));
                } else {
                    if (candidates.size() == 1) {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP_ONE", (Object)candidates.size()));
                    } else {
                        this.logger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP", (Object)candidates.size()));
                    }
                    for (File f : candidates) {
                        this.logger.output("\t" + f.getAbsolutePath());
                    }
                }
                HgUtils.logHgLog(tip, this.logger);
            }
        }

        static class RemoveCmd
        extends Cmd {
            public RemoveCmd(Map<File, List<File>> m, OutputLogger logger, String msgFormat, String msg) {
                super(m, logger, msgFormat, msg);
            }

            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                HgCommand.doRemove(repository, candidates, this.logger);
            }
        }

        static class AddCmd
        extends Cmd {
            public AddCmd(Map<File, List<File>> m, OutputLogger logger, String msgFormat, String msg) {
                super(m, logger, msgFormat, msg);
            }

            @Override
            void doCmd(File repository, List<File> candidates) throws HgException {
                HgCommand.doAdd(repository, candidates, this.logger);
            }
        }
    }
}

