/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.nbtasks;

import com.sun.javacard.nbtasks.JCInstallerTask;
import java.io.File;
import org.apache.tools.ant.BuildException;

public class LoadTask
extends JCInstallerTask {
    private String bundleName;
    private String bundleFile;
    private String signatureFile;

    public void execute() throws BuildException {
        this.validateBundleName();
        this.validateBundleFile();
        this.validateSignatureFile();
        this.createArg().setValue("load");
        this.createArg().setValue("--type");
        this.createArg().setValue(this.getType());
        this.createArg().setValue("--name");
        this.createArg().setValue(this.bundleName);
        this.createArg().setValue("--signature");
        this.createArg().setFile(new File(this.signatureFile).getAbsoluteFile());
        this.createArg().setFile(new File(this.bundleFile).getAbsoluteFile());
        super.execute();
    }

    private void validateBundleName() throws BuildException {
        if (this.bundleName == null) {
            this.bundleName = this.getProject().getProperty("display.name");
        }
        if (this.bundleName == null) {
            throw new BuildException("Bundle Name not specified");
        }
        this.bundleName = this.bundleName.trim();
        if (this.bundleName.length() <= 0) {
            throw new BuildException("Empty value for BundleName");
        }
    }

    private void validateBundleFile() throws BuildException {
        if (this.bundleFile == null) {
            this.bundleFile = new File(this.getProject().getBaseDir(), this.getProject().getProperty("dist.bundle")).getAbsolutePath();
        }
        if (this.bundleFile == null) {
            throw new BuildException("Bundle File not specified");
        }
        File file = new File(this.bundleFile);
        if (!file.exists()) {
            throw new BuildException("BundleFile '" + file + "' does not exists");
        }
        if (!file.isFile()) {
            throw new BuildException("BundleFile '" + file + "' is not a file");
        }
    }

    private void validateSignatureFile() throws BuildException {
        if (this.signatureFile == null) {
            this.signatureFile = new File(this.getProject().getBaseDir(), this.getProject().getProperty("dist.bundle.sig")).getAbsolutePath();
        }
        if (this.signatureFile == null) {
            throw new BuildException("Signature file not specified");
        }
        File file = new File(this.signatureFile);
        if (!file.exists()) {
            throw new BuildException("SignatureFile '" + this.signatureFile + "' does not exists");
        }
        if (!file.isFile()) {
            throw new BuildException("SignatureFile '" + this.signatureFile + "' is not a file");
        }
    }

    public String getBundleFile() {
        return this.bundleFile;
    }

    public void setBundleFile(String string) {
        this.bundleFile = string;
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public void setBundleName(String string) {
        this.bundleName = string;
    }

    public String getSignatureFile() {
        return this.signatureFile;
    }

    public void setSignatureFile(String string) {
        this.signatureFile = string;
    }
}

