/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.components.caputils;

import com.sun.javacard.components.caputils.CAPUtil;
import com.sun.javacard.components.caputils.CPClassInfo;
import com.sun.javacard.components.caputils.CPClassMemberInfo;
import com.sun.javacard.components.caputils.CPInfo;
import com.sun.javacard.components.caputils.CPIntegerInfo;
import com.sun.javacard.components.caputils.CPNameAndTypeInfo;
import com.sun.javacard.components.caputils.CPUtf8Info;
import com.sun.javacard.components.caputils.CapProcessor;
import com.sun.javacard.offcardverifier.Cap;
import com.sun.javacard.offcardverifier.ClassDescriptor;
import com.sun.javacard.offcardverifier.ClassInfo;
import com.sun.javacard.offcardverifier.Classref;
import com.sun.javacard.offcardverifier.ConstantPoolComponent;
import com.sun.javacard.offcardverifier.ConstantPoolEntry;
import com.sun.javacard.offcardverifier.FieldDescriptor;
import com.sun.javacard.offcardverifier.MethodDescriptor;
import com.sun.javacard.offcardverifier.Methodref;
import com.sun.javacard.offcardverifier.exportfile.EfClass;
import com.sun.javacard.offcardverifier.exportfile.EfField;
import com.sun.javacard.offcardverifier.exportfile.EfMethod;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;
import java.util.Vector;

public class ClassConstantPool {
    public static final int CONSTANT_Class_tag = 7;
    public static final int CONSTANT_Fieldref_tag = 9;
    public static final int CONSTANT_Methodref_tag = 10;
    public static final int CONSTANT_InterfaceMethodref_tag = 11;
    public static final int CONSTANT_String_tag = 8;
    public static final int CONSTANT_Integer_tag = 3;
    public static final int CONSTANT_Float_tag = 4;
    public static final int CONSTANT_Long_tag = 5;
    public static final int CONSTANT_Double_tag = 6;
    public static final int CONSTANT_NameAndType_tag = 12;
    public static final int CONSTANT_Utf8_tag = 1;
    private EfClass exportedClass;
    private ClassDescriptor cdesc;
    private String className;
    private Vector<CPInfo> CPEntries;
    private Vector<Integer> interfaces;
    private int thisClassRefIndex;
    private int superClassRefIndex;

    public ClassConstantPool(ClassDescriptor classDescriptor, String string, EfClass efClass) {
        this.cdesc = classDescriptor;
        this.className = string;
        this.exportedClass = efClass;
        this.CPEntries = new Vector();
        this.interfaces = new Vector();
        this.buildConstantPool();
    }

    private int setConstantPoolEntry(CPInfo cPInfo) {
        if (this.CPEntries.contains(cPInfo)) {
            return this.CPEntries.indexOf(cPInfo) + 1;
        }
        this.CPEntries.add(cPInfo);
        return this.CPEntries.size();
    }

    private void buildConstantPool() {
        int n;
        int n2;
        int n3 = this.cdesc.thisClass();
        boolean bl2 = (this.cdesc.flags() & 0x40) == 64;
        this.thisClassRefIndex = this.setCPClassInfo(this.className);
        ClassInfo classInfo = Cap.Class.infoOfs(n3);
        String string = "java/lang/Object";
        if (!bl2) {
            n2 = classInfo.superclass();
            string = CAPUtil.getRefName(n2);
        }
        this.superClassRefIndex = this.setCPClassInfo(string);
        n2 = bl2 ? classInfo.interfaceCount() : this.cdesc.interfaceCount();
        int n4 = this.cdesc.fieldCount();
        int n5 = this.cdesc.methodCount();
        for (n = 0; n < n2; ++n) {
            int n6 = bl2 ? classInfo.superinterface(n) : this.cdesc.interfaceRef(n);
            String string2 = CAPUtil.getRefName(n6);
            int bl = this.setCPClassInfo(string2);
            this.interfaces.add(new Integer(bl));
        }
        for (n = 0; n < n4; ++n) {
            FieldDescriptor fieldDescriptor = this.cdesc.fieldDescr(n);
            this.setCPEntryForField(fieldDescriptor);
        }
        for (n = 0; n < n5; ++n) {
            MethodDescriptor methodDescriptor = this.cdesc.methodDescr(n);
            int n7 = methodDescriptor.flags();
            boolean bl = (n7 & 8) != 0;
            boolean bl3 = (n7 & 0x80) != 0;
            this.setCPEntryForMethod(methodDescriptor, bl, bl3);
        }
    }

    private int setCPClassInfo(String string) {
        short s = (short)this.addConstantUtf8Info(string);
        return this.setConstantPoolEntry(new CPClassInfo(s));
    }

    private void setCPEntryForField(FieldDescriptor fieldDescriptor) {
        String string = CAPUtil.getClassFieldName(fieldDescriptor, this.exportedClass);
        int n = fieldDescriptor.type();
        String string2 = CAPUtil.getFieldDescrStr((short)n);
        int n2 = this.addClassMemberInfo(9, string, string2);
    }

    private void setCPEntryForMethod(MethodDescriptor methodDescriptor, boolean bl, boolean bl2) {
        String string = CAPUtil.getClassMethodName(methodDescriptor, bl, bl2, this.exportedClass);
        String string2 = CAPUtil.getMethodDescriptorString((short)methodDescriptor.type());
        int n = this.addClassMemberInfo(10, string, string2);
    }

    private int addClassMemberInfo(int n, String string, String string2) {
        short s;
        short s2 = (short)this.addConstantUtf8Info(string);
        CPNameAndTypeInfo cPNameAndTypeInfo = new CPNameAndTypeInfo(s2, s = (short)this.addConstantUtf8Info(string2));
        short s3 = (short)this.setConstantPoolEntry(cPNameAndTypeInfo);
        CPClassMemberInfo cPClassMemberInfo = new CPClassMemberInfo(n, (short)this.thisClassRefIndex, s3);
        int n2 = this.CPEntries.indexOf(cPClassMemberInfo) + 1;
        if (n2 <= 0) {
            n2 = this.setConstantPoolEntry(cPClassMemberInfo);
        }
        return n2;
    }

    public int addInteger(int n) {
        CPIntegerInfo cPIntegerInfo = new CPIntegerInfo(n);
        int n2 = this.CPEntries.indexOf(cPIntegerInfo) + 1;
        if (n2 <= 0) {
            n2 = this.setConstantPoolEntry(cPIntegerInfo);
        }
        return n2;
    }

    public int addConstantUtf8Info(String string) {
        byte[] byArray = string.getBytes();
        CPUtf8Info cPUtf8Info = new CPUtf8Info(byArray, 0, (short)byArray.length);
        int n = this.CPEntries.indexOf(cPUtf8Info) + 1;
        if (n <= 0) {
            n = this.setConstantPoolEntry(cPUtf8Info);
        }
        return n;
    }

    public int getThisClassIndex() {
        return this.thisClassRefIndex;
    }

    public int getSuperClassRefIndex() {
        return this.superClassRefIndex;
    }

    public Vector<Integer> getInterfaceRefs() {
        return this.interfaces;
    }

    public int getUtf8InfoIndex(String string) {
        byte[] byArray = string.getBytes();
        CPUtf8Info cPUtf8Info = new CPUtf8Info(byArray, 0, (short)byArray.length);
        int n = this.CPEntries.indexOf(cPUtf8Info) + 1;
        if (n <= 0) {
            n = this.setConstantPoolEntry(cPUtf8Info);
        }
        return n;
    }

    public short getClassRefIndex(String string) {
        short s = (short)this.getUtf8InfoIndex(string);
        if (s < 0) {
            return (short)this.setCPClassInfo(string);
        }
        CPClassInfo cPClassInfo = new CPClassInfo(s);
        int n = this.CPEntries.indexOf(cPClassInfo);
        if (n < 0) {
            return (short)this.setConstantPoolEntry(cPClassInfo);
        }
        return (short)(n + 1);
    }

    public int getCPEntryIndexForClassMember(String string, String string2, String string3, int n) {
        short s = this.getClassRefIndex(string);
        int n2 = this.getUtf8InfoIndex(string2);
        int n3 = this.getUtf8InfoIndex(string3);
        int n4 = this.setConstantPoolEntry(new CPNameAndTypeInfo((short)n2, (short)n3));
        return this.setConstantPoolEntry(new CPClassMemberInfo(n, s, (short)n4));
    }

    public CPInfo getConstantPoolEntryAt(int n) {
        return this.CPEntries.elementAt(n - 1);
    }

    public short getConstantPoolEntryCount() {
        return (short)this.CPEntries.size();
    }

    public int getFieldCPEntry(int n) {
        FieldDescriptor fieldDescriptor = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        EfClass efClass = null;
        EfField efField = null;
        ClassDescriptor classDescriptor = null;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        boolean bl = constantPoolEntry.tag() == 5;
        boolean bl2 = false;
        if (bl) {
            if (!constantPoolEntry.isExternalStaticRef()) {
                int n2;
                classDescriptor = Cap.Descriptor.firstClassDescriptor();
                for (int i = Cap.Descriptor.classCount(); i > 0 && (fieldDescriptor = classDescriptor.getFieldDescriptorForLocation(n2 = constantPoolEntry.internalStaticRef())) == null; --i) {
                    classDescriptor.next();
                }
            } else {
                bl2 = true;
                int n3 = constantPoolEntry.externalStaticRefPackageToken();
                int n4 = constantPoolEntry.externalStaticRefClassToken();
                int n5 = constantPoolEntry.tokenStaticRef();
                ExportFile exportFile = Cap.Import.exportfileForPackageToken(n3);
                efClass = exportFile.findClassByToken((short)n4);
                efField = efClass.getFieldForTokenAndFlag(n5, bl);
            }
        } else {
            int n6 = constantPoolEntry.classRefVirtualRef();
            int n7 = constantPoolEntry.tokenVirtualRef();
            if (Classref.isExternal(n6)) {
                bl2 = true;
                int n8 = Classref.packageToken(n6);
                ExportFile exportFile = Cap.Import.exportfileForPackageToken(n8);
                efClass = Classref.checkExternal(n6);
                efField = efClass.getFieldForTokenAndFlag(n7, bl);
            } else {
                classDescriptor = Classref.checkInternal(n6);
                fieldDescriptor = classDescriptor.getFieldDescriptorForToken(n7, bl);
            }
        }
        if (bl2) {
            string = efClass.thisName();
            string2 = efField.name();
            string3 = efField.sig();
        } else {
            string = CAPUtil.getRefName(classDescriptor.thisClass());
            efClass = null;
            if (CapProcessor.ef != null) {
                efClass = CapProcessor.ef.findClassByToken((short)classDescriptor.token());
            }
            string2 = CAPUtil.getClassFieldName(fieldDescriptor, efClass);
            string3 = CAPUtil.getFieldDescrStr((short)fieldDescriptor.type());
        }
        return this.getCPEntryIndexForClassMember(string, string2, string3, 9);
    }

    public int getMethodCPEntry(int n) {
        MethodDescriptor methodDescriptor = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        EfClass efClass = null;
        EfMethod efMethod = null;
        ClassDescriptor classDescriptor = null;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        int n2 = constantPoolEntry.tag();
        boolean bl = n2 == 6 || n2 == 7;
        boolean bl2 = n2 == 4 || n2 == 7 ? ConstantPoolComponent.methodIsInit(n) : false;
        boolean bl3 = false;
        if (bl) {
            if (!constantPoolEntry.isExternalStaticRef()) {
                int n3;
                classDescriptor = Cap.Descriptor.firstClassDescriptor();
                while (classDescriptor != null && (methodDescriptor = classDescriptor.getMethodDescriptorForLocation(n3 = constantPoolEntry.internalStaticRef())) == null) {
                    classDescriptor.next();
                }
            } else {
                bl3 = true;
                int n4 = constantPoolEntry.externalStaticRefPackageToken();
                int n5 = constantPoolEntry.externalStaticRefClassToken();
                int n6 = constantPoolEntry.tokenStaticRef();
                ExportFile exportFile = Cap.Import.exportfileForPackageToken(n4);
                efClass = exportFile.findClassByToken((short)n5);
                efMethod = efClass.getMethodForTokenAndFlag(n6, bl | bl2);
            }
        } else {
            int n7 = constantPoolEntry.classRefVirtualRef();
            int n8 = constantPoolEntry.tokenVirtualRef();
            if (Classref.isExternal(n7)) {
                bl3 = true;
                efClass = Classref.checkExternal(n7);
                efMethod = efClass.getMethodForTokenAndFlag(n8, bl | bl2);
            } else if (n2 == 4) {
                ClassInfo classInfo = Cap.Class.infoOfs(n7);
                int n9 = classInfo.superclass();
                while (n9 != 65535) {
                    if (Classref.isExternal(n9)) {
                        bl3 = true;
                        efClass = Classref.checkExternal(n9);
                        efMethod = efClass.getMethodForTokenAndFlag(n8, false);
                        if (efMethod == null) {
                            efMethod = efClass.getMethodFromSupers(n8, false);
                            efClass = efMethod.getParentClass();
                        }
                    } else {
                        classDescriptor = Classref.checkInternal(n9);
                        methodDescriptor = classDescriptor.getMethodDescriptorForToken(n8, bl, bl2);
                        if (methodDescriptor == null) {
                            classInfo = Cap.Class.infoOfs(n9);
                            n9 = classInfo.superclass();
                            continue;
                        }
                    }
                    break;
                }
            } else {
                classDescriptor = Classref.checkInternal(n7);
                methodDescriptor = classDescriptor.getMethodDescriptorForToken(n8, bl, bl2);
            }
        }
        if (bl3) {
            string = efClass.thisName();
            string2 = efMethod.name();
            string3 = efMethod.sig();
        } else {
            string = CAPUtil.getRefName(classDescriptor.thisClass());
            efClass = null;
            if (CapProcessor.ef != null) {
                efClass = CapProcessor.ef.findClassByToken((short)classDescriptor.token());
            }
            string2 = CAPUtil.getClassMethodName(methodDescriptor, bl, bl2, efClass);
            string3 = CAPUtil.getMethodDescriptorString((short)methodDescriptor.type());
        }
        return this.getCPEntryIndexForClassMember(string, string2, string3, 10);
    }

    public int getInterfaceMethodRef(int n, int n2) {
        int n3;
        Object object;
        Object object2;
        ConstantPoolEntry constantPoolEntry = Cap.ConstantPool.entry(n);
        int n4 = constantPoolEntry.classRef();
        String string = CAPUtil.getRefName(n4);
        String string2 = null;
        String string3 = null;
        if (Classref.isExternal(n4)) {
            object2 = Classref.checkExternal(n4);
            object = ((EfClass)object2).methods;
            for (n3 = 0; n3 < ((EfMethod[])object).length; ++n3) {
                if (object[n3].token != n2) continue;
                string2 = object[n3].name();
                string3 = object[n3].sig();
                break;
            }
        } else {
            object2 = Classref.checkInternal(n4);
            object = Classref.toExportClass(n4);
            MethodDescriptor methodDescriptor = Methodref.virtualMethodDescriptor((ClassDescriptor)object2, n2);
            string2 = CAPUtil.getClassMethodName(methodDescriptor, false, false, (EfClass)object);
            string3 = CAPUtil.getMethodDescriptorString(methodDescriptor.type());
        }
        short s = this.getClassRefIndex(string);
        int n5 = this.getUtf8InfoIndex(string2);
        n3 = this.getUtf8InfoIndex(string3);
        int n6 = this.setConstantPoolEntry(new CPNameAndTypeInfo((short)n5, (short)n3));
        return this.setConstantPoolEntry(new CPClassMemberInfo(11, s, (short)n6));
    }
}

